/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.press;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.components.press.MechanicalPressTileEntity;
import com.simibubi.create.content.contraptions.components.press.PressingRecipe;
import com.simibubi.create.content.contraptions.relays.belt.AllBeltAttachments;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class MechanicalPressBlock
extends HorizontalKineticBlock
implements ITE<MechanicalPressTileEntity>,
AllBeltAttachments.IBeltAttachment {
    public MechanicalPressBlock(Block.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (context.getEntity() instanceof PlayerEntity) {
            return AllShapes.CASING_14PX.get(Direction.DOWN);
        }
        return AllShapes.MECHANICAL_PROCESSOR_SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return !AllBlocks.BASIN.has(worldIn.func_180495_p(pos.func_177977_b()));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.field_72995_K) {
            return;
        }
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
            if (!worldIn.func_175640_z(pos)) {
                te.finished = false;
                return;
            }
            if (!te.finished && !te.running && te.getSpeed() != 0.0f) {
                te.start(MechanicalPressTileEntity.Mode.WORLD);
            }
        });
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.MECHANICAL_PRESS.create();
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction prefferedSide = this.getPreferredHorizontalFacing(context);
        if (prefferedSide != null) {
            return (BlockState)this.func_176223_P().func_206870_a(HORIZONTAL_FACING, (Comparable)prefferedSide);
        }
        return super.func_196258_a(context);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176740_k();
    }

    @Override
    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        return face.func_176740_k() == ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176740_k();
    }

    @Override
    protected boolean hasStaticPart() {
        return true;
    }

    @Override
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.onAttachmentPlaced((IWorld)worldIn, pos, state);
    }

    @Override
    public List<BlockPos> getPotentialAttachmentPositions(IWorld world, BlockPos pos, BlockState beltState) {
        return Arrays.asList(pos.func_177981_b(2));
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        this.onAttachmentRemoved((IWorld)worldIn, pos, state);
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            worldIn.func_175713_t(pos);
        }
    }

    @Override
    public BlockPos getBeltPositionForAttachment(IWorld world, BlockPos pos, BlockState state) {
        return pos.func_177979_c(2);
    }

    @Override
    public boolean isAttachedCorrectly(IWorld world, BlockPos attachmentPos, BlockPos beltPos, BlockState attachmentState, BlockState beltState) {
        return AllBlocks.BELT.has(beltState) && beltState.func_177229_b(BeltBlock.SLOPE) == BeltBlock.Slope.HORIZONTAL;
    }

    @Override
    public boolean startProcessingItem(BeltTileEntity belt, TransportedItemStack transported, AllBeltAttachments.BeltAttachmentState state) {
        try {
            MechanicalPressTileEntity pressTe = (MechanicalPressTileEntity)this.getTileEntity((IBlockReader)belt.func_145831_w(), state.attachmentPos);
            if (pressTe.getSpeed() == 0.0f) {
                return false;
            }
            if (pressTe.running) {
                return false;
            }
            if (!pressTe.getRecipe(transported.stack).isPresent()) {
                return false;
            }
            state.processingDuration = 1;
            pressTe.start(MechanicalPressTileEntity.Mode.BELT);
            return true;
        }
        catch (ITE.TileEntityException tileEntityException) {
            return false;
        }
    }

    @Override
    public boolean processItem(BeltTileEntity belt, TransportedItemStack transportedStack, AllBeltAttachments.BeltAttachmentState state) {
        try {
            MechanicalPressTileEntity pressTe = (MechanicalPressTileEntity)this.getTileEntity((IBlockReader)belt.func_145831_w(), state.attachmentPos);
            if (pressTe.getSpeed() == 0.0f) {
                return false;
            }
            if (!pressTe.running) {
                return false;
            }
            if (pressTe.runningTicks != 30) {
                return true;
            }
            Optional<PressingRecipe> recipe = pressTe.getRecipe(transportedStack.stack);
            pressTe.pressedItems.clear();
            pressTe.pressedItems.add(transportedStack.stack);
            if (!recipe.isPresent()) {
                return false;
            }
            ItemStack out = recipe.get().func_77571_b().func_77946_l();
            List<ItemStack> multipliedOutput = ItemHelper.multipliedOutput(transportedStack.stack, out);
            if (multipliedOutput.isEmpty()) {
                transportedStack.stack = ItemStack.field_190927_a;
            }
            transportedStack.stack = multipliedOutput.get(0);
            BeltTileEntity controllerTE = belt.getControllerTE();
            if (controllerTE != null) {
                controllerTE.sendData();
            }
            pressTe.sendData();
            return true;
        }
        catch (ITE.TileEntityException tileEntityException) {
            return false;
        }
    }

    @Override
    public Class<MechanicalPressTileEntity> getTileEntityClass() {
        return MechanicalPressTileEntity.class;
    }
}

