/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.BlockAutoSwitch;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModConfig;
import wile.rsgauges.detail.ModResources;

public class BlockEntityDetectorSwitch
extends BlockAutoSwitch {
    public BlockEntityDetectorSwitch(long config, Block.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    public BlockEntityDetectorSwitch(long config, Block.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, null, null);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityDetectorSwitch(ModContent.TET_DETECTOR_SWITCH);
    }

    public static class TileEntityDetectorSwitch
    extends BlockAutoSwitch.TileEntityAutoSwitch
    implements ITickableTileEntity {
        public static final Class<?>[] filter_classes = new Class[]{LivingEntity.class, PlayerEntity.class, MonsterEntity.class, AnimalEntity.class, VillagerEntity.class, ItemEntity.class, Entity.class};
        public static final String[] filter_class_names = new String[]{"creatures", "players", "mobs", "animals", "villagers", "objects", "everything"};
        private static final int max_sensor_range_ = 16;
        private int sensor_entity_count_threshold_ = 1;
        private int sensor_range_ = 5;
        private int filter_ = 0;
        private AxisAlignedBB area_ = null;
        private int update_interval_ = 8;
        private int update_timer_ = 0;

        public TileEntityDetectorSwitch(TileEntityType<?> te_type) {
            super(te_type);
        }

        public TileEntityDetectorSwitch() {
            super(ModContent.TET_DETECTOR_SWITCH);
        }

        public int filter() {
            return this.filter_;
        }

        public void filter(int sel) {
            this.filter_ = sel < 0 ? 0 : (sel >= filter_classes.length ? filter_classes.length - 1 : sel);
        }

        public Class<?> filter_class() {
            return this.filter_ <= 0 ? filter_classes[0] : (this.filter_ >= filter_classes.length ? filter_classes[filter_classes.length - 1] : filter_classes[this.filter_]);
        }

        public void sensor_entity_threshold(int count) {
            this.sensor_entity_count_threshold_ = count < 1 ? 1 : count;
        }

        public int sensor_entity_threshold() {
            return this.sensor_entity_count_threshold_;
        }

        public void sensor_range(int r) {
            this.sensor_range_ = r < 1 ? 1 : (r > 16 ? 16 : r);
        }

        public int sensor_range() {
            return this.sensor_range_;
        }

        @Override
        public void writeNbt(CompoundNBT nbt, boolean updatePacket) {
            super.writeNbt(nbt, updatePacket);
            nbt.func_74768_a("range", this.sensor_range_);
            nbt.func_74768_a("entitythreshold", this.sensor_entity_count_threshold_);
            nbt.func_74768_a("filter", this.filter_);
        }

        @Override
        public void readNbt(CompoundNBT nbt, boolean updatePacket) {
            super.readNbt(nbt, updatePacket);
            this.sensor_range(nbt.func_74762_e("range"));
            this.sensor_entity_threshold(nbt.func_74762_e("entitythreshold"));
            this.filter(nbt.func_74762_e("filter"));
        }

        @Override
        public void reset() {
            super.reset();
            this.update_timer_ = 0;
            this.area_ = null;
            this.sensor_range_ = 5;
            this.filter_ = 0;
        }

        @Override
        public boolean activation_config(BlockState state, @Nullable PlayerEntity player, double x, double y) {
            int field;
            int direction;
            if (state == null) {
                return false;
            }
            int n = y >= 12.0 ? 1 : (direction = y <= 5.0 ? -1 : 0);
            int n2 = x >= 2.0 && x <= 3.95 ? 1 : (x >= 4.25 && x <= 7.0 ? 2 : (x >= 8.0 && x <= 10.0 ? 3 : (field = x >= 11.0 && x <= 13.0 ? 4 : 0)));
            if (direction == 0 || field == 0) {
                return false;
            }
            switch (field) {
                case 1: {
                    this.sensor_range(this.sensor_range() + direction);
                    this.area_ = null;
                    ModAuxiliaries.playerStatusMessage(player, (ITextComponent)ModAuxiliaries.localizable("switchconfig.detector.sensor_range", TextFormatting.BLUE, this.sensor_range()));
                    break;
                }
                case 2: {
                    this.sensor_entity_threshold(this.sensor_entity_threshold() + direction);
                    ModAuxiliaries.playerStatusMessage(player, (ITextComponent)ModAuxiliaries.localizable("switchconfig.detector.entity_threshold", TextFormatting.YELLOW, this.sensor_entity_threshold()));
                    break;
                }
                case 3: {
                    this.filter(this.filter() + direction);
                    ModAuxiliaries.playerStatusMessage(player, (ITextComponent)ModAuxiliaries.localizable("switchconfig.detector.entity_filter", TextFormatting.DARK_GREEN, new TranslationTextComponent("rsgauges.switchconfig.detector.entity_filter." + filter_class_names[this.filter()], new Object[0])));
                    break;
                }
                case 4: {
                    this.on_power(this.on_power() + direction);
                    if (this.on_power() < 1) {
                        this.on_power(1);
                    }
                    ModAuxiliaries.playerStatusMessage(player, (ITextComponent)ModAuxiliaries.localizable("switchconfig.detector.output_power", TextFormatting.RED, this.on_power()));
                }
            }
            this.func_70296_d();
            return true;
        }

        public void func_73660_a() {
            if (ModConfig.without_detector_switch_update) {
                return;
            }
            if (this.field_145850_b.field_72995_K || --this.update_timer_ > 0) {
                return;
            }
            this.update_timer_ = this.update_interval_;
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            if (state == null || !(state.func_177230_c() instanceof BlockAutoSwitch)) {
                return;
            }
            BlockAutoSwitch block = (BlockAutoSwitch)state.func_177230_c();
            if (this.update_interval_ == 0) {
                this.update_interval_ = (block.config & 0x800000000L) != 0L ? ModConfig.autoswitch_linear_update_interval : ModConfig.autoswitch_volumetric_update_interval;
            }
            if (this.area_ == null) {
                int size = this.sensor_range();
                AxisAlignedBB range_bb = (block.config & 0x400000000L) != 0L ? new AxisAlignedBB(0.0, -2.0, (double)(-size), (double)size, 2.0, (double)size) : ((block.config & 0x800000000L) != 0L ? new AxisAlignedBB(-0.5, -0.5, -0.5, (double)size, 0.5, 0.5) : new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0, 0.0));
                Direction facing = (Direction)state.func_177229_b((IProperty)RsDirectedBlock.FACING);
                AxisAlignedBB bb = ModAuxiliaries.transform_forward(range_bb, facing).func_186670_a(this.func_174877_v()).func_72321_a(1.0, 1.0, 1.0);
                this.area_ = new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
            }
            boolean active = false;
            List hits = this.field_145850_b.func_217357_a(this.filter_class(), this.area_);
            if (hits.size() >= this.sensor_entity_count_threshold_) {
                int num_seen = 0;
                Vec3d switch_position = new Vec3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
                for (Entity e : hits) {
                    if (this.field_145850_b.func_217299_a(new RayTraceContext(new Vec3d((double)e.func_180425_c().func_177958_n() - 0.2, (double)((float)e.func_180425_c().func_177956_o() + e.func_70047_e()), (double)e.func_180425_c().func_177952_p() - 0.2), switch_position, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, e)).func_216346_c() == RayTraceResult.Type.BLOCK && this.field_145850_b.func_217299_a(new RayTraceContext(new Vec3d((double)e.func_180425_c().func_177958_n() + 0.2, (double)((float)e.func_180425_c().func_177956_o() + e.func_70047_e()), (double)e.func_180425_c().func_177952_p() + 0.2), switch_position, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, e)).func_216346_c() == RayTraceResult.Type.BLOCK || ++num_seen < this.sensor_entity_count_threshold_) continue;
                    active = true;
                    break;
                }
            }
            this.updateSwitchState(state, block, active, this.configured_on_time());
        }
    }
}

