/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.raytracer;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class MergedVoxelShapeHolder<T> {
    private final Set<VoxelShape> shapeParts = new HashSet<VoxelShape>();
    private final Set<VoxelShape> partCache = new HashSet<VoxelShape>();
    private VoxelShape mergedShape;
    private Function<T, VoxelShape> extractor;
    private Function<VoxelShape, VoxelShape> postProcess;

    public MergedVoxelShapeHolder<T> setExtractor(Function<T, VoxelShape> extractor) {
        this.extractor = extractor;
        return this;
    }

    public MergedVoxelShapeHolder<T> setPostProcessHook(Function<VoxelShape, VoxelShape> postProcess) {
        this.postProcess = postProcess;
        return this;
    }

    public void clear() {
        this.shapeParts.clear();
        this.partCache.clear();
        this.mergedShape = null;
    }

    public VoxelShape update(Collection<T> things) {
        this.partCache.clear();
        for (T thing : things) {
            this.partCache.add(this.extractor.apply(thing));
        }
        if (!this.partCache.equals(this.shapeParts) || this.mergedShape == null) {
            this.shapeParts.clear();
            this.shapeParts.addAll(this.partCache);
            VoxelShape merged = this.shapeParts.stream().reduce(VoxelShapes.func_197880_a(), VoxelShapes::func_197872_a);
            this.mergedShape = this.postProcess.apply(merged);
        }
        return this.mergedShape;
    }
}

