/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config;

import codechicken.lib.config.ConfigTag;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.internal.network.CCLNetwork;
import codechicken.lib.packet.PacketCustom;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigSyncManager {
    private static final Logger logger = LogManager.getLogger();
    private static final Map<ResourceLocation, ConfigTag> syncMap = new HashMap<ResourceLocation, ConfigTag>();
    private static final Map<ResourceLocation, SyncState> clientRollbackMap = new HashMap<ResourceLocation, SyncState>();

    public static void registerSync(ResourceLocation id, ConfigTag tag) {
        syncMap.put(id, tag);
    }

    public static void handleLogin(BiConsumer<String, Supplier<PacketCustom>> consumer) {
        if (syncMap.isEmpty()) {
            logger.info("Skipping config sync, No mods have registered a syncable config.");
            return;
        }
        consumer.accept("config_sync", () -> {
            PacketCustom packet = new PacketCustom(CCLNetwork.NET_CHANNEL, 1);
            packet.writeVarInt(syncMap.size());
            for (Map.Entry<ResourceLocation, ConfigTag> entry : syncMap.entrySet()) {
                packet.writeResourceLocation(entry.getKey());
                SyncState.create(entry.getValue()).write(packet);
            }
            String mods = Joiner.on((String)", ").join(syncMap.keySet());
            logger.info("Sending config sync packet to player. Mods: " + mods);
            return packet;
        });
    }

    public static void readSyncPacket(PacketCustom packet) {
        int numStates = packet.readVarInt();
        for (int i = 0; i < numStates; ++i) {
            ResourceLocation ident = packet.readResourceLocation();
            logger.log(Level.INFO, "Applying config sync for {}.", (Object)ident);
            ConfigTag found = syncMap.get(ident);
            SyncState state = SyncState.create(found.copy());
            clientRollbackMap.put(ident, state);
            SyncState.applyTo(packet, found);
        }
    }

    @Mod.EventBusSubscriber(modid="codechickenlib", value={Dist.CLIENT})
    public static class EventHandler {
        @SubscribeEvent
        public static void onClientDisconnected(ClientPlayerNetworkEvent.LoggedOutEvent event) {
            for (Map.Entry entry : clientRollbackMap.entrySet()) {
                logger.log(Level.INFO, "Client disconnect, rolling back config for {}.", entry.getKey());
                ((SyncState)entry.getValue()).revert((ConfigTag)syncMap.get(entry.getKey()));
            }
            clientRollbackMap.clear();
        }
    }

    public static class SyncState {
        public List<ConfigTag> syncTags = new ArrayList<ConfigTag>();

        public static SyncState create(ConfigTag tag) {
            SyncState state = new SyncState();
            tag.walkTags(e -> {
                if (!e.isCategory() && e.requiresSync()) {
                    state.syncTags.add((ConfigTag)e);
                }
            });
            return state;
        }

        public static void applyTo(MCDataInput in, ConfigTag parent) {
            SyncState master = SyncState.create(parent);
            Map lookup = master.syncTags.stream().collect(Collectors.toMap(ConfigTag::getQualifiedName, Function.identity()));
            int numTags = in.readVarInt();
            for (int i = 0; i < numTags; ++i) {
                String ident = in.readString();
                ConfigTag found = (ConfigTag)lookup.get(ident);
                if (found == null) {
                    throw new RuntimeException("Unable to apply server sync, tag does not exist! " + ident);
                }
                found.read(in);
            }
            try {
                parent.runSync(ConfigTag.SyncType.CONNECT);
            }
            catch (ConfigTag.SyncException e) {
                throw new RuntimeException("Unable to apply server sync, SyncException thrown!", e);
            }
        }

        public void revert(ConfigTag parent) {
            SyncState master = SyncState.create(parent);
            HashMap<String, ConfigTag> lookup = new HashMap<String, ConfigTag>();
            for (ConfigTag tag : master.syncTags) {
                lookup.put(tag.getQualifiedName(), tag);
            }
            for (ConfigTag tag : this.syncTags) {
                ConfigTag found = (ConfigTag)lookup.get(tag.getQualifiedName());
                if (found == null) {
                    throw new RuntimeException("Unable to revert config state, tag no longer exists.. " + tag.getQualifiedName());
                }
                found.copyFrom(tag);
            }
            try {
                parent.runSync(ConfigTag.SyncType.DISCONNECT);
            }
            catch (ConfigTag.SyncException e) {
                throw new RuntimeException("Unable to revert server sync, SyncException thrown!", e);
            }
        }

        public void write(MCDataOutput out) {
            out.writeVarInt(this.syncTags.size());
            for (ConfigTag tag : this.syncTags) {
                out.writeString(tag.getQualifiedName());
                tag.write(out);
            }
        }
    }
}

