/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.FractionalDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import com.jaquadro.minecraft.storagedrawers.network.MessageHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;

public class TileEntityDrawersComp
extends TileEntityDrawers {
    @CapabilityInject(value=IDrawerAttributes.class)
    static Capability<IDrawerAttributes> DRAWER_ATTRIBUTES_CAPABILITY = null;

    public TileEntityDrawersComp(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    @Override
    public IDrawerGroup getGroup() {
        return null;
    }

    @Override
    protected boolean emptySlotCanBeCleared(int slot) {
        if (slot != 0) {
            return false;
        }
        if (this.getGroup() instanceof FractionalDrawerGroup) {
            FractionalDrawerGroup fracGroup = (FractionalDrawerGroup)this.getGroup();
            return !this.getGroup().getDrawer(0).isEmpty() && fracGroup.getPooledCount() == 0;
        }
        return false;
    }

    @Override
    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientUpdateCount(int slot, int count) {
        if (!this.func_145831_w().field_72995_K) {
            return;
        }
        Minecraft.func_71410_x().func_212871_a_(() -> this.clientUpdateCountAsync(count));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientUpdateCountAsync(int count) {
        if (this.getGroup() instanceof FractionalDrawerGroup) {
            ((FractionalDrawerGroup)this.getGroup()).setPooledCount(count);
        }
    }

    private class GroupData
    extends FractionalDrawerGroup {
        private final LazyOptional<?> capabilityAttributes;

        public GroupData(int slotCount) {
            super(slotCount);
            this.capabilityAttributes = LazyOptional.of(TileEntityDrawersComp.this::getDrawerAttributes);
        }

        @Override
        protected World getWorld() {
            return TileEntityDrawersComp.this.func_145831_w();
        }

        @Override
        public boolean isGroupValid() {
            return TileEntityDrawersComp.this.isGroupValid();
        }

        @Override
        protected void log(String message) {
            if (!this.getWorld().field_72995_K && ((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue()) {
                StorageDrawers.log.info(message);
            }
        }

        @Override
        protected int getStackCapacity() {
            return TileEntityDrawersComp.this.upgrades().getStorageMultiplier() * TileEntityDrawersComp.this.getEffectiveDrawerCapacity();
        }

        @Override
        protected void onItemChanged() {
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                int usedSlots = 0;
                for (int slot : this.getAccessibleDrawerSlots()) {
                    IFractionalDrawer drawer = this.getDrawer(slot);
                    if (drawer == null || drawer.isEmpty()) continue;
                    ++usedSlots;
                }
                usedSlots = Math.max(usedSlots, 1);
                EnumCompDrawer open = (EnumCompDrawer)((Object)TileEntityDrawersComp.this.func_195044_w().func_177229_b(BlockCompDrawers.SLOTS));
                if (open.getOpenSlots() != usedSlots) {
                    this.getWorld().func_180501_a(TileEntityDrawersComp.this.field_174879_c, (BlockState)TileEntityDrawersComp.this.func_195044_w().func_206870_a(BlockCompDrawers.SLOTS, (Comparable)((Object)EnumCompDrawer.byOpenSlots(usedSlots))), 3);
                }
                TileEntityDrawersComp.this.func_70296_d();
                TileEntityDrawersComp.this.markBlockForUpdate();
            }
        }

        @Override
        protected void onAmountChanged() {
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint((double)TileEntityDrawersComp.this.func_174877_v().func_177958_n(), (double)TileEntityDrawersComp.this.func_174877_v().func_177956_o(), (double)TileEntityDrawersComp.this.func_174877_v().func_177952_p(), 500.0, this.getWorld().field_73011_w.func_186058_p());
                MessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> point), (Object)new CountUpdateMessage(TileEntityDrawersComp.this.func_174877_v(), 0, this.getPooledCount()));
                TileEntityDrawersComp.this.func_70296_d();
            }
        }

        @Override
        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            if (capability == DRAWER_ATTRIBUTES_CAPABILITY) {
                return this.capabilityAttributes.cast();
            }
            return super.getCapability(capability, facing);
        }
    }

    public static class Slot3
    extends TileEntityDrawersComp {
        private GroupData groupData = new GroupData(3);

        public Slot3() {
            super(ModBlocks.Tile.FRACTIONAL_DRAWERS_3);
            this.groupData.setCapabilityProvider(this);
            this.injectPortableData(this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }
}

