/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.menu;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.xml.ws.Holder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.INamedElement;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.widget.mixin.LeafWidgetMixin;
import vswe.stevesfactory.library.gui.widget.slot.AbstractItemSlot;
import vswe.stevesfactory.library.gui.window.PlayerInventoryWindow;
import vswe.stevesfactory.ui.manager.menu.MultiLayerMenu;

public abstract class ConfigurableSlot<E extends IWidget>
extends AbstractWidget
implements INamedElement,
LeafWidgetMixin {
    public static final TextureWrapper NORMAL = TextureWrapper.ofFlowComponent(36, 20, 16, 16);
    public static final TextureWrapper HOVERED = NORMAL.toDown(1);
    protected ItemStack stack;
    protected E editor;

    public ConfigurableSlot(ItemStack stack) {
        this.stack = stack;
        this.setDimensions(NORMAL.getPortionWidth(), NORMAL.getPortionHeight());
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
        this.onSetStack();
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.getAbsoluteX();
        int y = this.getAbsoluteY();
        if (this.isInside(mouseX, mouseY)) {
            HOVERED.draw(x, y);
            if (!this.stack.func_190926_b()) {
                WidgetScreen.getCurrent().setHoveringText(this.stack, mouseX, mouseY);
            }
        } else {
            NORMAL.draw(x, y);
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableTexture();
        RenderHelper.func_227780_a_();
        ItemRenderer ir = Minecraft.func_71410_x().func_175599_af();
        ir.func_180450_b(this.stack, x, y);
        ir.func_180453_a(RenderingHelper.fontRenderer(), this.stack, x, y, "");
        RenderHelper.func_74518_a();
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.onLeftClick();
            return true;
        }
        if (button == 1) {
            this.onRightClick();
            return true;
        }
        return false;
    }

    protected void onLeftClick() {
        this.openInventoryPopup();
    }

    protected void onRightClick() {
        if (!this.stack.func_190926_b()) {
            this.openEditor();
        }
    }

    protected abstract boolean hasEditor();

    protected abstract E createEditor();

    public void openEditor() {
        if (!this.hasEditor()) {
            return;
        }
        if (this.editor == null) {
            this.editor = (IWidget)Preconditions.checkNotNull(this.createEditor());
        }
        this.getMenu().openEditor((IWidget)this.editor);
    }

    public void closeEditor() {
        this.getMenu().openEditor(null);
    }

    public void openInventoryPopup() {
        Holder selected = new Holder();
        PlayerInventoryWindow popup = PlayerInventoryWindow.atCursor(in -> new AbstractItemSlot((ItemStack)in, selected){
            private ItemStack representative;
            final /* synthetic */ ItemStack val$in;
            final /* synthetic */ Holder val$selected;
            {
                this.val$in = itemStack;
                this.val$selected = holder;
            }

            @Override
            public ItemStack getRenderedStack() {
                return this.val$in;
            }

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (this.isSelected() || this.val$in.func_190926_b()) {
                    this.val$selected.value = null;
                    ConfigurableSlot.this.stack = ItemStack.field_190927_a;
                    ConfigurableSlot.this.onSetStack();
                } else {
                    this.val$selected.value = this;
                    ConfigurableSlot.this.stack = this.getRepresentative();
                    ConfigurableSlot.this.onSetStack();
                }
                return true;
            }

            @Override
            protected void renderBase() {
                super.renderBase();
                if (this.isSelected() && !this.val$in.func_190926_b()) {
                    RenderingHelper.useBlendingGLStates();
                    RenderingHelper.drawRect(this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteXRight(), this.getAbsoluteYBottom(), 0x66FFFF00);
                    RenderSystem.disableBlend();
                    RenderSystem.enableTexture();
                }
            }

            private boolean isSelected() {
                return this.val$selected.value == this;
            }

            private ItemStack getRepresentative() {
                if (this.representative == null) {
                    this.representative = this.val$in.func_77946_l();
                    this.representative.func_190920_e(1);
                }
                return this.representative;
            }
        });
        WidgetScreen.getCurrent().addPopupWindow(popup);
    }

    protected void onSetStack() {
    }

    @Nonnull
    public MultiLayerMenu<?> getMenu() {
        IWidget parentWidget = Objects.requireNonNull(super.getParentWidget());
        return (MultiLayerMenu)Objects.requireNonNull(parentWidget.getParentWidget());
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)this.stack.func_77977_a(), (Object[])new Object[0]);
    }
}

