/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.widget.box;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.gui.GuiUtils;
import vswe.stevesfactory.Config;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.ScissorTest;
import vswe.stevesfactory.library.gui.debug.ITextReceiver;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.widget.AbstractContainer;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.utils.Utils;

public class LinearList<T extends IWidget>
extends AbstractContainer<T>
implements IWidget {
    private boolean scrolling;
    protected float scrollDistance;
    private final List<T> elements = new ArrayList<T>();

    public LinearList(int width, int height) {
        super(0, 0, width, height);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean bl = this.scrolling = button == 0 && this.isInsideBar(mouseX, mouseY) && this.isDrawingScrollBar();
        if (this.scrolling) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private boolean isInsideBar(double mouseX, double mouseY) {
        int barLeftX = this.getAbsBarLeft();
        return mouseX >= (double)barLeftX && mouseX < (double)(barLeftX + this.getBarWidth()) && mouseY >= (double)this.getAbsoluteY() && mouseY < (double)this.getAbsoluteYBottom();
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isInside(mouseX, mouseY)) {
            boolean ret = this.scrolling;
            this.scrolling = false;
            return ret;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.scrolling) {
            int maxScroll = this.getHeight() - this.getBarHeight();
            double moved = deltaY / (double)maxScroll;
            this.scrollDistance = (float)((double)this.scrollDistance + (double)this.getMaxScroll() * moved);
            this.applyScrollLimits();
            this.reflow();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (super.mouseScrolled(mouseX, mouseY, scroll)) {
            return true;
        }
        if (this.isInside(mouseX, mouseY) && scroll != 0.0) {
            this.scrollDistance = (float)((double)this.scrollDistance + -scroll * (double)this.getScrollAmount());
            this.applyScrollLimits();
            this.reflow();
            return true;
        }
        return false;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.isEnabled()) {
            RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
            this.drawBackground();
            int left = this.getAbsoluteX();
            int top = this.getAbsoluteY();
            int right = this.getAbsoluteXRight();
            int bottom = this.getAbsoluteYBottom();
            int width = this.getWidth();
            int height = this.getHeight();
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder renderer = tess.func_178180_c();
            ScissorTest test = ScissorTest.scaled(left, top, width, height);
            for (IWidget child : this.getChildren()) {
                child.render(mouseX, mouseY, partialTicks);
            }
            this.drawOverlay();
            int extraHeight = this.getBarExtraHeight();
            if (extraHeight > 0 && this.isDrawingScrollBar()) {
                int barWidth = this.getBarWidth();
                int barHeight = this.getBarHeight();
                int barTopY = Utils.lowerBound((int)this.scrollDistance * (height - barHeight) / extraHeight + top, top);
                int barBottomY = barTopY + barHeight;
                int barLeftX = this.getAbsBarLeft();
                int barRightX = barLeftX + barWidth;
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                RenderingHelper.rectVertices(barLeftX, top, barRightX, bottom, this.getShadowColor());
                RenderingHelper.rectVertices(barLeftX, barTopY, barRightX, barBottomY, this.getBarBorderColor());
                RenderingHelper.rectVertices(barLeftX, barTopY, barRightX - 1, barBottomY - 1, this.getBarBodyColor());
                tess.func_78381_a();
                RenderSystem.enableTexture();
            }
            test.destroy();
            RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
        }
    }

    protected boolean isDrawingScrollBar() {
        return true;
    }

    public int getBarBodyColor() {
        return -4144960;
    }

    public int getBarBorderColor() {
        return -8355712;
    }

    public int getShadowColor() {
        return -16777216;
    }

    protected void drawOverlay() {
    }

    protected final void drawDefaultOverlay() {
        int left = this.getAbsoluteX();
        int top = this.getAbsoluteY();
        int right = this.getAbsoluteXRight();
        int bottom = this.getAbsoluteYBottom();
        if (Minecraft.func_71410_x().field_71441_e != null) {
            GuiUtils.drawGradientRect((int)0, (int)left, (int)top, (int)right, (int)bottom, (int)-1072689136, (int)-804253680);
        } else {
            RenderSystem.disableLighting();
            RenderSystem.disableFog();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AbstractGui.BACKGROUND_LOCATION);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float texScale = 32.0f;
            BufferBuilder renderer = RenderingHelper.getRenderer();
            renderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            renderer.func_225582_a_((double)left, (double)bottom, 0.0).func_225583_a_((float)left / texScale, (float)(bottom + (int)this.scrollDistance) / texScale).func_225586_a_(32, 32, 32, 255).func_181675_d();
            renderer.func_225582_a_((double)right, (double)bottom, 0.0).func_225583_a_((float)right / texScale, (float)(bottom + (int)this.scrollDistance) / texScale).func_225586_a_(32, 32, 32, 255).func_181675_d();
            renderer.func_225582_a_((double)right, (double)top, 0.0).func_225583_a_((float)right / texScale, (float)(top + (int)this.scrollDistance) / texScale).func_225586_a_(32, 32, 32, 255).func_181675_d();
            renderer.func_225582_a_((double)left, (double)top, 0.0).func_225583_a_((float)left / texScale, (float)(top + (int)this.scrollDistance) / texScale).func_225586_a_(32, 32, 32, 255).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    protected void drawBackground() {
    }

    @Override
    public List<T> getChildren() {
        return this.elements;
    }

    @Override
    public void reflow() {
        int offset = (int)(-this.scrollDistance);
        int y = this.getBorder();
        for (IWidget child : this.getChildren()) {
            child.setY(y + offset);
            y += child.getHeight() + this.getMarginMiddle();
        }
    }

    @Override
    public LinearList<T> addChildren(T widget) {
        widget.setParentWidget(this);
        this.elements.add(widget);
        return this;
    }

    @Override
    public LinearList<T> addChildren(Collection<T> widgets) {
        this.elements.addAll(widgets);
        for (IWidget widget : widgets) {
            widget.setParentWidget(this);
        }
        return this;
    }

    protected int getContentHeight() {
        int contentHeight = 0;
        for (IWidget child : this.getChildren()) {
            contentHeight += child.getHeight() + this.getMarginMiddle();
        }
        return contentHeight - this.getMarginMiddle();
    }

    public int getFirstRowY() {
        return this.getAbsoluteY() + this.getBorder();
    }

    public int getScrollAmount() {
        return (Integer)Config.CLIENT.scrollSpeed.get();
    }

    public int getMarginMiddle() {
        return 4;
    }

    public int getBarLeft() {
        return this.getX() + this.getWidth() - this.getBarWidth();
    }

    public int getAbsBarLeft() {
        return this.getAbsoluteX() + this.getBarLeft();
    }

    public int getMaxScroll() {
        return this.getContentHeight() - (this.getHeight() - this.getBorder());
    }

    private void applyScrollLimits() {
        int max = Utils.lowerBound(this.getMaxScroll(), 0);
        this.scrollDistance = MathHelper.func_76131_a((float)this.scrollDistance, (float)0.0f, (float)max);
    }

    public int getBarWidth() {
        return 6;
    }

    public int getBarHeight() {
        int height = this.getHeight();
        return MathHelper.func_76125_a((int)(height * height / this.getContentHeight()), (int)32, (int)(height - this.getBorder() * 2));
    }

    public int getAbsBarTop() {
        int top = this.getAbsoluteY();
        return Utils.lowerBound((int)this.scrollDistance * (this.getHeight() - this.getBarHeight()) / this.getBarExtraHeight() + top, top);
    }

    public int getAbsBarBottom() {
        return this.getAbsBarTop() + this.getBarHeight();
    }

    public int getBarExtraHeight() {
        return this.getContentHeight() + this.getBorder() - this.getHeight();
    }

    public int getBorder() {
        return 4;
    }

    public float getScrollDistance() {
        return this.scrollDistance;
    }

    public void setScrollDistance(float scrollDistance) {
        this.scrollDistance = scrollDistance;
        this.applyScrollLimits();
        this.reflow();
    }

    @Override
    public void provideInformation(ITextReceiver receiver) {
        super.provideInformation(receiver);
        receiver.line("Offset=" + this.scrollDistance);
    }
}

