/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.utils;

import com.davenonymous.libnonymous.utils.Logz;
import com.davenonymous.libnonymous.utils.MCJsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.IProperty;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockStateSerializationHelper {
    public static CompoundNBT serializeBlockStateToNBT(BlockState state) {
        CompoundNBT result = new CompoundNBT();
        Block block = state.func_177230_c();
        result.func_74778_a("block", block.getRegistryName().toString());
        if (state.func_206869_a().size() > 0) {
            CompoundNBT propertiesTag = new CompoundNBT();
            for (IProperty property : state.func_206869_a()) {
                propertiesTag.func_74778_a(property.func_177701_a(), state.func_177229_b(property).toString());
            }
            result.func_218657_a("properties", (INBT)propertiesTag);
        }
        return result;
    }

    public static BlockState deserializeBlockState(CompoundNBT nbt) {
        if (!nbt.func_74764_b("block")) {
            Logz.warn("NBT compound {} is not a blockstate", nbt);
            return null;
        }
        ResourceLocation blockId = ResourceLocation.func_208304_a((String)nbt.func_74779_i("block"));
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockId);
        if (block == null) {
            Logz.warn("Unknown block {} in NBT package", nbt.func_74779_i("block"));
            return null;
        }
        BlockState state = block.func_176223_P();
        if (nbt.func_74764_b("properties")) {
            CompoundNBT propertiesTag = nbt.func_74775_l("properties");
            for (String propertyName : propertiesTag.func_150296_c()) {
                IProperty blockProperty = block.func_176194_O().func_185920_a(propertyName);
                if (blockProperty == null) {
                    Logz.warn("The property '{}' is not valid for block {}", propertyName, blockId);
                    continue;
                }
                String valueString = propertiesTag.func_74779_i(propertyName);
                Optional propValue = blockProperty.func_185929_b(valueString);
                if (!propValue.isPresent()) {
                    Logz.warn("The property '{}' with value '{}' could not be parsed!", propertyName, valueString);
                    continue;
                }
                try {
                    state = (BlockState)state.func_206870_a(blockProperty, (Comparable)propValue.get());
                }
                catch (Exception e) {
                    Logz.warn("Failed to update state for block {}. The mod that adds this block has issues.", block.getRegistryName());
                }
            }
        }
        return state;
    }

    public static void serializeBlockState(PacketBuffer buffer, BlockState state) {
        buffer.func_192572_a(state.func_177230_c().getRegistryName());
        Collection properties = state.func_206869_a();
        buffer.writeInt(properties.size());
        for (IProperty property : properties) {
            buffer.func_180714_a(property.func_177701_a());
            buffer.func_180714_a(state.func_177229_b(property).toString());
        }
    }

    public static BlockState deserializeBlockState(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
        if (block != null) {
            int size = buffer.readInt();
            BlockState state = block.func_176223_P();
            for (int i = 0; i < size; ++i) {
                Optional propValue;
                String propName = buffer.func_218666_n();
                String value = buffer.func_218666_n();
                IProperty blockProperty = block.func_176194_O().func_185920_a(propName);
                if (blockProperty == null || !(propValue = blockProperty.func_185929_b(value)).isPresent()) continue;
                try {
                    state = (BlockState)state.func_206870_a(blockProperty, (Comparable)propValue.get());
                    continue;
                }
                catch (Exception e) {
                    Logz.error("Failed to read state for block {}. The mod that adds this block has issues.", block.getRegistryName());
                }
            }
            return state;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static JsonObject serializeBlockState(BlockState state) {
        JsonObject result = new JsonObject();
        Block block = state.func_177230_c();
        result.addProperty("block", block.getRegistryName().toString());
        if (state.func_206869_a().size() > 0) {
            JsonObject propertiesObj = new JsonObject();
            for (IProperty property : state.func_206869_a()) {
                propertiesObj.addProperty(property.func_177701_a(), state.func_177229_b(property).toString());
            }
            result.add("properties", (JsonElement)propertiesObj);
        }
        return result;
    }

    public static boolean isValidBlockState(JsonObject json) {
        String blockName = json.get("block").getAsString();
        if (blockName.equals("minecraft:air")) {
            return true;
        }
        Block block = MCJsonUtils.getBlock(json, "block");
        return block != null && !block.getRegistryName().toString().equals("minecraft:air");
    }

    public static BlockState deserializeBlockState(JsonObject json) {
        Block block = MCJsonUtils.getBlock(json, "block");
        BlockState state = block.func_176223_P();
        if (json.has("properties")) {
            JsonElement propertiesElement = json.get("properties");
            if (propertiesElement.isJsonObject()) {
                JsonObject props = propertiesElement.getAsJsonObject();
                for (Map.Entry property : props.entrySet()) {
                    IProperty blockProperty = block.func_176194_O().func_185920_a((String)property.getKey());
                    if (blockProperty != null) {
                        if (((JsonElement)property.getValue()).isJsonPrimitive()) {
                            String valueString = ((JsonElement)property.getValue()).getAsString();
                            Optional propValue = blockProperty.func_185929_b(valueString);
                            if (propValue.isPresent()) {
                                try {
                                    state = (BlockState)state.func_206870_a(blockProperty, (Comparable)propValue.get());
                                }
                                catch (Exception e) {
                                    Logz.error("Failed to update state for block {}. The mod that adds this block has issues.", block.getRegistryName());
                                }
                                continue;
                            }
                            throw new JsonSyntaxException("The property " + (String)property.getKey() + " with value " + valueString + " could not be parsed!");
                        }
                        throw new JsonSyntaxException("Expected property value for " + (String)property.getKey() + " to be primitive string. Got " + JSONUtils.func_151222_d((JsonElement)((JsonElement)property.getValue())));
                    }
                    throw new JsonSyntaxException("The property " + (String)property.getKey() + " is not valid for block " + block.getRegistryName());
                }
            } else {
                throw new JsonSyntaxException("Expected properties to be an object. Got " + JSONUtils.func_151222_d((JsonElement)propertiesElement));
            }
        }
        return state;
    }
}

