/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.serialization.packetbuffer;

import com.davenonymous.libnonymous.utils.BlockStateSerializationHelper;
import com.davenonymous.libnonymous.utils.Logz;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.lang3.tuple.Pair;

public class PacketBufferFieldHandlers {
    private static final Map<Class<?>, Pair<Reader, Writer>> packetBufferHandlers = new HashMap();

    public static <T> void addIOHandler(Class<T> type, Reader<T> reader, Writer<T> writer) {
        packetBufferHandlers.put(type, (Pair<Reader, Writer>)Pair.of(reader, writer));
    }

    public static boolean hasIOHandler(Class clz) {
        if (packetBufferHandlers.containsKey(clz)) {
            return true;
        }
        for (Class<?> iface : clz.getInterfaces()) {
            if (!packetBufferHandlers.containsKey(iface)) continue;
            return true;
        }
        Class superClass = clz.getSuperclass();
        if (superClass == null) {
            return false;
        }
        return PacketBufferFieldHandlers.hasIOHandler(superClass);
    }

    public static Pair<Reader, Writer> getIOHandler(Class clz) {
        if (packetBufferHandlers.containsKey(clz)) {
            return packetBufferHandlers.get(clz);
        }
        for (Class<?> iface : clz.getInterfaces()) {
            if (!packetBufferHandlers.containsKey(iface)) continue;
            return packetBufferHandlers.get(iface);
        }
        Class superClass = clz.getSuperclass();
        if (superClass == null) {
            return null;
        }
        return PacketBufferFieldHandlers.getIOHandler(superClass);
    }

    static {
        PacketBufferFieldHandlers.addIOHandler(boolean[].class, buf -> {
            int size = buf.readInt();
            boolean[] result = new boolean[size];
            for (int i = 0; i < size; ++i) {
                result[i] = buf.readBoolean();
            }
            return result;
        }, (booleans, buf) -> {
            buf.writeInt(((boolean[])booleans).length);
            for (boolean b : booleans) {
                buf.writeBoolean(b);
            }
        });
        PacketBufferFieldHandlers.addIOHandler(Boolean.TYPE, buf -> buf.readBoolean(), (b, buf) -> buf.writeBoolean(b.booleanValue()));
        PacketBufferFieldHandlers.addIOHandler(Boolean.class, buf -> buf.readBoolean(), (b, buf) -> buf.writeBoolean(b.booleanValue()));
        PacketBufferFieldHandlers.addIOHandler(Integer.TYPE, buf -> buf.readInt(), (i, buf) -> buf.writeInt(i.intValue()));
        PacketBufferFieldHandlers.addIOHandler(Integer.class, buf -> buf.readInt(), (i, buf) -> buf.writeInt(i.intValue()));
        PacketBufferFieldHandlers.addIOHandler(Float.TYPE, buf -> Float.valueOf(buf.readFloat()), (f, buf) -> buf.writeFloat(f.floatValue()));
        PacketBufferFieldHandlers.addIOHandler(Float.class, buf -> Float.valueOf(buf.readFloat()), (f, buf) -> buf.writeFloat(f.floatValue()));
        PacketBufferFieldHandlers.addIOHandler(Double.TYPE, buf -> buf.readDouble(), (d, buf) -> buf.writeDouble(d.doubleValue()));
        PacketBufferFieldHandlers.addIOHandler(Double.class, buf -> buf.readDouble(), (d, buf) -> buf.writeDouble(d.doubleValue()));
        PacketBufferFieldHandlers.addIOHandler(Long.TYPE, buf -> buf.readLong(), (l, buf) -> buf.writeLong(l.longValue()));
        PacketBufferFieldHandlers.addIOHandler(Long.class, buf -> buf.readLong(), (l, buf) -> buf.writeLong(l.longValue()));
        PacketBufferFieldHandlers.addIOHandler(String.class, buf -> buf.func_218666_n(), (s, buf) -> buf.func_180714_a(s));
        PacketBufferFieldHandlers.addIOHandler(ItemStack.class, buf -> buf.func_150791_c(), (itemStack, buf) -> buf.func_150788_a(itemStack));
        PacketBufferFieldHandlers.addIOHandler(Ingredient.class, buf -> Ingredient.func_199566_b((PacketBuffer)buf), (ingredient, buf) -> ingredient.func_199564_a(buf));
        PacketBufferFieldHandlers.addIOHandler(Enum.class, buf -> {
            try {
                Class<?> clz = Class.forName(buf.func_218666_n());
                return buf.func_179257_a(clz);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }, (anEnum, buf) -> {
            buf.func_180714_a(anEnum.getClass().getName());
            buf.func_179249_a(anEnum);
        });
        PacketBufferFieldHandlers.addIOHandler(Class.class, buf -> {
            try {
                return Class.forName(buf.func_218666_n());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }, (aClass, buf) -> buf.func_180714_a(aClass.getName()));
        PacketBufferFieldHandlers.addIOHandler(ResourceLocation.class, buf -> buf.func_192575_l(), (resourceLocation, buf) -> buf.func_192572_a(resourceLocation));
        PacketBufferFieldHandlers.addIOHandler(BlockPos.class, buf -> buf.func_179259_c(), (pos, buf) -> buf.func_179255_a(pos));
        PacketBufferFieldHandlers.addIOHandler(BlockState.class, buf -> BlockStateSerializationHelper.deserializeBlockState(buf), (blockState, buf) -> BlockStateSerializationHelper.serializeBlockState(buf, blockState));
        PacketBufferFieldHandlers.addIOHandler(UUID.class, buf -> buf.func_179253_g(), (uuid, buf) -> buf.func_179252_a(uuid));
        PacketBufferFieldHandlers.addIOHandler(INBTSerializable.class, buf -> {
            CompoundNBT store = buf.func_150793_b();
            INBT v = store.func_74781_a("v");
            String className = store.func_74779_i("c");
            try {
                Class<?> clz = Class.forName(className);
                INBTSerializable obj = (INBTSerializable)clz.getConstructor(new Class[0]).newInstance(new Object[0]);
                obj.deserializeNBT(v);
                return obj;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }, (inbtSerializable, buf) -> {
            CompoundNBT store = new CompoundNBT();
            store.func_74778_a("c", inbtSerializable.getClass().getName());
            store.func_218657_a("v", inbtSerializable.serializeNBT());
            buf.func_150786_a(store);
        });
        PacketBufferFieldHandlers.addIOHandler(Map.class, buf -> {
            if (buf.readBoolean()) {
                return Collections.emptyMap();
            }
            HashMap result = new HashMap();
            try {
                Class<?> keyClass = Class.forName(buf.func_218666_n());
                if (!PacketBufferFieldHandlers.hasIOHandler(keyClass)) {
                    Logz.warn("No PacketBuffer deserialization methods for keys in map (type='{}') exists.", keyClass);
                    return Collections.emptyMap();
                }
                Class<?> valueClass = Class.forName(buf.func_218666_n());
                if (!PacketBufferFieldHandlers.hasIOHandler(valueClass)) {
                    Logz.warn("No PacketBuffer deserialization methods for values in map (type='{}') exists.", valueClass);
                    return Collections.emptyMap();
                }
                int entryCount = buf.readInt();
                Reader keyReader = (Reader)PacketBufferFieldHandlers.getIOHandler(keyClass).getLeft();
                Reader valueReader = (Reader)PacketBufferFieldHandlers.getIOHandler(valueClass).getLeft();
                for (int entryNum = 0; entryNum < entryCount; ++entryNum) {
                    Object keyObject = keyReader.read(buf);
                    Object valueObject = valueReader.read(buf);
                    result.put(keyObject, valueObject);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return result;
        }, (map, buf) -> {
            buf.writeBoolean(map.isEmpty());
            if (!map.isEmpty()) {
                Class<?> keyClass = map.keySet().toArray()[0].getClass();
                if (!PacketBufferFieldHandlers.hasIOHandler(keyClass)) {
                    Logz.warn("No PacketBuffer deserialization methods for keys in map (type='{}') exists.", keyClass);
                    return;
                }
                Class<?> valueClass = map.values().toArray()[0].getClass();
                if (!PacketBufferFieldHandlers.hasIOHandler(valueClass)) {
                    Logz.warn("No PacketBuffer deserialization methods for values in map (type='{}') exists.", valueClass);
                    return;
                }
                buf.func_180714_a(keyClass.getName());
                buf.func_180714_a(valueClass.getName());
                buf.writeInt(map.entrySet().size());
                Writer keyWriter = (Writer)PacketBufferFieldHandlers.getIOHandler(keyClass).getRight();
                Writer valueWriter = (Writer)PacketBufferFieldHandlers.getIOHandler(valueClass).getRight();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry e;
                    Map.Entry entry = e = iterator.next();
                    keyWriter.write(entry.getKey(), buf);
                    valueWriter.write(entry.getValue(), buf);
                }
            }
        });
        PacketBufferFieldHandlers.addIOHandler(List.class, buf -> {
            if (buf.readBoolean()) {
                return Collections.emptyList();
            }
            ArrayList result = new ArrayList();
            try {
                Class<?> valueClass = Class.forName(buf.func_218666_n());
                if (!PacketBufferFieldHandlers.hasIOHandler(valueClass)) {
                    Logz.warn("No PacketBuffer deserialization methods for values in list (type='{}') exists.", valueClass);
                    return Collections.emptyList();
                }
                int entryCount = buf.readInt();
                Reader valueReader = (Reader)PacketBufferFieldHandlers.getIOHandler(valueClass).getLeft();
                for (int entryNum = 0; entryNum < entryCount; ++entryNum) {
                    Object valueObject = valueReader.read(buf);
                    result.add(valueObject);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return result;
        }, (list, buf) -> {
            buf.writeBoolean(list.isEmpty());
            if (!list.isEmpty()) {
                Class<?> valueClass = list.toArray()[0].getClass();
                if (!PacketBufferFieldHandlers.hasIOHandler(valueClass)) {
                    Logz.warn("No PacketBuffer serialization methods for values in list (type='{}') exists.", valueClass);
                    return;
                }
                buf.func_180714_a(valueClass.getName());
                buf.writeInt(list.size());
                Writer valueWriter = (Writer)PacketBufferFieldHandlers.getIOHandler(valueClass).getRight();
                for (Object e : list) {
                    valueWriter.write(e, buf);
                }
            }
        });
        PacketBufferFieldHandlers.addIOHandler(Queue.class, buf -> {
            if (buf.readBoolean()) {
                return new ArrayDeque();
            }
            ArrayDeque result = new ArrayDeque();
            try {
                Class<?> valueClass = Class.forName(buf.func_218666_n());
                if (!PacketBufferFieldHandlers.hasIOHandler(valueClass)) {
                    Logz.warn("No PacketBuffer deserialization methods for values in list (type='{}') exists.", valueClass);
                    return new ArrayDeque();
                }
                int entryCount = buf.readInt();
                Reader valueReader = (Reader)PacketBufferFieldHandlers.getIOHandler(valueClass).getLeft();
                for (int entryNum = 0; entryNum < entryCount; ++entryNum) {
                    Object valueObject = valueReader.read(buf);
                    result.add(valueObject);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return result;
        }, (queue, buf) -> {
            buf.writeBoolean(queue.isEmpty());
            if (!queue.isEmpty()) {
                Class<?> valueClass = queue.toArray()[0].getClass();
                if (!PacketBufferFieldHandlers.hasIOHandler(valueClass)) {
                    Logz.warn("No PacketBuffer serialization methods for values in list (type='{}') exists.", valueClass);
                    return;
                }
                buf.func_180714_a(valueClass.getName());
                buf.writeInt(queue.size());
                Writer valueWriter = (Writer)PacketBufferFieldHandlers.getIOHandler(valueClass).getRight();
                for (Object e : queue) {
                    valueWriter.write(e, buf);
                }
            }
        });
        PacketBufferFieldHandlers.addIOHandler(Byte.TYPE, buf -> buf.readByte(), (b, buf) -> buf.writeByte((int)b.byteValue()));
    }

    public static interface Reader<T> {
        public T read(PacketBuffer var1);
    }

    public static interface Writer<T> {
        public void write(T var1, PacketBuffer var2);
    }
}

