/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework.widgets;

import com.davenonymous.libnonymous.gui.framework.GUI;
import com.davenonymous.libnonymous.gui.framework.GUIHelper;
import com.davenonymous.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseEnterEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseExitEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.widgets.Widget;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class WidgetButton
extends Widget {
    protected String unlocalizedLabel;
    public boolean hovered = false;
    public ResourceLocation backgroundTexture;
    public TextureAtlasSprite atlasSprite;

    public WidgetButton(String unlocalizedLabel) {
        this.setHeight(20);
        this.setWidth(100);
        this.unlocalizedLabel = unlocalizedLabel;
        this.backgroundTexture = GUI.defaultButtonTexture;
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseEnterEvent.class, (event, widget) -> {
            ((WidgetButton)widget).hovered = true;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseExitEvent.class, (event, widget) -> {
            ((WidgetButton)widget).hovered = false;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    public WidgetButton setBackgroundTexture(ResourceLocation backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public WidgetButton setAtlasSprite(TextureAtlasSprite atlasSprite) {
        this.atlasSprite = atlasSprite;
        return this;
    }

    public void setUnlocalizedLabel(String unlocalizedLabel) {
        this.unlocalizedLabel = unlocalizedLabel;
    }

    @Override
    public void draw(Screen screen) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)2.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.atlasSprite != null) {
            screen.getMinecraft().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            WidgetButton.fillAreaWithIcon(this.atlasSprite, 0, 0, this.width, this.height);
        } else {
            screen.getMinecraft().func_110434_K().func_110577_a(this.backgroundTexture);
            GUIHelper.drawModalRectWithCustomSizedTexture(0, 0, 0.0f, 0.0f, this.width, this.height, 16.0f, 16.0f);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.hovered ? 1.0f : 1.0f));
        screen.getMinecraft().func_110434_K().func_110577_a(GUI.tabIcons);
        int texOffsetX = 64;
        int texOffsetY = 84;
        int overlayWidth = 20;
        GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)texOffsetX, (int)texOffsetY, (int)4, (int)4, (float)0.0f);
        GuiUtils.drawTexturedModalRect((int)(0 + this.width - 4), (int)0, (int)(texOffsetX + overlayWidth - 4), (int)texOffsetY, (int)4, (int)4, (float)0.0f);
        GuiUtils.drawTexturedModalRect((int)0, (int)(this.height - 4), (int)texOffsetX, (int)(texOffsetY + overlayWidth - 4), (int)4, (int)4, (float)0.0f);
        GuiUtils.drawTexturedModalRect((int)(0 + this.width - 4), (int)(this.height - 4), (int)(texOffsetX + overlayWidth - 4), (int)(texOffsetY + overlayWidth - 4), (int)4, (int)4, (float)0.0f);
        GUIHelper.drawStretchedTexture(4, 0, this.width - 8, 4, texOffsetX + 4, texOffsetY, 12, 4);
        GUIHelper.drawStretchedTexture(4, this.height - 4, this.width - 8, 4, texOffsetX + 4, texOffsetY + overlayWidth - 4, 12, 4);
        GUIHelper.drawStretchedTexture(0, 4, 4, this.height - 8, texOffsetX, texOffsetY + 4, 4, 12);
        GUIHelper.drawStretchedTexture(0 + this.width - 4, 4, 4, this.height - 8, texOffsetX + overlayWidth - 4, texOffsetY + 3, 4, 12);
        FontRenderer fontrenderer = screen.getMinecraft().field_71466_p;
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)10.0f);
        this.drawButtonContent(screen, fontrenderer);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-10.0f);
        if (!this.enabled) {
            GUIHelper.drawColoredRectangle(1, 1, this.width - 2, this.height - 2, Integer.MIN_VALUE);
        } else if (this.hovered) {
            GUIHelper.drawColoredRectangle(1, 1, this.width - 2, this.height - 2, -2139057921);
        }
        RenderSystem.popMatrix();
    }

    protected void drawButtonContent(Screen screen, FontRenderer renderer) {
        this.drawString(screen, renderer);
    }

    protected void drawString(Screen screen, FontRenderer renderer) {
        int color = 0xFFFFFF;
        screen.drawCenteredString(renderer, this.unlocalizedLabel, this.width / 2, (this.height - 8) / 2, color);
    }

    public static void fillAreaWithIcon(TextureAtlasSprite icon, int x, int y, int width, int height) {
        int xNow;
        int yNow;
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder b = t.func_178180_c();
        b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float zLevel = 0.0f;
        int iconWidth = icon.func_94211_a();
        int iconHeight = icon.func_94216_b();
        int fullCols = width / iconWidth;
        int fullRows = height / iconHeight;
        float minU = icon.func_94209_e();
        float maxU = icon.func_94212_f();
        float minV = icon.func_94206_g();
        float maxV = icon.func_94210_h();
        int excessWidth = width % iconWidth;
        int excessHeight = height % iconHeight;
        float partialMaxU = minU + (maxU - minU) * ((float)excessWidth / (float)iconWidth);
        float partialMaxV = minV + (maxV - minV) * ((float)excessHeight / (float)iconHeight);
        for (int row = 0; row < fullRows; ++row) {
            yNow = y + row * iconHeight;
            for (int col = 0; col < fullCols; ++col) {
                xNow = x + col * iconWidth;
                WidgetButton.drawRect(xNow, yNow, iconWidth, iconHeight, zLevel, minU, minV, maxU, maxV);
            }
            if (excessWidth == 0) continue;
            xNow = x + fullCols * iconWidth;
            WidgetButton.drawRect(xNow, yNow, iconWidth, iconHeight, zLevel, minU, minV, maxU, maxV);
        }
        if (excessHeight != 0) {
            for (int col = 0; col < fullCols; ++col) {
                xNow = x + col * iconWidth;
                yNow = y + fullRows * iconHeight;
                WidgetButton.drawRect(xNow, yNow, iconWidth, excessHeight, zLevel, minU, minV, maxU, partialMaxV);
            }
            if (excessWidth != 0) {
                xNow = x + fullCols * iconWidth;
                yNow = y + fullRows * iconHeight;
                WidgetButton.drawRect(xNow, yNow, excessWidth, excessHeight, zLevel, minU, minV, partialMaxU, partialMaxV);
            }
        }
        t.func_78381_a();
    }

    private static void drawRect(float x, float y, float width, float height, float z, float u, float v, float maxU, float maxV) {
        BufferBuilder b = Tessellator.func_178181_a().func_178180_c();
        b.func_225582_a_((double)x, (double)(y + height), (double)z).func_225583_a_(u, maxV).func_181675_d();
        b.func_225582_a_((double)(x + width), (double)(y + height), (double)z).func_225583_a_(maxU, maxV).func_181675_d();
        b.func_225582_a_((double)(x + width), (double)y, (double)z).func_225583_a_(maxU, v).func_181675_d();
        b.func_225582_a_((double)x, (double)y, (double)z).func_225583_a_(u, v).func_181675_d();
    }
}

