/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.client.gui;

import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.client.gui.FacingControllerWrapper;
import xyz.vsngamer.elevatorid.client.gui.FunctionalCheckbox;
import xyz.vsngamer.elevatorid.network.NetworkHandler;
import xyz.vsngamer.elevatorid.network.client.RemoveCamoPacket;
import xyz.vsngamer.elevatorid.network.client.SetArrowPacket;
import xyz.vsngamer.elevatorid.network.client.SetDirectionalPacket;
import xyz.vsngamer.elevatorid.tile.ElevatorContainer;
import xyz.vsngamer.elevatorid.tile.ElevatorTileEntity;

public class ElevatorScreen
extends ContainerScreen<ElevatorContainer> {
    private final ResourceLocation GUI_TEXTURE = new ResourceLocation("elevatorid", "textures/gui/elevator_gui.png");
    private final ElevatorTileEntity tile;
    private final Direction playerFacing;
    private FunctionalCheckbox dirButton;
    private FunctionalCheckbox hideArrowButton;
    private ExtendedButton resetCamoButton;
    private FacingControllerWrapper facingController;

    public ElevatorScreen(ElevatorContainer container, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)container, inv, titleIn);
        this.field_146999_f = 200;
        this.field_147000_g = 100;
        this.tile = container.getTile();
        this.playerFacing = container.getPlayerFacing();
    }

    protected void init() {
        super.init();
        String dirLang = new TranslationTextComponent("screen.elevatorid.elevator.directional", new Object[0]).func_150254_d();
        this.dirButton = new FunctionalCheckbox(this.field_147003_i + 8, this.field_147009_r + 25, 20, 20, dirLang, (Boolean)this.tile.func_195044_w().func_177229_b((IProperty)ElevatorBlock.DIRECTIONAL), value -> NetworkHandler.INSTANCE.sendToServer((Object)new SetDirectionalPacket(value, this.tile.func_174877_v())));
        this.addButton((Widget)this.dirButton);
        String arrowLang = new TranslationTextComponent("screen.elevatorid.elevator.hide_arrow", new Object[0]).func_150254_d();
        this.hideArrowButton = new FunctionalCheckbox(this.field_147003_i + 8, this.field_147009_r + 50, 20, 20, arrowLang, (Boolean)this.tile.func_195044_w().func_177229_b((IProperty)ElevatorBlock.SHOW_ARROW) == false, value -> NetworkHandler.INSTANCE.sendToServer((Object)new SetArrowPacket(!value, this.tile.func_174877_v())));
        this.hideArrowButton.visible = false;
        this.addButton((Widget)this.hideArrowButton);
        String resetCamoLang = new TranslationTextComponent("screen.elevatorid.elevator.reset_camo", new Object[0]).func_150254_d();
        this.resetCamoButton = new ExtendedButton(this.field_147003_i + 8, this.field_147009_r + 75, 110, 20, resetCamoLang, p_onPress_1_ -> NetworkHandler.INSTANCE.sendToServer((Object)new RemoveCamoPacket(this.tile.func_174877_v())));
        this.addButton((Widget)this.resetCamoButton);
        this.facingController = new FacingControllerWrapper(this.field_147003_i + 120, this.field_147009_r + 20, this.tile.func_174877_v(), this.playerFacing);
        this.facingController.getButtons().forEach(arg_0 -> ((ElevatorScreen)this).addButton(arg_0));
        this.facingController.getButtons().forEach(button -> {
            button.visible = false;
        });
        this.resetCamoButton.active = this.tile.getHeldState() != null;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
    }

    public void tick() {
        super.tick();
        this.facingController.getButtons().forEach(button -> {
            button.visible = this.dirButton.func_212942_a();
            button.active = this.tile.func_195044_w().func_177229_b((IProperty)ElevatorBlock.field_185512_D) != button.direction;
        });
        this.hideArrowButton.visible = this.dirButton.func_212942_a();
        this.resetCamoButton.active = this.tile.getHeldState() != null;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (this.minecraft != null) {
            this.minecraft.func_110434_K().func_110577_a(this.GUI_TEXTURE);
        }
        int relX = (this.width - this.field_146999_f) / 2;
        int relY = (this.height - this.field_147000_g) / 2;
        this.blit(relX, relY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.title.func_150254_d(), 8.0f, 8.0f, 0xE0E0E0);
    }
}

