/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.HashSet;
import java.util.UUID;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import stepsword.mahoutsukai.capability.worldsave.MahouSavedData;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.TickingTileEntity;
import stepsword.mahoutsukai.tile.boundary.TangibleBoundaryMahoujinTileEntity;

public class InvisibleBarrierBlockTileEntity
extends TickingTileEntity {
    private UUID casterUUID;
    private BlockPos boundaryCircle;
    public int timeN = 21;
    public int timeE = 21;
    public int timeW = 21;
    public int timeS = 21;
    public int timeU = 21;
    public int timeD = 21;
    public static final int fadeTicks = 20;
    public static int updateWhiteListTicks = 20;
    public int tickCounter = 0;
    public static final String CASTER_ID = "caster_uuid";
    public static final String TIME_SINCE_COLLISION = "time_since_last_collision";
    public static final String ORIGINAL_BOUNDARY_CIRCLE_X = "original_boundary_circle_x";
    public static final String ORIGINAL_BOUNDARY_CIRCLE_Y = "original_boundary_circle_y";
    public static final String ORIGINAL_BOUNDARY_CIRCLE_Z = "original_boundary_circle_z";
    public static final String WHITELIST_TAG = "whitelist";
    public HashSet<UUID> whitelist;

    public InvisibleBarrierBlockTileEntity() {
        super(ModTileEntities.invisibleBarrier);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.casterUUID != null) {
            compound.func_186854_a(CASTER_ID, this.casterUUID);
        }
        compound.func_74768_a("time_since_last_collisionN", this.timeN);
        compound.func_74768_a("time_since_last_collisionE", this.timeE);
        compound.func_74768_a("time_since_last_collisionW", this.timeW);
        compound.func_74768_a("time_since_last_collisionS", this.timeS);
        compound.func_74768_a("time_since_last_collisionU", this.timeU);
        compound.func_74768_a("time_since_last_collisionD", this.timeD);
        if (this.boundaryCircle != null) {
            compound.func_74768_a(ORIGINAL_BOUNDARY_CIRCLE_X, this.boundaryCircle.func_177958_n());
            compound.func_74768_a(ORIGINAL_BOUNDARY_CIRCLE_Y, this.boundaryCircle.func_177956_o());
            compound.func_74768_a(ORIGINAL_BOUNDARY_CIRCLE_Z, this.boundaryCircle.func_177952_p());
        }
        if (this.whitelist != null) {
            CompoundNBT tmp = new CompoundNBT();
            int z = 0;
            for (UUID uuid : this.whitelist) {
                tmp.func_186854_a("MAHOUTSUKAI_WHITELIST_" + z, uuid);
            }
            compound.func_218657_a(WHITELIST_TAG, (INBT)tmp);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(CompoundNBT compound) {
        this.casterUUID = compound.func_186855_b(CASTER_ID) ? compound.func_186857_a(CASTER_ID) : null;
        this.timeN = compound.func_74762_e("time_since_last_collisionN");
        this.timeE = compound.func_74762_e("time_since_last_collisionE");
        this.timeW = compound.func_74762_e("time_since_last_collisionW");
        this.timeS = compound.func_74762_e("time_since_last_collisionS");
        this.timeU = compound.func_74762_e("time_since_last_collisionU");
        this.timeD = compound.func_74762_e("time_since_last_collisionD");
        if (compound.func_74764_b(ORIGINAL_BOUNDARY_CIRCLE_X) && compound.func_74764_b(ORIGINAL_BOUNDARY_CIRCLE_Y) && compound.func_74764_b(ORIGINAL_BOUNDARY_CIRCLE_Z)) {
            this.boundaryCircle = new BlockPos(compound.func_74762_e(ORIGINAL_BOUNDARY_CIRCLE_X), compound.func_74762_e(ORIGINAL_BOUNDARY_CIRCLE_Y), compound.func_74762_e(ORIGINAL_BOUNDARY_CIRCLE_Z));
        }
        if (compound.func_74764_b(WHITELIST_TAG)) {
            if (this.whitelist == null) {
                this.whitelist = new HashSet();
            }
            CompoundNBT nbt = (CompoundNBT)compound.func_74781_a(WHITELIST_TAG);
            for (String s : nbt.func_150296_c()) {
                if (!s.endsWith("Most")) continue;
                this.whitelist.add(nbt.func_186857_a(s.substring(0, s.length() - 4)));
            }
        }
        super.func_145839_a(compound);
    }

    public int getTimeSinceCollision(Direction facing) {
        if (facing == Direction.NORTH) {
            return this.timeN;
        }
        if (facing == Direction.EAST) {
            return this.timeE;
        }
        if (facing == Direction.WEST) {
            return this.timeW;
        }
        if (facing == Direction.SOUTH) {
            return this.timeS;
        }
        if (facing == Direction.DOWN) {
            return this.timeD;
        }
        if (facing == Direction.UP) {
            return this.timeU;
        }
        return this.timeN;
    }

    public void setTimeSinceCollision(int t, Direction facing) {
        if (facing == Direction.NORTH) {
            this.timeN = t;
        }
        if (facing == Direction.EAST) {
            this.timeE = t;
        }
        if (facing == Direction.WEST) {
            this.timeW = t;
        }
        if (facing == Direction.SOUTH) {
            this.timeS = t;
        }
        if (facing == Direction.DOWN) {
            this.timeD = t;
        }
        if (facing == Direction.UP) {
            this.timeU = t;
        }
        this.sendUpdates();
    }

    public PlayerEntity getCaster() {
        try {
            PlayerEntity caster = this.field_145850_b.func_217371_b(this.casterUUID);
            return caster;
        }
        catch (Exception e) {
            return null;
        }
    }

    public UUID getCasterUUID() {
        return this.casterUUID;
    }

    public void setCasterUUID(UUID casterUUID) {
        this.casterUUID = casterUUID;
        this.sendUpdates();
    }

    public void setBoundaryCircle(BlockPos p) {
        this.boundaryCircle = p;
        this.sendUpdates();
    }

    public void setCaster(PlayerEntity caster) {
        this.casterUUID = caster.func_110124_au();
        this.sendUpdates();
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.boundaryCircle != null) {
                TileEntity te = this.field_145850_b.func_175625_s(this.boundaryCircle);
                if (te instanceof TangibleBoundaryMahoujinTileEntity) {
                    TangibleBoundaryMahoujinTileEntity mte = (TangibleBoundaryMahoujinTileEntity)te;
                    if (!mte.shouldIPerformBarrier()) {
                        this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
                        return;
                    }
                } else {
                    this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
                    return;
                }
            }
            if (this.tickCounter == updateWhiteListTicks) {
                MahouSavedData save = new MahouSavedData(this.field_145850_b);
                if (save != null && save.playerContracts != null) {
                    if (save.playerContracts.containsKey((Object)this.getCasterUUID())) {
                        this.whitelist = new HashSet(save.playerContracts.get((Object)this.getCasterUUID()));
                        this.sendUpdates();
                    } else {
                        this.whitelist = new HashSet();
                        this.sendUpdates();
                    }
                }
                this.tickCounter = 0;
            }
            ++this.tickCounter;
        }
        this.timeN = this.timeN <= 20 ? this.timeN + 1 : this.timeN;
        this.timeE = this.timeE <= 20 ? this.timeE + 1 : this.timeE;
        this.timeW = this.timeW <= 20 ? this.timeW + 1 : this.timeW;
        this.timeS = this.timeS <= 20 ? this.timeS + 1 : this.timeS;
        this.timeU = this.timeU <= 20 ? this.timeU + 1 : this.timeU;
        this.timeD = this.timeD <= 20 ? this.timeD + 1 : this.timeD;
    }
}

