/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.boundary.BoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;

public class AlarmBoundaryMahoujinTileEntity
extends BoundaryMahoujinTileEntity {
    public boolean detected = false;

    public AlarmBoundaryMahoujinTileEntity() {
        super((TileEntityType)ModTileEntities.alarmBoundary);
    }

    @Override
    public int getManaCost() {
        return MTConfig.ALARM_BARRIER_MANA_COST;
    }

    @Override
    public int getManaCycle() {
        return MTConfig.ALARM_BARRIER_MANA_CYCLE;
    }

    @Override
    public int getBarrierCycle() {
        return MTConfig.ALARM_BARRIER_CYCLE;
    }

    @Override
    public int getBarrierRadius() {
        return MTConfig.ALARM_BARRIER_RADIUS;
    }

    @Override
    public void doBarrier(List<LivingEntity> entities) {
        PlayerEntity caster = this.getCaster();
        this.detected = false;
        if (this.entitiesInBarrier != null && caster != null) {
            for (LivingEntity e : entities) {
                if (!ContractMahoujinTileEntity.isImmuneToSpell(this.field_145850_b, this.getCasterUUID(), (Entity)e)) {
                    this.detected = true;
                }
                if (this.entitiesInBarrier.contains(e.func_110124_au())) continue;
                this.soundAlarm(e, caster);
            }
        }
        this.sendUpdates();
    }

    public void soundAlarm(LivingEntity entityIn, PlayerEntity caster) {
        if (caster != null) {
            if (entityIn instanceof PlayerEntity && !ContractMahoujinTileEntity.isImmuneToSpell(this.field_145850_b, this.getCasterUUID(), (Entity)entityIn)) {
                caster.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "A player has entered your boundary."), MTConfig.ALARM_ACTION_BAR_MESSAGES);
            } else if (!ContractMahoujinTileEntity.isImmuneToSpell(this.field_145850_b, this.getCasterUUID(), (Entity)entityIn)) {
                caster.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Something has entered your boundary."), MTConfig.ALARM_ACTION_BAR_MESSAGES);
            }
        }
    }

    @Override
    public void doNotBarrier() {
        if (this.detected) {
            this.detected = false;
            this.sendUpdates();
        }
    }

    @Override
    public ItemStack getItemToGive() {
        return new ItemStack((IItemProvider)ModItems.boundaryAlarmScroll);
    }
}

