/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.passthroughsigns.util;

import com.girafi.passthroughsigns.api.IPassable;
import com.girafi.passthroughsigns.api.PassthroughSignsAPI;
import com.girafi.passthroughsigns.util.ConfigurationHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.WallBannerBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="passthroughsigns")
public class PassableHandler {
    public static final boolean IS_QUARK_LOADED = ModList.get().isLoaded("quark");

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        PlayerEntity player = event.getPlayer();
        Block block = state.func_177230_c();
        if (block instanceof WallSignBlock && (Boolean)ConfigurationHandler.GENERAL.shouldWallSignBePassable.get() != false || block instanceof WallBannerBlock && (Boolean)ConfigurationHandler.GENERAL.shouldBannerBePassable.get() != false || block instanceof IPassable && ((IPassable)block).canBePassed(world, pos, IPassable.EnumPassableType.WALL_BLOCK) || PassthroughSignsAPI.BLOCK_PASSABLES.contains(block)) {
            Direction facingOpposite = Direction.NORTH.func_176734_d();
            if (state.func_196959_b((IProperty)DirectionalBlock.field_176387_N)) {
                facingOpposite = ((Direction)state.func_177229_b((IProperty)DirectionalBlock.field_176387_N)).func_176734_d();
            } else if (state.func_196959_b((IProperty)HorizontalBlock.field_185512_D)) {
                facingOpposite = ((Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D)).func_176734_d();
            }
            ItemStack heldStack = player.func_184614_ca();
            if (heldStack.func_77973_b() instanceof BlockItem) {
                event.setUseItem(Event.Result.DENY);
            }
            if (block instanceof WallSignBlock) {
                if (IS_QUARK_LOADED && player.func_213453_ef() && ((Boolean)ConfigurationHandler.GENERAL.shiftClickQuark.get()).booleanValue()) {
                    PassableHandler.rightClick(world, pos, player, event.getHand(), facingOpposite);
                } else if (!IS_QUARK_LOADED) {
                    PassableHandler.rightClick(world, pos, player, event.getHand(), facingOpposite);
                }
            } else if (!player.func_213453_ef()) {
                PassableHandler.rightClick(world, pos, player, event.getHand(), facingOpposite);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        PlayerEntity player = event.getPlayer();
        Entity entity = event.getTarget();
        if (entity instanceof ItemFrameEntity && (Boolean)ConfigurationHandler.GENERAL.shouldItemFrameBePassable.get() != false || entity instanceof PaintingEntity && (Boolean)ConfigurationHandler.GENERAL.shouldPaintingsBePassable.get() != false || entity instanceof IPassable && ((IPassable)entity).canBePassed(world, pos, IPassable.EnumPassableType.HANGING_ENTITY) || PassthroughSignsAPI.ENTITY_PASSABLES.contains(entity.func_200600_R())) {
            Direction facingOpposite = entity.func_174811_aO().func_176734_d();
            if (!player.func_213453_ef()) {
                if (entity instanceof ItemFrameEntity && ((Boolean)ConfigurationHandler.GENERAL.turnOffItemRotation.get()).booleanValue()) {
                    event.setCanceled(true);
                }
                PassableHandler.rightClick(world, pos, player, event.getHand(), facingOpposite);
            }
        }
    }

    private static void rightClick(World world, BlockPos pos, PlayerEntity player, Hand hand, Direction facingOpposite) {
        if (hand == Hand.MAIN_HAND) {
            BlockPos posOffset = pos.func_177982_a(facingOpposite.func_82601_c(), facingOpposite.func_96559_d(), facingOpposite.func_82599_e());
            BlockState attachedState = world.func_180495_p(posOffset);
            BlockState stateDown = world.func_180495_p(pos.func_177977_b());
            BlockRayTraceResult rayTrace = new BlockRayTraceResult(new Vec3d((double)posOffset.func_177958_n(), (double)posOffset.func_177956_o(), (double)posOffset.func_177952_p()), facingOpposite, pos, false);
            if (!world.func_175623_d(pos.func_177977_b()) && attachedState.func_177230_c().isAir(attachedState, (IBlockReader)world, pos)) {
                stateDown.func_177230_c().func_225533_a_(attachedState, world, pos.func_177977_b(), player, hand, rayTrace);
            } else if (!attachedState.func_177230_c().isAir(attachedState, (IBlockReader)world, pos)) {
                attachedState.func_177230_c().func_225533_a_(attachedState, world, posOffset, player, hand, rayTrace);
            }
        }
    }
}

