/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.loot.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.ILootCondition;

public class CheckDimensionId
implements ILootCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation dimensionId;

    public CheckDimensionId(ResourceLocation dimensionId) {
        this.dimensionId = dimensionId;
    }

    public boolean test(LootContext ctx) {
        DimensionType type;
        ServerWorld world = ctx.func_202879_g();
        Dimension dimension = world.func_201675_m();
        if (dimension != null && (type = dimension.func_186058_p()) != null) {
            return type.getRegistryName().equals((Object)this.dimensionId);
        }
        return false;
    }

    static class Serializer
    extends ILootCondition.AbstractSerializer<CheckDimensionId> {
        Serializer() {
            super(new ResourceLocation("bookshelf", "check_dimension"), CheckDimensionId.class);
        }

        public CheckDimensionId deserialize(JsonObject json, JsonDeserializationContext context) {
            ResourceLocation id = ResourceLocation.func_208304_a((String)JSONUtils.func_151200_h((JsonObject)json, (String)"dimension"));
            return new CheckDimensionId(id);
        }

        public void serialize(JsonObject json, CheckDimensionId value, JsonSerializationContext context) {
            json.addProperty("dimension", value.dimensionId.toString());
        }
    }
}

