/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.item;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.StackList;
import net.minecraftforge.registries.ForgeRegistries;

public class IngredientPredicate
extends Ingredient {
    private final Serializer serializer;

    private IngredientPredicate(Serializer serializer, Stream<? extends Ingredient.IItemList> itemLists) {
        super(itemLists);
        this.serializer = serializer;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<IngredientPredicate> getSerializer() {
        return this.serializer;
    }

    public static Serializer create(Predicate<Item> predicate) {
        return new Serializer(predicate);
    }

    static class Serializer
    implements IIngredientSerializer<IngredientPredicate> {
        private final Predicate<Item> itemPredicate;
        private IngredientPredicate ingredient;
        private int generation;

        private Serializer(Predicate<Item> itemPredicate) {
            this.itemPredicate = itemPredicate;
        }

        public IngredientPredicate parse(PacketBuffer buffer) {
            return new IngredientPredicate(this, Stream.generate(() -> new Ingredient.SingleItemList(buffer.func_150791_c())).limit(buffer.func_150792_a()));
        }

        public IngredientPredicate parse(JsonObject json) {
            if (this.ingredient == null || this.generation != ItemTags.getGeneration()) {
                this.ingredient = new IngredientPredicate(this, Stream.of(new StackList(this.getMatchingItems())));
            }
            return this.ingredient;
        }

        public void write(PacketBuffer buffer, IngredientPredicate ingredient) {
            ItemStack[] items = ingredient.func_193365_a();
            buffer.func_150787_b(items.length);
            for (ItemStack stack : items) {
                buffer.func_150788_a(stack);
            }
        }

        private List<ItemStack> getMatchingItems() {
            NonNullList matchingItems = NonNullList.func_191196_a();
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                if (!this.itemPredicate.test(item)) continue;
                matchingItems.add(new ItemStack((IItemProvider)item));
            }
            return matchingItems;
        }
    }
}

