/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookResize;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.Book;

public class GuiBookWriter
extends GuiBook {
    BookTextRenderer text;
    BookTextRenderer editableText;
    TextFieldWidget textfield;
    private static String savedText = "";
    private static boolean drawHeader;

    public GuiBookWriter(Book book) {
        super(book, (ITextComponent)new StringTextComponent(""));
    }

    @Override
    public void init() {
        super.init();
        this.text = new BookTextRenderer(this, I18n.func_135052_a((String)"patchouli.gui.lexicon.editor.info", (Object[])new Object[0]), 15, 38);
        this.textfield = new TextFieldWidget(this.font, 10, 140, 116, 20, "");
        this.textfield.func_146203_f(Integer.MAX_VALUE);
        this.textfield.func_146180_a(savedText);
        this.addButton(new GuiButtonBookResize(this, this.bookLeft + 115, this.bookTop + 156 - 36, false, this::handleButtonResize));
        this.refreshText();
    }

    @Override
    void drawForegroundElements(int mouseX, int mouseY, float partialTicks) {
        super.drawForegroundElements(mouseX, mouseY, partialTicks);
        this.drawCenteredStringNoShadow(I18n.func_135052_a((String)"patchouli.gui.lexicon.editor", (Object[])new Object[0]), 73, 18, this.book.headerColor);
        GuiBookWriter.drawSeparator(this.book, 15, 30);
        if (drawHeader) {
            this.drawCenteredStringNoShadow(I18n.func_135052_a((String)"patchouli.gui.lexicon.editor.mock_header", (Object[])new Object[0]), 199, 18, this.book.headerColor);
            GuiBookWriter.drawSeparator(this.book, 141, 30);
        }
        this.textfield.render(mouseX, mouseY, partialTicks);
        this.text.render(mouseX, mouseY);
        this.editableText.render(mouseX, mouseY);
    }

    @Override
    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        return this.textfield.mouseClicked(mouseX - (double)this.bookLeft, mouseY - (double)this.bookTop, mouseButton) || this.text.click(mouseX, mouseY, mouseButton) || this.editableText.click(mouseX, mouseY, mouseButton) || super.mouseClickedScaled(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.textfield.keyPressed(key, scanCode, modifiers)) {
            this.refreshText();
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public boolean charTyped(char c, int i) {
        if (this.textfield.charTyped(c, i)) {
            this.refreshText();
            return true;
        }
        return super.charTyped(c, i);
    }

    public void handleButtonResize(Button button) {
        drawHeader = !drawHeader;
        this.refreshText();
    }

    public void refreshText() {
        int yPos = 18 + (drawHeader ? 22 : -4);
        savedText = this.textfield.func_146179_b();
        try {
            this.editableText = new BookTextRenderer(this, savedText, 141, yPos);
        }
        catch (Throwable e) {
            this.editableText = new BookTextRenderer(this, "[ERROR]", 141, yPos);
            Patchouli.LOGGER.catching(e);
        }
    }
}

