/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod.event;

import com.endlesnights.torchslabsmod.blocks.vanilla.BlockWallTorchSlab;
import com.endlesnights.torchslabsmod.config.Config;
import com.endlesnights.torchslabsmod.config.TorchSlabConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.EndRodBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.RedstoneWallTorchBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StoneButtonBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.block.WebBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="torchslabmod")
public class PlaceHandlerTorchWall {
    private static final HashMap<ResourceLocation, Block> PLACE_ENTRIES = new HashMap();

    @SubscribeEvent
    public static void onBlockEntityPlace(PlayerInteractEvent.RightClickBlock event) {
        ItemStack held = event.getItemStack();
        ResourceLocation rl = held.func_77973_b().getRegistryName();
        if (PLACE_ENTRIES.containsKey(rl)) {
            PlaceHandlerTorchWall.placeTorch(event, held, PLACE_ENTRIES.get(rl));
        }
    }

    private static void placeTorch(PlayerInteractEvent.RightClickBlock event, ItemStack held, Block block) {
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        BlockPos placeAt = pos.func_177972_a(face);
        World world = event.getWorld();
        PlayerEntity playerIn = event.getPlayer();
        Config.loadConfig(Config.SERVER, FMLPaths.CONFIGDIR.get().resolve("torchslabmod-server.toml").toString());
        if (!playerIn.func_226271_bk_() && ((List)TorchSlabConfig.interactiveCheckList.get()).contains(world.func_180495_p(pos).func_177230_c().getRegistryName().toString())) {
            return;
        }
        if (face != Direction.UP && face != Direction.DOWN && Block.func_220056_d((BlockState)world.func_180495_p(pos), (IBlockReader)world, (BlockPos)pos, (Direction)face) && (world.func_175623_d(placeAt) || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150355_j || world.func_204610_c(placeAt).func_206886_c() == Fluids.field_207212_b)) {
            if (PlaceHandlerTorchWall.blockHalf(playerIn, pos, face) >= 0.0 && PlaceHandlerTorchWall.validTop(world.func_180495_p(placeAt.func_177984_a()), (BlockState)((BlockState)block.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)face)).func_206870_a(BlockWallTorchSlab.HALF, (Comparable)Half.TOP))) {
                if (!((Boolean)TorchSlabConfig.upperBlockCheck.get()).booleanValue()) {
                    return;
                }
                if (block instanceof IWaterLoggable) {
                    world.func_175656_a(placeAt, (BlockState)((BlockState)((BlockState)block.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)face)).func_206870_a(BlockWallTorchSlab.HALF, (Comparable)Half.TOP)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(world.func_204610_c(placeAt).func_206886_c() == Fluids.field_204546_a)));
                } else {
                    world.func_175656_a(placeAt, (BlockState)((BlockState)block.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)face)).func_206870_a(BlockWallTorchSlab.HALF, (Comparable)Half.TOP));
                }
            } else {
                return;
            }
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), block.func_220072_p(world.func_180495_p(pos)).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            event.getPlayer().func_184609_a(event.getHand());
            if (!event.getPlayer().func_184812_l_()) {
                held.func_190918_g(1);
            }
            event.setCanceled(true);
        } else if ((world.func_180495_p(pos).func_177230_c() instanceof SlabBlock && world.func_180495_p(pos).func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM || world.func_180495_p(pos).func_177230_c() instanceof StairsBlock && world.func_180495_p(pos).func_177229_b((IProperty)StairsBlock.field_176308_b) == Half.BOTTOM) && face != Direction.UP && face != Direction.DOWN && (world.func_175623_d(placeAt) || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150355_j || world.func_204610_c(placeAt).func_206886_c() == Fluids.field_207212_b)) {
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), block.func_220072_p(world.func_180495_p(pos)).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            event.getPlayer().func_184609_a(event.getHand());
            if (block instanceof IWaterLoggable) {
                world.func_175656_a(placeAt, (BlockState)((BlockState)((BlockState)block.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)face)).func_206870_a(BlockWallTorchSlab.HALF, (Comparable)Half.BOTTOM)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(world.func_204610_c(placeAt).func_206886_c() == Fluids.field_204546_a)));
            } else {
                world.func_175656_a(placeAt, (BlockState)((BlockState)block.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)face)).func_206870_a(BlockWallTorchSlab.HALF, (Comparable)Half.BOTTOM));
            }
            if (!event.getPlayer().func_184812_l_()) {
                held.func_190918_g(1);
            }
            event.setCanceled(true);
        } else if ((world.func_180495_p(pos).func_177230_c() instanceof SlabBlock && world.func_180495_p(pos).func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.TOP || world.func_180495_p(pos).func_177230_c() instanceof StairsBlock && world.func_180495_p(pos).func_177229_b((IProperty)StairsBlock.field_176308_b) == Half.TOP) && face != Direction.UP && face != Direction.DOWN && (world.func_175623_d(placeAt) || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150355_j || world.func_204610_c(placeAt).func_206886_c() == Fluids.field_207212_b) && PlaceHandlerTorchWall.validTop(world.func_180495_p(placeAt.func_177984_a()), (BlockState)((BlockState)block.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)face)).func_206870_a(BlockWallTorchSlab.HALF, (Comparable)Half.TOP))) {
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), block.func_220072_p(world.func_180495_p(pos)).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            event.getPlayer().func_184609_a(event.getHand());
            if (block instanceof IWaterLoggable) {
                world.func_175656_a(placeAt, (BlockState)((BlockState)((BlockState)block.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)face)).func_206870_a(BlockWallTorchSlab.HALF, (Comparable)Half.TOP)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(world.func_204610_c(placeAt).func_206886_c() == Fluids.field_204546_a)));
            } else {
                world.func_175656_a(placeAt, (BlockState)((BlockState)block.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)face)).func_206870_a(BlockWallTorchSlab.HALF, (Comparable)Half.TOP));
            }
            if (!event.getPlayer().func_184812_l_()) {
                held.func_190918_g(1);
            }
            event.setCanceled(true);
        }
    }

    static boolean validTop(BlockState state, BlockState torchState) {
        return state.func_177230_c() instanceof AirBlock || state.func_177230_c() instanceof FlowingFluidBlock || state.func_177230_c() instanceof SlabBlock && state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.TOP || state.func_177230_c() instanceof StairsBlock && state.func_177229_b((IProperty)StairsBlock.field_176308_b) == Half.TOP && state.func_177229_b((IProperty)StairsBlock.field_176309_a) == torchState.func_177229_b((IProperty)BlockWallTorchSlab.field_196532_a) || state.func_177230_c() instanceof EndRodBlock || state.func_177230_c() instanceof TorchBlock || state.func_177230_c() instanceof WallSignBlock || state.func_177230_c() instanceof LadderBlock || state.func_177230_c() instanceof WebBlock || state.func_177230_c() instanceof VineBlock || state.func_177230_c() instanceof RedstoneWallTorchBlock || state.func_177230_c() instanceof StoneButtonBlock || state.func_177230_c() instanceof WoodButtonBlock;
    }

    static double blockHalf(PlayerEntity playerIn, BlockPos pos, Direction face) {
        double angleX = Math.toRadians(playerIn.field_70177_z);
        double angleY = Math.toRadians(playerIn.field_70125_A);
        double sinYaw = Math.sin(angleX);
        double cosYaw = Math.cos(angleX);
        double sinPitch = Math.sin(angleY);
        double cosPitch = Math.cos(angleY);
        Vec3d directionAngle = new Vec3d(cosPitch * cosYaw, sinPitch, cosPitch * sinYaw);
        Double yOffset = playerIn.func_174824_e((float)1.0f).field_72448_b - ((double)pos.func_177956_o() + 0.5);
        if (face == Direction.NORTH) {
            double magnatude = (playerIn.func_174824_e((float)1.0f).field_72449_c - (double)pos.func_177952_p()) / directionAngle.field_72450_a;
            return magnatude * directionAngle.field_72448_b + yOffset;
        }
        if (face == Direction.SOUTH) {
            double magnatude = (playerIn.func_174824_e((float)1.0f).field_72449_c - (double)(pos.func_177952_p() + 1)) / directionAngle.field_72450_a;
            return magnatude * directionAngle.field_72448_b + yOffset;
        }
        if (face == Direction.WEST) {
            double magnatude = (playerIn.func_174824_e((float)1.0f).field_72450_a - (double)pos.func_177958_n()) / -directionAngle.field_72449_c;
            return magnatude * directionAngle.field_72448_b + yOffset;
        }
        if (face == Direction.EAST) {
            double magnatude = (playerIn.func_174824_e((float)1.0f).field_72450_a - (double)(pos.func_177958_n() + 1)) / -directionAngle.field_72449_c;
            return magnatude * directionAngle.field_72448_b + yOffset;
        }
        return 0.0;
    }

    public static void registerPlaceEntry(ResourceLocation itemName, Block torchSlab) {
        if (!PLACE_ENTRIES.containsKey(itemName) && torchSlab != null) {
            PLACE_ENTRIES.put(itemName, torchSlab);
        }
    }

    public static Collection<Block> getPlaceEntryBlocks() {
        return PLACE_ENTRIES.values();
    }
}

