/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.supermultidrills.part;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.IPartSerializer;
import net.silentchaos512.gear.api.parts.IUpgradePart;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.parts.AbstractGearPart;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.supermultidrills.SuperMultiDrills;
import net.silentchaos512.supermultidrills.init.ModItems;
import net.silentchaos512.supermultidrills.item.DrillChassisItem;
import net.silentchaos512.supermultidrills.item.DrillItem;
import net.silentchaos512.utils.Color;

public class ChassisPart
extends AbstractGearPart
implements IUpgradePart {
    private static final ResourceLocation TYPE_ID = SuperMultiDrills.getId("chassis");
    public static final PartType TYPE = PartType.create((ResourceLocation)TYPE_ID, (IPartSerializer)new AbstractGearPart.Serializer(TYPE_ID, ChassisPart::new), (ResourceLocation)SilentGear.getId((String)"chassis"));
    public static final IPartPosition POSITION = new IPartPosition(){

        public String getTexturePrefix() {
            return "chassis";
        }

        public String getModelIndex() {
            return "chassis";
        }
    };
    private static final String[] RANDOM_COLORS = new String[]{"AliceBlue", "AntiqueWhite", "Aqua", "Aquamarine", "Azure", "Beige", "Bisque", "Black", "BlanchedAlmond", "Blue", "BlueViolet", "Brown", "BurlyWood", "CadetBlue", "Chartreuse", "Chocolate", "Coral", "CornflowerBlue", "Cornsilk", "Crimson", "Cyan", "DarkBlue", "DarkCyan", "DarkGoldenrod", "DarkGray", "DarkGreen", "DarkGrey", "DarkKhaki", "DarkMagenta", "DarkOliveGreen", "DarkOrange", "DarkOrchid", "DarkRed", "DarkSalmon", "DarkSeaGreen", "DarkSlateBlue", "DarkSlateGray", "DarkSlateGrey", "DarkTurquoise", "DarkViolet", "DeepPink", "DeepSkyBlue", "DimGray", "DodgerBlue", "FireBrick", "FloralWhite", "ForestGreen", "Fuchsia", "Gainsboro", "GhostWhite", "Gold", "Goldenrod", "Gray", "Green", "GreenYellow", "Grey", "Honeydew", "HotPink", "IndianRed", "Indigo", "Ivory", "Khaki", "Lavender", "LavenderBlush", "LawnGreen", "LemonChiffon", "LightBlue", "LightCoral", "LightCyan", "LightGoldenrodYellow", "LightGray", "LightGreen", "LightGrey", "LightPink", "LightSalmon", "LightSeaGreen", "LightSkyBlue", "LightSlateGray", "LightSlateGrey", "LightSteelBlue", "LightYellow", "Lime", "LimeGreen", "Linen", "Magenta", "Maroon", "MediumAquamarine", "MediumBlue", "MediumOrchid", "MediumPurple", "MediumSeaGreen", "MediumSlateBlue", "MediumSpringGreen", "MediumTurquoise", "MediumVioletRed", "MidnightBlue", "MintCream", "MistyRose", "Moccasin", "NavajoWhite", "Navy", "OldLace", "Olive", "OliveDrab", "Orange", "OrangeRed", "Orchid", "PaleGoldenrod", "PaleGreen", "PaleTurquoise", "PaleVioletRed", "PapayaWhip", "PeachPuff", "Peru", "Pink", "Plum", "PowderBlue", "Purple", "Rebeccapurple", "Red", "RosyBrown", "RoyalBlue", "SaddleBrown", "Salmon", "SandyBrown", "SeaGreen", "Seashell", "Sienna", "Silver", "SkyBlue", "SlateBlue", "SlateGray", "SlateGrey", "Snow", "SpringGreen", "SteelBlue", "Tan", "Teal", "Thistle", "Tomato", "Turquoise", "Violet", "Wheat", "White", "WhiteSmoke", "Yellow", "YellowGreen"};

    public ChassisPart(ResourceLocation partId) {
        super(partId);
    }

    public PartType getType() {
        return TYPE;
    }

    public IPartPosition getPartPosition() {
        return POSITION;
    }

    public IPartSerializer<?> getSerializer() {
        return TYPE.getSerializer();
    }

    public boolean isValidFor(ICoreItem gearItem) {
        return gearItem instanceof DrillItem;
    }

    public boolean replacesExisting() {
        return true;
    }

    public void onAddToGear(ItemStack gear, ItemStack part) {
        int color = DrillChassisItem.getColor(part);
        DrillItem.setChassisColor(gear, color);
    }

    public int getColor(PartData part, ItemStack gear, int animationFrame) {
        return DrillItem.getChassisColor(gear);
    }

    public ITextComponent getDisplayName(@Nullable PartData part, ItemStack gear) {
        int color = DrillItem.getChassisColor(gear);
        if (color != 0xFFFFFF) {
            return super.getDisplayName(part, gear).func_150257_a(new StringTextComponent(" (" + Color.format((int)color) + ")").func_211708_a(TextFormatting.DARK_GRAY));
        }
        return super.getDisplayName(part, gear);
    }

    public PartData randomizeData() {
        ItemStack chassis = ModItems.drillChassis.getStack(ChassisPart.getRandomColor());
        return PartData.of((IGearPart)this, (ItemStack)chassis);
    }

    private static int getRandomColor() {
        String colorName = RANDOM_COLORS[SuperMultiDrills.random.nextInt(RANDOM_COLORS.length)];
        Color color = Color.parse((String)colorName);
        return color.getColor() & 0xFFFFFF;
    }
}

