/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transmitters.grid;

import java.util.Collection;
import java.util.UUID;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.transmitters.TransmitterImpl;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.util.text.ITextComponent;

public class HeatNetwork
extends DynamicNetwork<IHeatHandler, HeatNetwork, Void> {
    private double meanTemp = 300.0;
    private double heatLost;
    private double heatTransferred;

    public HeatNetwork() {
    }

    public HeatNetwork(UUID networkID) {
        super(networkID);
    }

    public HeatNetwork(Collection<HeatNetwork> networks) {
        for (HeatNetwork net : networks) {
            if (net == null) continue;
            this.adoptTransmittersAndAcceptorsFrom(net);
            net.deregister();
        }
        this.register();
    }

    @Override
    public ITextComponent getNeededInfo() {
        return MekanismLang.NOT_APPLICABLE.translate(new Object[0]);
    }

    @Override
    public ITextComponent getStoredInfo() {
        return MekanismLang.HEAT_NETWORK_STORED.translate(MekanismUtils.getTemperatureDisplay(this.meanTemp, UnitDisplayUtils.TemperatureUnit.KELVIN, true));
    }

    @Override
    public ITextComponent getFlowInfo() {
        ITextComponent transferred = MekanismUtils.getTemperatureDisplay(this.heatTransferred, UnitDisplayUtils.TemperatureUnit.KELVIN, false);
        ITextComponent lost = MekanismUtils.getTemperatureDisplay(this.heatLost, UnitDisplayUtils.TemperatureUnit.KELVIN, false);
        return this.heatTransferred + this.heatLost == 0.0 ? MekanismLang.HEAT_NETWORK_FLOW.translate(transferred, lost) : MekanismLang.HEAT_NETWORK_FLOW_EFFICIENCY.translate(transferred, lost, (float)Math.round(this.heatTransferred / (this.heatTransferred + this.heatLost) * 10000.0) / 100.0f + "%");
    }

    @Override
    public void absorbBuffer(IGridTransmitter<IHeatHandler, HeatNetwork, Void> transmitter) {
    }

    @Override
    public void clampBuffer() {
    }

    @Override
    protected synchronized void updateCapacity(IGridTransmitter<IHeatHandler, HeatNetwork, Void> transmitter) {
    }

    @Override
    public synchronized void updateCapacity() {
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.isRemote()) {
            double newSumTemp = 0.0;
            double newHeatLost = 0.0;
            double newHeatTransferred = 0.0;
            for (IGridTransmitter transmitter : this.transmitters) {
                if (!(transmitter instanceof TransmitterImpl) || !(((TransmitterImpl)transmitter).containingTile instanceof ITileHeatHandler)) continue;
                ITileHeatHandler heatTile = (ITileHeatHandler)((Object)((TransmitterImpl)transmitter).containingTile);
                HeatAPI.HeatTransfer transfer = heatTile.simulate();
                heatTile.updateHeatCapacitors(null);
                newHeatTransferred += transfer.getAdjacentTransfer();
                newHeatLost += transfer.getEnvironmentTransfer();
                newSumTemp += heatTile.getTotalTemperature();
            }
            this.heatLost = newHeatLost;
            this.heatTransferred = newHeatTransferred;
            this.meanTemp = newSumTemp / (double)this.transmitters.size();
        }
    }

    public String toString() {
        return "[HeatNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    @Override
    public ITextComponent getTextComponent() {
        return MekanismLang.NETWORK_DESCRIPTION.translate(MekanismLang.HEAT_NETWORK, this.transmitters.size(), this.possibleAcceptors.size());
    }
}

