/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.AlloyTier;
import mekanism.api.tier.BaseTier;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.resolver.advanced.AdvancedEnergyCapabilityResolver;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tier.CableTier;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.transmitters.TransmitterImpl;
import mekanism.common.transmitters.grid.EnergyNetwork;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.upgrade.transmitter.UniversalCableUpgradeData;
import mekanism.common.util.CableUtils;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TileEntityUniversalCable
extends TileEntityTransmitter<IStrictEnergyHandler, EnergyNetwork, FloatingLong>
implements IMekanismStrictEnergyHandler {
    public final CableTier tier;
    private final List<IEnergyContainer> energyContainers;
    public BasicEnergyContainer buffer;
    public FloatingLong lastWrite = FloatingLong.ZERO;

    public TileEntityUniversalCable(IBlockProvider blockProvider) {
        super(blockProvider);
        this.tier = Attribute.getTier(blockProvider.getBlock(), CableTier.class);
        this.buffer = BasicEnergyContainer.create(this.getCapacityAsFloatingLong(), BasicEnergyContainer.alwaysFalse, BasicEnergyContainer.alwaysTrue, this);
        this.energyContainers = Collections.singletonList(this.buffer);
        this.addCapabilityResolver(new AdvancedEnergyCapabilityResolver(this));
    }

    @Override
    public void func_73660_a() {
        Set<Direction> connections;
        if (!this.isRemote() && !(connections = this.getConnections(TileEntitySidedPipe.ConnectionType.PULL)).isEmpty()) {
            for (IStrictEnergyHandler connectedAcceptor : CableUtils.getConnectedAcceptors(this.func_174877_v(), this.func_145831_w(), connections)) {
                FloatingLong received;
                if (connectedAcceptor == null || (received = connectedAcceptor.extractEnergy(this.getAvailablePull(), Action.SIMULATE)).isZero() || !this.takeEnergy(received, Action.SIMULATE).isZero()) continue;
                FloatingLong remainder = this.takeEnergy(received, Action.EXECUTE);
                connectedAcceptor.extractEnergy(received.subtract(remainder), Action.EXECUTE);
            }
        }
        super.func_73660_a();
    }

    private FloatingLong getAvailablePull() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return this.getCapacityAsFloatingLong().min(((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).energyContainer.getNeeded());
        }
        return this.getCapacityAsFloatingLong().min(this.buffer.getNeeded());
    }

    @Override
    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return ((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).getEnergyContainers(side);
        }
        return this.energyContainers;
    }

    @Override
    public void onContentsChanged() {
        this.markDirty(false);
    }

    @Override
    @Nonnull
    public FloatingLong insertEnergy(int container, @Nonnull FloatingLong amount, @Nullable Direction side, @Nonnull Action action) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        if (energyContainer == null) {
            return amount;
        }
        if (side == null) {
            return energyContainer.insert(amount, action, AutomationType.INTERNAL);
        }
        TileEntitySidedPipe.ConnectionType connectionType = this.getConnectionType(side);
        if (connectionType == TileEntitySidedPipe.ConnectionType.NORMAL || connectionType == TileEntitySidedPipe.ConnectionType.PULL) {
            return energyContainer.insert(amount, action, AutomationType.EXTERNAL);
        }
        return amount;
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.UNIVERSAL_CABLE;
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_150297_b("energy", 8)) {
            try {
                this.lastWrite = FloatingLong.parseFloatingLong(nbtTags.func_74779_i("energy"));
            }
            catch (NumberFormatException e) {
                this.lastWrite = FloatingLong.ZERO;
            }
        } else {
            this.lastWrite = FloatingLong.ZERO;
        }
        this.buffer.setEnergy(this.lastWrite);
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.getTransmitter().hasTransmitterNetwork()) {
            ((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).validateSaveShares();
        }
        if (this.lastWrite.isZero()) {
            nbtTags.func_82580_o("energy");
        } else {
            nbtTags.func_74778_a("energy", this.lastWrite.toString());
        }
        return nbtTags;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.ENERGY;
    }

    @Override
    public EnergyNetwork createNetworkByMerging(Collection<EnergyNetwork> networks) {
        return new EnergyNetwork(networks);
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, Direction side) {
        if (CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, null).filter(transmitter -> TransmissionType.checkTransmissionType(transmitter, TransmissionType.ENERGY)).isPresent()) {
            return false;
        }
        return EnergyCompatUtils.hasStrictEnergyHandlerAndListen(tile, side.func_176734_d(), this.getRefreshListener(side));
    }

    @Override
    public EnergyNetwork createNewNetwork() {
        return new EnergyNetwork();
    }

    @Override
    public EnergyNetwork createNewNetworkWithID(UUID networkID) {
        return new EnergyNetwork(networkID);
    }

    @Override
    @Nonnull
    public FloatingLong releaseShare() {
        FloatingLong energy = this.buffer.getEnergy();
        this.buffer.setEmpty();
        return energy;
    }

    @Override
    public FloatingLong getShare() {
        return this.buffer.getEnergy();
    }

    @Override
    public boolean noBufferOrFallback() {
        return this.getBufferWithFallback().isZero();
    }

    @Override
    @Nonnull
    public FloatingLong getBufferWithFallback() {
        FloatingLong buffer = this.releaseShare();
        if (buffer.isZero() && this.getTransmitter().hasTransmitterNetwork()) {
            return ((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).getBuffer();
        }
        return buffer;
    }

    @Override
    public void takeShare() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            EnergyNetwork transmitterNetwork = (EnergyNetwork)this.getTransmitter().getTransmitterNetwork();
            if (!transmitterNetwork.energyContainer.isEmpty() && !this.lastWrite.isZero()) {
                transmitterNetwork.energyContainer.setEnergy(transmitterNetwork.energyContainer.getEnergy().subtract(this.lastWrite));
                this.buffer.setEnergy(this.lastWrite);
            }
        }
    }

    @Override
    @Nonnull
    public FloatingLong getCapacityAsFloatingLong() {
        return this.tier.getCableCapacity();
    }

    @Override
    public long getCapacity() {
        return this.getCapacityAsFloatingLong().longValue();
    }

    private FloatingLong takeEnergy(FloatingLong amount, Action action) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return ((EnergyNetwork)this.getTransmitter().getTransmitterNetwork()).energyContainer.insert(amount, action, AutomationType.INTERNAL);
        }
        return this.buffer.insert(amount, action, AutomationType.INTERNAL);
    }

    @Override
    public IStrictEnergyHandler getCachedAcceptor(Direction side) {
        return EnergyCompatUtils.getStrictEnergyHandler(this.getCachedTile(side), side.func_176734_d());
    }

    @Override
    protected boolean canUpgrade(AlloyTier alloyTier) {
        return alloyTier.getBaseTier().ordinal() == this.tier.getBaseTier().ordinal() + 1;
    }

    @Override
    @Nonnull
    protected BlockState upgradeResult(@Nonnull BlockState current, @Nonnull BaseTier tier) {
        switch (tier) {
            case BASIC: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.BASIC_UNIVERSAL_CABLE.getBlock().func_176223_P());
            }
            case ADVANCED: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ADVANCED_UNIVERSAL_CABLE.getBlock().func_176223_P());
            }
            case ELITE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ELITE_UNIVERSAL_CABLE.getBlock().func_176223_P());
            }
            case ULTIMATE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ULTIMATE_UNIVERSAL_CABLE.getBlock().func_176223_P());
            }
        }
        return current;
    }

    @Override
    @Nullable
    protected UniversalCableUpgradeData getUpgradeData() {
        return new UniversalCableUpgradeData(this.redstoneReactive, this.connectionTypes, this.buffer);
    }

    @Override
    protected void parseUpgradeData(@Nonnull TransmitterUpgradeData upgradeData) {
        if (upgradeData instanceof UniversalCableUpgradeData) {
            UniversalCableUpgradeData data = (UniversalCableUpgradeData)upgradeData;
            this.redstoneReactive = data.redstoneReactive;
            this.connectionTypes = data.connectionTypes;
            this.buffer.setEnergy(data.buffer.getEnergy());
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        TransmitterImpl transmitter = this.getTransmitter();
        if (transmitter.hasTransmitterNetwork()) {
            updateTag.func_74778_a("energy", ((EnergyNetwork)transmitter.getTransmitterNetwork()).energyContainer.getEnergy().toString());
            updateTag.func_74776_a("scale", ((EnergyNetwork)transmitter.getTransmitterNetwork()).energyScale);
        }
        return updateTag;
    }

    @Override
    protected void handleContentsUpdateTag(@Nonnull EnergyNetwork network, @Nonnull CompoundNBT tag) {
        NBTUtils.setFloatingLongIfPresent(tag, "energy", network.energyContainer::setEnergy);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            network.energyScale = scale;
        });
    }
}

