/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.security;

import javax.annotation.Nonnull;
import mekanism.common.config.MekanismConfig;
import mekanism.common.security.IOwnerItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.item.ItemStack;

public interface ISecurityItem
extends IOwnerItem {
    default public ISecurityTile.SecurityMode getSecurity(@Nonnull ItemStack stack) {
        if (!MekanismConfig.general.allowProtection.get()) {
            return ISecurityTile.SecurityMode.PUBLIC;
        }
        return ISecurityTile.SecurityMode.byIndexStatic(ItemDataUtils.getInt(stack, "securityMode"));
    }

    default public void setSecurity(@Nonnull ItemStack stack, ISecurityTile.SecurityMode mode) {
        ItemDataUtils.setInt(stack, "securityMode", mode.ordinal());
    }
}

