/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.recipe.upgrade.RecipeUpgradeType;
import mekanism.common.registries.MekanismRecipeSerializers;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MekanismShapedRecipe
implements ICraftingRecipe,
IShapedRecipe<CraftingInventory> {
    private final ShapedRecipe internal;

    public MekanismShapedRecipe(ShapedRecipe internal) {
        this.internal = internal;
    }

    public ShapedRecipe getInternal() {
        return this.internal;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return MekanismRecipeSerializers.MEK_DATA.getRecipeSerializer();
    }

    public boolean matches(CraftingInventory inv, World world) {
        return this.internal.func_77569_a(inv, world) && !this.getCraftingResult(inv).func_190926_b();
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        if (this.func_77571_b().func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack toReturn = this.func_77571_b().func_77946_l();
        ArrayList<ItemStack> nbtInputs = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !stack.func_77942_o()) continue;
            nbtInputs.add(stack);
        }
        if (nbtInputs.isEmpty()) {
            return toReturn;
        }
        Set<RecipeUpgradeType> supportedTypes = RecipeUpgradeData.getSupportedTypes(toReturn);
        if (supportedTypes.isEmpty()) {
            return toReturn;
        }
        EnumMap<RecipeUpgradeType, List> upgradeInfo = new EnumMap<RecipeUpgradeType, List>(RecipeUpgradeType.class);
        for (ItemStack itemStack : nbtInputs) {
            Set<RecipeUpgradeType> stackSupportedTypes = RecipeUpgradeData.getSupportedTypes(itemStack);
            for (RecipeUpgradeType supportedType : stackSupportedTypes) {
                RecipeUpgradeData<?> data;
                if (!supportedTypes.contains((Object)supportedType) || (data = RecipeUpgradeData.getUpgradeData(supportedType, itemStack)) == null) continue;
                upgradeInfo.computeIfAbsent(supportedType, type -> new ArrayList()).add(data);
            }
        }
        for (Map.Entry entry : upgradeInfo.entrySet()) {
            Object data;
            List upgradeData = (List)entry.getValue();
            if (upgradeData.isEmpty() || (data = RecipeUpgradeData.mergeUpgradeData(upgradeData)) != null && data.applyToStack(toReturn)) continue;
            return ItemStack.field_190927_a;
        }
        return toReturn;
    }

    public boolean func_194133_a(int width, int height) {
        return this.internal.func_194133_a(width, height);
    }

    public ItemStack func_77571_b() {
        return this.internal.func_77571_b();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        return this.internal.func_179532_b((IInventory)inv);
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.internal.func_192400_c();
    }

    public boolean func_192399_d() {
        return this.internal.func_192399_d();
    }

    public String func_193358_e() {
        return this.internal.func_193358_e();
    }

    public ItemStack func_222128_h() {
        return this.internal.func_222128_h();
    }

    public ResourceLocation func_199560_c() {
        return this.internal.func_199560_c();
    }

    public int getRecipeWidth() {
        return this.internal.getRecipeWidth();
    }

    public int getRecipeHeight() {
        return this.internal.getRecipeHeight();
    }
}

