/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mekanism.common.frequency.Frequency;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.network.container.property.FrequencyPropertyData;
import mekanism.common.network.container.property.PropertyData;

public class SyncableFrequency<FREQUENCY extends Frequency>
implements ISyncableData {
    private final Supplier<FREQUENCY> getter;
    private final Consumer<FREQUENCY> setter;
    private int lastKnownHashCode;

    public static <FREQUENCY extends Frequency> SyncableFrequency<FREQUENCY> create(Supplier<FREQUENCY> getter, Consumer<FREQUENCY> setter) {
        return new SyncableFrequency<FREQUENCY>(getter, setter);
    }

    private SyncableFrequency(Supplier<FREQUENCY> getter, Consumer<FREQUENCY> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @Nullable
    public FREQUENCY get() {
        return (FREQUENCY)((Frequency)this.getter.get());
    }

    public void set(@Nullable FREQUENCY value) {
        this.setter.accept(value);
    }

    @Override
    public ISyncableData.DirtyType isDirty() {
        int valueHashCode;
        FREQUENCY value = this.get();
        int n = valueHashCode = value == null ? 0 : ((Frequency)value).hashCode();
        if (this.lastKnownHashCode == valueHashCode) {
            return ISyncableData.DirtyType.CLEAN;
        }
        this.lastKnownHashCode = valueHashCode;
        return ISyncableData.DirtyType.DIRTY;
    }

    @Override
    public PropertyData getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        return new FrequencyPropertyData<FREQUENCY>(property, this.get());
    }
}

