/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.theoneprobe;

import mekanism.api.math.FloatingLong;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.integration.theoneprobe.TOPElement;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;

public class EnergyElement
extends TOPElement {
    public static int ID;
    private final FloatingLong energy;
    private final FloatingLong maxEnergy;

    public EnergyElement(FloatingLong energy, FloatingLong maxEnergy) {
        super(-16777216, 0xFFFFFF);
        this.energy = energy;
        this.maxEnergy = maxEnergy;
    }

    public EnergyElement(PacketBuffer buf) {
        this(FloatingLong.readFromBuffer(buf), FloatingLong.readFromBuffer(buf));
    }

    public void toBytes(PacketBuffer buf) {
        this.energy.writeToBuffer(buf);
        this.maxEnergy.writeToBuffer(buf);
    }

    @Override
    public int getScaledLevel(int level) {
        if (this.energy.equals(FloatingLong.MAX_VALUE)) {
            return level;
        }
        return (int)((double)level * this.energy.divideToLevel(this.maxEnergy));
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return MekanismRenderer.energyIcon;
    }

    @Override
    public ITextComponent getText() {
        return EnergyDisplay.of(this.energy, this.maxEnergy).getTextComponent();
    }

    public int getID() {
        return ID;
    }
}

