/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mekanism.common.Mekanism;
import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.HashedItem;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.items.IItemHandler;

public class TransitRequest {
    private final TransitResponse EMPTY_RESPONSE = new TransitResponse();
    private Map<HashedItem, SlotData> itemMap = new Object2ObjectOpenHashMap();

    public static TransitRequest getFromTransport(TransporterStack stack) {
        return TransitRequest.getFromStack(stack.itemStack);
    }

    public static TransitRequest getFromStack(ItemStack stack) {
        TransitRequest ret = new TransitRequest();
        ret.addItem(stack, -1);
        return ret;
    }

    public static TransitRequest buildInventoryMap(TileEntity tile, Direction side, int amount) {
        return TransitRequest.buildInventoryMap(tile, side, amount, new Finder.FirstFinder());
    }

    public static TransitRequest buildInventoryMap(TileEntity tile, Direction side, int amount, Finder finder) {
        TransitRequest ret = new TransitRequest();
        Object2IntOpenHashMap itemCountMap = new Object2IntOpenHashMap();
        IItemHandler inventory = InventoryUtils.assertItemHandler("TransitRequest", tile, side.func_176734_d());
        if (inventory == null) {
            return ret;
        }
        for (int i = inventory.getSlots() - 1; i >= 0; --i) {
            int toUse;
            ItemStack stack = inventory.extractItem(i, amount, true);
            if (stack.func_190926_b() || !finder.modifies(stack)) continue;
            HashedItem hashed = new HashedItem(stack);
            int currentCount = itemCountMap.getOrDefault((Object)hashed, -1);
            int n = toUse = currentCount != -1 ? Math.min(stack.func_190916_E(), amount - currentCount) : stack.func_190916_E();
            if (toUse == 0) continue;
            ret.addItem(StackUtils.size(stack, toUse), i);
            if (currentCount != -1) {
                itemCountMap.put((Object)hashed, currentCount + toUse);
                continue;
            }
            itemCountMap.put((Object)hashed, toUse);
        }
        return ret;
    }

    public Map<HashedItem, SlotData> getItemMap() {
        return this.itemMap;
    }

    public boolean isEmpty() {
        return this.itemMap.isEmpty();
    }

    public void addItem(ItemStack stack, int slot) {
        HashedItem hashed = new HashedItem(stack);
        this.itemMap.computeIfAbsent(hashed, SlotData::new).addSlot(slot, stack);
    }

    public ItemStack getSingleStack() {
        return this.itemMap.keySet().iterator().next().getStack();
    }

    public boolean hasType(ItemStack stack) {
        return this.itemMap.keySet().stream().anyMatch(item -> InventoryUtils.areItemsStackable(stack, item.getStack()));
    }

    public TransitResponse createResponse(ItemStack toSend, SlotData slotData) {
        return new TransitResponse(toSend, slotData);
    }

    public TransitResponse getEmptyResponse() {
        return this.EMPTY_RESPONSE;
    }

    public static class SlotData {
        private HashedItem itemType;
        private int totalCount = 0;
        private Int2IntMap slotCountMap = new Int2IntOpenHashMap();

        public SlotData(HashedItem itemType) {
            this.itemType = itemType;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public int getSlotCount(int slot) {
            return this.slotCountMap.get(slot);
        }

        public void addSlot(int slot, ItemStack stack) {
            if (this.slotCountMap.containsKey(slot)) {
                Mekanism.logger.error("Attempted to track an already-tracked slot in a new TransitRequest.");
                Mekanism.logger.error("Item: " + stack.func_200301_q());
                return;
            }
            this.slotCountMap.put(slot, stack.func_190916_E());
            this.totalCount += stack.func_190916_E();
        }

        public boolean use(int slot, int amount) {
            int stored = this.getSlotCount(slot);
            this.totalCount -= amount;
            this.slotCountMap.put(slot, stored - amount);
            return stored == amount;
        }
    }

    public class TransitResponse {
        private ItemStack toSend = ItemStack.field_190927_a;
        private SlotData slotData;

        private TransitResponse() {
        }

        public TransitResponse(ItemStack toSend, SlotData slotData) {
            this.toSend = toSend;
            this.slotData = slotData;
        }

        public ItemStack getStack() {
            return this.toSend;
        }

        public int getSendingAmount() {
            return this.toSend.func_190916_E();
        }

        public boolean use(int slot, int amount) {
            boolean empty = this.slotData.use(slot, amount);
            if (this.slotData.getTotalCount() == 0) {
                TransitRequest.this.itemMap.remove(this.slotData.itemType);
            }
            return empty;
        }

        public boolean isEmpty() {
            return this.toSend.func_190926_b() || this.slotData.getTotalCount() == 0;
        }

        public ItemStack getRejected(ItemStack orig) {
            return StackUtils.size(orig, orig.func_190916_E() - this.getSendingAmount());
        }

        public void use(TileEntity tile, Direction side) {
            if (this.isEmpty()) {
                return;
            }
            InvStack stack = new InvStack(tile, this.toSend, this.slotData.slotCountMap, side);
            stack.use(this);
        }

        public void removeSlot(int slot) {
            this.slotData.slotCountMap.remove(slot);
        }
    }
}

