/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.heat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.capabilities.holder.ConfigHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.slot.HeatSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import net.minecraft.util.Direction;

public class ConfigHeatCapacitorHolder
extends ConfigHolder
implements IHeatCapacitorHolder {
    protected final List<IHeatCapacitor> capacitors = new ArrayList<IHeatCapacitor>();

    protected ConfigHeatCapacitorHolder(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
        super(facingSupplier, configSupplier);
    }

    @Override
    protected TransmissionType getTransmissionType() {
        return TransmissionType.HEAT;
    }

    @Override
    @Nonnull
    public List<IHeatCapacitor> getHeatCapacitors(@Nullable Direction direction) {
        if (direction == null) {
            return this.capacitors;
        }
        TileComponentConfig config = (TileComponentConfig)this.configSupplier.get();
        if (config == null) {
            return this.capacitors;
        }
        ConfigInfo configInfo = config.getConfig(this.getTransmissionType());
        if (configInfo == null) {
            return this.capacitors;
        }
        RelativeSide side = RelativeSide.fromDirections((Direction)this.facingSupplier.get(), direction);
        ISlotInfo slotInfo = configInfo.getSlotInfo(side);
        if (slotInfo instanceof HeatSlotInfo && slotInfo.isEnabled()) {
            return ((HeatSlotInfo)slotInfo).getHeatCapacitors();
        }
        return Collections.emptyList();
    }

    void addCapacitor(@Nonnull IHeatCapacitor capacitor) {
        this.capacitors.add(capacitor);
    }
}

