/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.chemical;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.capabilities.holder.chemical.ConfigChemicalTankHolder;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.slot.GasSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import net.minecraft.util.Direction;

public class ConfigGasTankHolder
extends ConfigChemicalTankHolder<Gas, GasStack, IGasTank> {
    public ConfigGasTankHolder(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
        super(facingSupplier, configSupplier);
    }

    @Override
    protected TransmissionType getTransmissionType() {
        return TransmissionType.GAS;
    }

    @Override
    @Nonnull
    public List<IGasTank> getTanks(@Nullable Direction direction) {
        if (direction == null) {
            return this.tanks;
        }
        TileComponentConfig config = (TileComponentConfig)this.configSupplier.get();
        if (config == null) {
            return this.tanks;
        }
        ConfigInfo configInfo = config.getConfig(this.getTransmissionType());
        if (configInfo == null) {
            return this.tanks;
        }
        RelativeSide side = RelativeSide.fromDirections((Direction)this.facingSupplier.get(), direction);
        ISlotInfo slotInfo = configInfo.getSlotInfo(side);
        if (slotInfo instanceof GasSlotInfo && slotInfo.isEnabled()) {
            return ((GasSlotInfo)slotInfo).getTanks();
        }
        return Collections.emptyList();
    }
}

