/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.MekanismClient;
import mekanism.client.model.ModelEnergyCube;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;

@ParametersAreNonnullByDefault
public class RenderEnergyCube
extends MekanismTileEntityRenderer<TileEntityEnergyCube> {
    public static final Vector3f coreVec = new Vector3f(0.0f, MekanismUtils.ONE_OVER_ROOT_TWO, MekanismUtils.ONE_OVER_ROOT_TWO);
    private final ModelEnergyCube model = new ModelEnergyCube();
    private final ModelEnergyCube.ModelEnergyCore core = new ModelEnergyCube.ModelEnergyCore();

    public RenderEnergyCube(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    @Override
    protected void render(TileEntityEnergyCube tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        profiler.func_76320_a("frame");
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 1.5, 0.5);
        switch (tile.getDirection()) {
            case DOWN: {
                matrix.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(90.0f));
                matrix.func_227861_a_(0.0, 1.0, -1.0);
                break;
            }
            case UP: {
                matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                matrix.func_227861_a_(0.0, 1.0, 1.0);
                break;
            }
            default: {
                MekanismRenderer.rotate(matrix, tile.getDirection(), 0.0f, 180.0f, 90.0f, 270.0f);
            }
        }
        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        profiler.func_76320_a("corners");
        this.model.render(matrix, renderer, light, overlayLight, tile.getTier(), false);
        profiler.func_219895_b("sides");
        this.model.renderSidesBatched(tile, matrix, renderer, light, overlayLight);
        profiler.func_76319_b();
        matrix.func_227865_b_();
        profiler.func_219895_b("core");
        float energyScale = tile.getEnergyScale();
        if (energyScale > 0.0f) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.5, 0.5, 0.5);
            float ticks = (float)MekanismClient.ticksPassed + partialTick;
            matrix.func_227862_a_(0.4f, 0.4f, 0.4f);
            matrix.func_227861_a_(0.0, Math.sin(Math.toRadians(3.0f * ticks)) / 7.0, 0.0);
            float scaledTicks = 4.0f * ticks;
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(scaledTicks));
            matrix.func_227863_a_(coreVec.func_229187_a_(36.0f + scaledTicks));
            this.core.render(matrix, renderer, 0xF000F0, overlayLight, tile.getTier().getBaseTier().getColor(), energyScale);
            matrix.func_227865_b_();
        }
        profiler.func_76319_b();
    }

    @Override
    protected String getProfilerSection() {
        return "energyCube";
    }
}

