/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.filter.GuiFilter;
import mekanism.client.sound.SoundHandler;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.inventory.container.tile.filter.FilterContainer;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiFilterBase<FILTER extends IFilter<FILTER>, TILE extends TileEntityMekanism, CONTAINER extends FilterContainer<FILTER, TILE>>
extends GuiFilter<TILE, CONTAINER> {
    protected ITextComponent status = MekanismLang.STATUS_OK.translateColored(EnumColor.DARK_GREEN, new Object[0]);
    protected FILTER origFilter;
    protected FILTER filter;
    protected boolean isNew;
    protected int ticker;
    protected MekanismButton saveButton;
    protected MekanismButton deleteButton;

    protected GuiFilterBase(CONTAINER container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    @Override
    public void init() {
        super.init();
        if (this.isNew) {
            this.deleteButton.active = false;
        }
    }

    protected GuiElement.IHoverable getOnHoverReplace(MinerFilter<?> filter) {
        return this.getOnHover(() -> MekanismLang.MINER_REQUIRE_REPLACE.translate(BooleanStateDisplay.YesNo.of(filter.requireStack)));
    }

    protected void drawMinerForegroundLayer(ItemStack stack) {
        if (this.filter instanceof MinerFilter) {
            MinerFilter mFilter = (MinerFilter)this.filter;
            this.renderItem(stack, 12, 19);
            this.renderItem(mFilter.replaceStack, 149, 19);
        }
    }

    protected void drawTransporterForegroundLayer(@Nonnull ItemStack stack) {
        if (this.filter instanceof TransporterFilter) {
            TransporterFilter tFilter = (TransporterFilter)this.filter;
            this.drawString(BooleanStateDisplay.OnOff.of(tFilter.allowDefault).getTextComponent(), 24, 66, 0x404040);
            this.renderItem(stack, 12, 19);
        }
    }

    protected void minerFilterClickCommon(double xAxis, double yAxis, MinerFilter<?> filter) {
        if (xAxis >= 149.0 && xAxis <= 165.0 && yAxis >= 19.0 && yAxis <= 35.0) {
            boolean doNull = false;
            ItemStack stack = this.minecraft.field_71439_g.field_71071_by.func_70445_o();
            ItemStack toUse = ItemStack.field_190927_a;
            if (!stack.func_190926_b() && !GuiFilterBase.hasShiftDown()) {
                if (stack.func_77973_b() instanceof BlockItem && Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150357_h) {
                    toUse = stack.func_77946_l();
                    toUse.func_190920_e(1);
                }
            } else if (stack.func_190926_b() && GuiFilterBase.hasShiftDown()) {
                doNull = true;
            }
            if (!toUse.func_190926_b() || doNull) {
                filter.replaceStack = toUse;
            }
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        }
    }
}

