/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiScalableElement;
import mekanism.client.gui.element.scroll.GuiScrollableElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;

public abstract class GuiScrollList
extends GuiScrollableElement {
    protected static final ResourceLocation SCROLL_LIST = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "scroll_list.png");
    protected static int TEXTURE_WIDTH = 6;
    protected static int TEXTURE_HEIGHT = 6;
    private final GuiScalableElement background;
    protected final int elementHeight;

    protected GuiScrollList(IGuiWrapper gui, int x, int y, int width, int height, int elementHeight, GuiScalableElement background) {
        super(SCROLL_LIST, gui, x, y, width, height, width - 6, 2, 4, 4, height - 4);
        this.elementHeight = elementHeight;
        this.background = background;
    }

    @Override
    protected int getFocusedElements() {
        return (this.height - 2) / this.elementHeight;
    }

    public abstract boolean hasSelection();

    protected abstract void setSelected(int var1);

    public abstract void clearSelection();

    protected abstract void renderElements(int var1, int var2, float var3);

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        this.background.renderButton(mouseX, mouseY, partialTicks);
        GuiElement.minecraft.field_71446_o.func_110577_a(this.getResource());
        AbstractGui.blit((int)(this.barX - 1), (int)(this.barY - 1), (float)0.0f, (float)0.0f, (int)TEXTURE_WIDTH, (int)1, (int)TEXTURE_WIDTH, (int)TEXTURE_HEIGHT);
        AbstractGui.blit((int)(this.barX - 1), (int)this.barY, (int)6, (int)this.maxBarHeight, (float)0.0f, (float)1.0f, (int)TEXTURE_WIDTH, (int)1, (int)TEXTURE_WIDTH, (int)TEXTURE_HEIGHT);
        AbstractGui.blit((int)(this.barX - 1), (int)(this.y + this.maxBarHeight + 2), (float)0.0f, (float)0.0f, (int)TEXTURE_WIDTH, (int)1, (int)TEXTURE_WIDTH, (int)TEXTURE_HEIGHT);
        AbstractGui.blit((int)this.barX, (int)(this.barY + this.getScroll()), (float)0.0f, (float)2.0f, (int)this.barWidth, (int)this.barHeight, (int)TEXTURE_WIDTH, (int)TEXTURE_HEIGHT);
        this.renderElements(mouseX, mouseY, partialTicks);
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
        if (mouseX >= (double)(this.x + 1) && mouseX < (double)(this.barX - 1) && mouseY >= (double)(this.y + 1) && mouseY < (double)(this.y + this.height - 1)) {
            int index = this.getCurrentSelection();
            this.clearSelection();
            for (int i = 0; i < this.getFocusedElements(); ++i) {
                int shiftedY;
                if (index + i >= this.getMaxElements() || !(mouseY >= (double)(shiftedY = this.y + 1 + this.elementHeight * i)) || !(mouseY <= (double)(shiftedY + this.elementHeight))) continue;
                this.setSelected(index + i);
                break;
            }
        } else {
            super.onClick(mouseX, mouseY);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        return this.isMouseOver(mouseX, mouseY) && this.adjustScroll(delta);
    }
}

