/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.providers;

import javax.annotation.Nonnull;
import mekanism.api.providers.IBaseProvider;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public interface IFluidProvider
extends IBaseProvider {
    @Nonnull
    public Fluid getFluid();

    default public boolean fluidMatches(FluidStack other) {
        return this.getFluid() == other.getFluid();
    }

    @Nonnull
    default public FluidStack getFluidStack(int size) {
        return new FluidStack(this.getFluid(), size);
    }

    @Override
    default public ResourceLocation getRegistryName() {
        return this.getFluid().getRegistryName();
    }

    @Override
    default public ITextComponent getTextComponent() {
        return this.getFluid().getAttributes().getDisplayName(this.getFluidStack(1));
    }

    @Override
    default public String getTranslationKey() {
        return this.getFluid().getAttributes().getTranslationKey();
    }
}

