/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.dimension.DimensionType;

public class Coord4D {
    private static final Direction[] DIRECTIONS = Direction.values();
    public int x;
    public int y;
    public int z;
    public DimensionType dimension;

    public Coord4D(Entity entity) {
        BlockPos entityPosition = entity.func_180425_c();
        this.x = entityPosition.func_177958_n();
        this.y = entityPosition.func_177956_o();
        this.z = entityPosition.func_177952_p();
        this.dimension = entity.field_70170_p.func_201675_m().func_186058_p();
    }

    public Coord4D(double x, double y, double z, DimensionType dimension) {
        this.x = MathHelper.func_76128_c((double)x);
        this.y = MathHelper.func_76128_c((double)y);
        this.z = MathHelper.func_76128_c((double)z);
        this.dimension = dimension;
    }

    public Coord4D(BlockPos pos, IWorldReader world) {
        this(pos, world.func_201675_m().func_186058_p());
    }

    public Coord4D(BlockPos pos, DimensionType dimension) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dimension);
    }

    public Coord4D(BlockRayTraceResult mop, IWorldReader world) {
        this(mop.func_216350_a(), world);
    }

    public static Coord4D get(TileEntity tile) {
        return new Coord4D(tile.func_174877_v(), (IWorldReader)tile.func_145831_w());
    }

    public static Coord4D read(CompoundNBT tag) {
        return new Coord4D(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"), DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(tag.func_74779_i("dimension"))));
    }

    public static Coord4D read(PacketBuffer dataStream) {
        return new Coord4D(dataStream.func_179259_c(), DimensionType.func_193417_a((ResourceLocation)dataStream.func_192575_l()));
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public CompoundNBT write(CompoundNBT nbtTags) {
        nbtTags.func_74768_a("x", this.x);
        nbtTags.func_74768_a("y", this.y);
        nbtTags.func_74768_a("z", this.z);
        nbtTags.func_74778_a("dimension", this.dimension.getRegistryName().toString());
        return nbtTags;
    }

    public void write(PacketBuffer dataStream) {
        dataStream.func_179255_a(this.getPos());
        dataStream.func_192572_a(this.dimension.getRegistryName());
    }

    public Coord4D translate(int x, int y, int z) {
        return new Coord4D(this.x + x, this.y + y, this.z + z, this.dimension);
    }

    public Coord4D offset(Direction side) {
        return this.offset(side, 1);
    }

    public Coord4D offset(Direction side, int amount) {
        if (side == null || amount == 0) {
            return this;
        }
        return new Coord4D(this.x + side.func_82601_c() * amount, this.y + side.func_96559_d() * amount, this.z + side.func_82599_e() * amount, this.dimension);
    }

    public Direction sideDifference(Coord4D other) {
        Coord4D diff = new Coord4D(this.x - other.x, this.y - other.y, this.z - other.z, this.dimension);
        for (Direction side : DIRECTIONS) {
            if (side.func_82601_c() != diff.x || side.func_96559_d() != diff.y || side.func_82599_e() != diff.z) continue;
            return side;
        }
        return null;
    }

    public double distanceTo(Coord4D obj) {
        int subX = this.x - obj.x;
        int subY = this.y - obj.y;
        int subZ = this.z - obj.z;
        return MathHelper.func_76129_c((float)(subX * subX + subY * subY + subZ * subZ));
    }

    public AxisAlignedBB getBoundingBox() {
        return new AxisAlignedBB((double)this.x, (double)this.y, (double)this.z, (double)(this.x + 1), (double)(this.y + 1), (double)(this.z + 1));
    }

    public String toString() {
        return "[Coord4D: " + this.x + ", " + this.y + ", " + this.z + ", dim=" + this.dimension + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Coord4D && ((Coord4D)obj).x == this.x && ((Coord4D)obj).y == this.y && ((Coord4D)obj).z == this.z && ((Coord4D)obj).dimension == this.dimension;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.x;
        code = 31 * code + this.y;
        code = 31 * code + this.z;
        code = 31 * code + this.dimension.hashCode();
        return code;
    }
}

