/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.parts.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.event.GetStatModifierEvent;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.IPartSerializer;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.PartItem;
import net.silentchaos512.gear.parts.AbstractGearPart;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartPositions;

public final class ComplexRodPart
extends AbstractGearPart {
    public static final IPartSerializer<ComplexRodPart> SERIALIZER = new Serializer(SilentGear.getId("complex_rod"), ComplexRodPart::new);

    public ComplexRodPart(ResourceLocation name) {
        super(name);
    }

    @Override
    public PartType getType() {
        return PartType.ROD;
    }

    @Override
    public IPartPosition getPartPosition() {
        return PartPositions.ROD;
    }

    @Override
    public IPartSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public Collection<StatInstance> getStatModifiers(ItemStack gear, ItemStat stat, PartData part) {
        ArrayList<StatInstance> baseStats = new ArrayList<StatInstance>(this.stats.get(stat));
        ItemStack stack = part.getCraftingItem();
        if (!(stack.func_77973_b() instanceof PartItem)) {
            return baseStats;
        }
        Collection<MaterialInstance> materials = PartItem.getMaterials(stack);
        Collection statMods = materials.stream().flatMap(m -> m.getStatModifiers(stat, this.getType(), gear).stream()).collect(Collectors.toList());
        ArrayList<StatInstance> ret = new ArrayList<StatInstance>(baseStats);
        for (StatInstance.Operation op : StatInstance.Operation.values()) {
            Collection modsForOp = statMods.stream().filter(s -> s.getOp() == op).collect(Collectors.toList());
            if (modsForOp.isEmpty()) continue;
            ret.add(StatInstance.getWeightedAverageMod(modsForOp, op));
        }
        GetStatModifierEvent event = new GetStatModifierEvent(part, stat, ret);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getModifiers();
    }

    private static class Serializer
    extends AbstractGearPart.Serializer<ComplexRodPart> {
        public Serializer(ResourceLocation serializerId, Function<ResourceLocation, ComplexRodPart> function) {
            super(serializerId, function);
        }
    }
}

