/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.parts;

import com.google.gson.JsonObject;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.silentchaos512.gear.api.parts.IPartDisplay;
import net.silentchaos512.gear.parts.PartTextureType;
import net.silentchaos512.utils.Color;
import net.silentchaos512.utils.EnumUtils;

public final class PartDisplay
implements IPartDisplay {
    public static final PartDisplay DEFAULT = new PartDisplay();
    private String textureDomain = "silentgear";
    private String textureSuffix = "";
    private String armorTexture = "";
    private int normalColor = 0xFFFFFF;
    private int brokenColor = 0xFFFFFF;
    private int fallbackColor = 0xFFFFFF;
    private int armorColor = 0xFFFFFF;
    private boolean highlight = false;
    private PartTextureType liteTexture = PartTextureType.HIGH_CONTRAST_WITH_HIGHLIGHT;

    @Override
    public String getTextureDomain() {
        return this.textureDomain;
    }

    @Override
    public String getTextureSuffix() {
        return this.textureSuffix;
    }

    @Override
    public String getArmorTexturePrefix() {
        return this.armorTexture;
    }

    @Override
    public int getNormalColor() {
        return this.normalColor;
    }

    @Override
    public int getBrokenColor() {
        return this.brokenColor;
    }

    @Override
    public int getFallbackColor() {
        return this.fallbackColor;
    }

    @Override
    public int getArmorColor() {
        return this.armorColor;
    }

    @Override
    public boolean hasHighlight() {
        return this.highlight;
    }

    @Override
    public PartTextureType getLiteTexture() {
        return this.liteTexture;
    }

    public static PartDisplay from(JsonObject json, IPartDisplay defaultProps) {
        PartDisplay props = new PartDisplay();
        props.textureDomain = JSONUtils.func_151219_a((JsonObject)json, (String)"texture_domain", (String)defaultProps.getTextureDomain());
        props.textureSuffix = JSONUtils.func_151219_a((JsonObject)json, (String)"texture_suffix", (String)defaultProps.getTextureSuffix());
        props.armorTexture = JSONUtils.func_151219_a((JsonObject)json, (String)"armor_texture", (String)props.textureSuffix);
        props.normalColor = PartDisplay.loadColor(json, defaultProps.getNormalColor(), defaultProps.getNormalColor(), "normal_color", "texture_color");
        props.brokenColor = PartDisplay.loadColor(json, defaultProps.getBrokenColor(), props.normalColor, "broken_color");
        props.fallbackColor = PartDisplay.loadColor(json, defaultProps.getFallbackColor(), props.brokenColor, "fallback_color");
        props.armorColor = PartDisplay.loadColor(json, defaultProps.getArmorColor(), props.fallbackColor, "armor_color");
        props.highlight = JSONUtils.func_151209_a((JsonObject)json, (String)"highlight", (boolean)props.highlight);
        props.liteTexture = (PartTextureType)EnumUtils.byName((String)JSONUtils.func_151219_a((JsonObject)json, (String)"lite_texture", (String)""), (Enum)props.liteTexture);
        return props;
    }

    private static int loadColor(JsonObject json, int defaultValue, int fallback, String ... keys) {
        for (String key : keys) {
            if (!json.has(key)) continue;
            return Color.from((JsonObject)json, (String)key, (int)defaultValue).getColor();
        }
        return fallback;
    }

    public static PartDisplay read(PacketBuffer buffer) {
        PartDisplay display = new PartDisplay();
        display.textureDomain = buffer.func_150789_c(255);
        display.textureSuffix = buffer.func_150789_c(32676);
        display.armorTexture = buffer.func_150789_c(32676);
        display.normalColor = buffer.func_150792_a();
        display.brokenColor = buffer.func_150792_a();
        display.fallbackColor = buffer.func_150792_a();
        display.armorColor = buffer.func_150792_a();
        display.highlight = buffer.readBoolean();
        display.liteTexture = (PartTextureType)EnumUtils.byOrdinal((int)buffer.readByte(), (Enum)PartTextureType.HIGH_CONTRAST_WITH_HIGHLIGHT);
        return display;
    }

    public static void write(PacketBuffer buffer, PartDisplay display) {
        buffer.func_180714_a(display.textureDomain);
        buffer.func_180714_a(display.textureSuffix);
        buffer.func_180714_a(display.armorTexture);
        buffer.func_150787_b(display.normalColor);
        buffer.func_150787_b(display.brokenColor);
        buffer.func_150787_b(display.fallbackColor);
        buffer.func_150787_b(display.armorColor);
        buffer.writeBoolean(display.highlight);
        buffer.writeByte(display.liteTexture.getIndex());
    }

    public String toString() {
        return "PartDisplay{textureDomain='" + this.textureDomain + '\'' + ", textureSuffix='" + this.textureSuffix + '\'' + ", armorTexture='" + this.armorTexture + '\'' + ", normalColor=" + Integer.toHexString(this.normalColor) + ", brokenColor=" + Integer.toHexString(this.brokenColor) + ", fallbackColor=" + Integer.toHexString(this.fallbackColor) + ", armorColor=" + Integer.toHexString(this.armorColor) + ", highlight=" + this.highlight + '}';
    }
}

