/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.traits.TraitConst;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;

public class CorePickaxe
extends PickaxeItem
implements ICoreTool {
    private static final Set<Material> BASE_EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.field_151576_e, (Object)Material.field_151574_g, (Object)Material.field_151588_w, (Object)Material.field_151573_f, (Object)Material.field_151598_x, (Object)Material.field_151576_e, (Object[])new Material[0]);
    private static final Set<Material> EXTRA_EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.field_151594_q, (Object)Material.field_151592_s, (Object)Material.field_76233_E, (Object)Material.field_151591_t);
    private static final ImmutableSet<ToolType> TOOL_CLASSES_BASE = ImmutableSet.of((Object)ToolType.PICKAXE);
    private static final ImmutableSet<ToolType> TOOL_CLASSES_WITH_SPOON = ImmutableSet.of((Object)ToolType.PICKAXE, (Object)ToolType.SHOVEL);
    private final Set<Material> extraMaterials;

    public CorePickaxe() {
        this(EXTRA_EFFECTIVE_MATERIALS);
    }

    public CorePickaxe(Set<Material> extraMaterials) {
        super((IItemTier)ItemTier.DIAMOND, 0, 0.0f, GearHelper.getBuilder(ToolType.PICKAXE));
        this.extraMaterials = extraMaterials;
        GearHelper.addModelTypeProperty(this);
    }

    @Override
    public GearType getGearType() {
        return GearType.PICKAXE;
    }

    @Override
    public Optional<StatInstance> getBaseStatModifier(ItemStat stat) {
        if (stat == ItemStats.MELEE_DAMAGE) {
            return Optional.of(StatInstance.makeBaseMod(1.0f));
        }
        if (stat == ItemStats.ATTACK_SPEED) {
            return Optional.of(StatInstance.makeBaseMod(-2.8f));
        }
        if (stat == ItemStats.REPAIR_EFFICIENCY) {
            return Optional.of(StatInstance.makeBaseMod(1.0f));
        }
        return Optional.empty();
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return this.canHarvestBlock(state, this.getStatInt(stack, ItemStats.HARVEST_LEVEL));
    }

    public boolean func_150897_b(BlockState state) {
        return this.canHarvestBlock(state, 10);
    }

    private boolean canHarvestBlock(BlockState state, int toolLevel) {
        if (state.func_177230_c().getHarvestLevel(state) > toolLevel) {
            return false;
        }
        Material material = state.func_185904_a();
        if (BASE_EFFECTIVE_MATERIALS.contains(material) || this.extraMaterials.contains(material)) {
            return true;
        }
        return super.func_150897_b(state);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return GearHelper.getDestroySpeed(stack, state, this.extraMaterials);
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        return GearHelper.getHarvestLevel(stack, tool, blockState, this.extraMaterials);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public int getItemEnchantability(ItemStack stack) {
        return GearData.getStatInt(stack, ItemStats.ENCHANTABILITY);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        GearHelper.setDamage(stack, damage, (x$0, x$1) -> super.setDamage(x$0, x$1));
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getStatInt(stack, ItemStats.DURABILITY);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return GearHelper.getRarity(stack);
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        if (!GearHelper.isBroken(stack)) {
            if (TraitHelper.getTraitLevel(stack, TraitConst.SPOON) > 0) {
                return TOOL_CLASSES_WITH_SPOON;
            }
            return TOOL_CLASSES_BASE;
        }
        return Collections.emptySet();
    }

    public boolean func_77636_d(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return GearHelper.hitEntity(stack, target, attacker);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        GearHelper.fillItemGroup(this, group, items);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        return GearHelper.onBlockDestroyed(stack, worldIn, state, pos, entityLiving);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return GearHelper.onItemUse(context);
    }
}

