/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;

public class PartItem
extends Item {
    private static final String NBT_MATERIALS = "Materials";
    private final ResourceLocation partId;

    public PartItem(ResourceLocation partId, Item.Properties properties) {
        super(properties);
        this.partId = partId;
    }

    public ItemStack createFromItems(Collection<ItemStack> materials) {
        return this.create(materials.stream().map(MaterialManager::from).filter(Objects::nonNull).map(MaterialInstance::of).collect(Collectors.toList()));
    }

    public ItemStack create(Collection<MaterialInstance> materials) {
        ListNBT materialListNbt = new ListNBT();
        materials.forEach(m -> materialListNbt.add((Object)m.write(new CompoundNBT())));
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a(NBT_MATERIALS, (INBT)materialListNbt);
        ItemStack result = new ItemStack((IItemProvider)this);
        result.func_77982_d(tag);
        return result;
    }

    public static Collection<MaterialInstance> getMaterials(ItemStack stack) {
        ListNBT materialListNbt = stack.func_196082_o().func_150295_c(NBT_MATERIALS, 10);
        return materialListNbt.stream().filter(nbt -> nbt instanceof CompoundNBT).map(nbt -> (CompoundNBT)nbt).map(MaterialInstance::read).collect(Collectors.toList());
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (flagIn.func_194127_a()) {
            tooltip.add(new StringTextComponent("Part ID: " + this.partId).func_211708_a(TextFormatting.DARK_GRAY));
        }
    }
}

