/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.IPartMaterial;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;

public class MaterialInstance
implements IMaterialInstance {
    private static final Map<ResourceLocation, MaterialInstance> QUICK_CACHE = new HashMap<ResourceLocation, MaterialInstance>();
    private final IPartMaterial material;
    private final MaterialGrade grade;
    private final ItemStack item;

    private MaterialInstance(IPartMaterial material) {
        this(material, MaterialGrade.NONE, material.getDisplayItem(PartType.MAIN, 0));
    }

    private MaterialInstance(IPartMaterial material, MaterialGrade grade) {
        this(material, MaterialGrade.NONE, material.getDisplayItem(PartType.MAIN, 0));
    }

    private MaterialInstance(IPartMaterial material, ItemStack craftingItem) {
        this(material, MaterialGrade.NONE, craftingItem);
    }

    private MaterialInstance(IPartMaterial material, MaterialGrade grade, ItemStack craftingItem) {
        this.material = material;
        this.grade = grade;
        this.item = craftingItem;
    }

    public static MaterialInstance of(IPartMaterial material) {
        return QUICK_CACHE.computeIfAbsent(material.getId(), id -> new MaterialInstance(material));
    }

    public static MaterialInstance of(IPartMaterial material, MaterialGrade grade) {
        return new MaterialInstance(material, grade);
    }

    public static MaterialInstance of(IPartMaterial material, ItemStack craftingItem) {
        return new MaterialInstance(material, craftingItem);
    }

    public static MaterialInstance of(IPartMaterial material, MaterialGrade grade, ItemStack craftingItem) {
        return new MaterialInstance(material, grade, craftingItem);
    }

    @Override
    public ResourceLocation getMaterialId() {
        return this.material.getId();
    }

    @Override
    @Nonnull
    public IPartMaterial getMaterial() {
        return this.material;
    }

    @Override
    public MaterialGrade getGrade() {
        return this.grade;
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    public Collection<StatInstance> getStatModifiers(ItemStat stat, PartType partType, ItemStack gear) {
        Collection<StatInstance> mods = this.material.getStatModifiers(gear, stat, partType);
        if (stat.isAffectedByGrades() && this.grade != MaterialGrade.NONE) {
            float bonus = (float)this.grade.bonusPercent / 100.0f;
            mods.add(new StatInstance(bonus, StatInstance.Operation.MUL1));
        }
        return mods;
    }

    @Nullable
    public static MaterialInstance read(CompoundNBT nbt) {
        ResourceLocation id = ResourceLocation.func_208304_a((String)nbt.func_74779_i("ID"));
        IPartMaterial material = MaterialManager.get(id);
        if (material == null) {
            return null;
        }
        MaterialGrade grade = MaterialGrade.fromString(nbt.func_74779_i("Grade"));
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Item"));
        return MaterialInstance.of(material, grade, stack);
    }

    @Nullable
    public static MaterialInstance readFast(CompoundNBT nbt) {
        ResourceLocation id = ResourceLocation.func_208304_a((String)nbt.func_74779_i("ID"));
        IPartMaterial material = MaterialManager.get(id);
        if (material == null) {
            return null;
        }
        return MaterialInstance.of(material);
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        nbt.func_74778_a("ID", this.material.getId().toString());
        nbt.func_74778_a("Grade", this.grade.name());
        nbt.func_218657_a("Item", (INBT)this.item.func_77955_b(new CompoundNBT()));
        return nbt;
    }
}

