/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.stats;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.IForgeRegistry;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;

public class StatModifierMap
implements Multimap<ItemStat, StatInstance> {
    private final Multimap<ItemStat, StatInstance> map = ArrayListMultimap.create();

    public static ITextComponent formatText(Collection<StatInstance> mods, ItemStat stat, int maxDecimalPlaces) {
        if (mods.size() == 1) {
            StatInstance inst = mods.iterator().next();
            int decimalPlaces = inst.getPreferredDecimalPlaces(stat, maxDecimalPlaces);
            return new StringTextComponent(inst.formattedString(stat, decimalPlaces, false));
        }
        StringBuilder result = new StringBuilder();
        for (StatInstance inst : mods) {
            if (result.length() > 0) {
                result.append(", ");
            }
            int decimalPlaces = inst.getPreferredDecimalPlaces(stat, maxDecimalPlaces);
            result.append(inst.formattedString(stat, decimalPlaces, false));
        }
        return new StringTextComponent(result.toString());
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public boolean containsEntry(Object key, Object value) {
        return this.map.containsEntry(key, value);
    }

    public boolean put(ItemStat key, StatInstance value) {
        return this.map.put((Object)key, (Object)value);
    }

    public boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    public boolean putAll(ItemStat key, @Nonnull Iterable<? extends StatInstance> values) {
        return this.map.putAll((Object)key, values);
    }

    public boolean putAll(@Nonnull Multimap<? extends ItemStat, ? extends StatInstance> multimap) {
        return this.map.putAll(multimap);
    }

    public Collection<StatInstance> replaceValues(ItemStat key, @Nonnull Iterable<? extends StatInstance> values) {
        return this.map.replaceValues((Object)key, values);
    }

    public Collection<StatInstance> removeAll(Object key) {
        return this.map.removeAll(key);
    }

    public void clear() {
        this.map.clear();
    }

    public Collection<StatInstance> get(ItemStat key) {
        return this.map.get((Object)key);
    }

    public Set<ItemStat> keySet() {
        return this.map.keySet();
    }

    public Multiset<ItemStat> keys() {
        return this.map.keys();
    }

    public Collection<StatInstance> values() {
        return this.map.values();
    }

    public Collection<Map.Entry<ItemStat, StatInstance>> entries() {
        return this.map.entries();
    }

    public Map<ItemStat, Collection<StatInstance>> asMap() {
        return this.map.asMap();
    }

    @Deprecated
    public static StatModifierMap read(IGearPart part, JsonElement json) {
        return StatModifierMap.read(json);
    }

    public static StatModifierMap read(JsonElement json) {
        StatModifierMap map = new StatModifierMap();
        if (json.isJsonObject()) {
            for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                ItemStat stat = ItemStats.byName((String)entry.getKey());
                if (stat == null) continue;
                JsonElement value = (JsonElement)entry.getValue();
                if (value.isJsonArray()) {
                    value.getAsJsonArray().forEach(e -> map.put(stat, StatInstance.read(stat, e)));
                    continue;
                }
                map.put(stat, StatInstance.read(stat, value));
            }
        } else if (json.isJsonArray()) {
            for (JsonElement element : json.getAsJsonArray()) {
                JsonObject jsonObj = element.getAsJsonObject();
                ItemStat stat = ItemStats.byName(JSONUtils.func_151200_h((JsonObject)jsonObj, (String)"name"));
                if (stat == null) continue;
                map.put(stat, StatInstance.read(stat, element));
            }
        } else {
            throw new JsonParseException("Expected object or array");
        }
        return map;
    }

    public static StatModifierMap read(PacketBuffer buffer) {
        StatModifierMap map = new StatModifierMap();
        int count = buffer.func_150792_a();
        for (int i = 0; i < count; ++i) {
            ItemStat stat = (ItemStat)((IForgeRegistry)ItemStats.REGISTRY.get()).getValue(buffer.func_192575_l());
            StatInstance instance = StatInstance.read(buffer);
            map.put(stat, instance);
        }
        return map;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.size());
        this.forEach((stat, instance) -> {
            buffer.func_192572_a(Objects.requireNonNull(stat.getRegistryName()));
            instance.write(buffer);
        });
    }
}

