/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.material;

import com.google.gson.JsonObject;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.parts.PartTextureType;
import net.silentchaos512.utils.Color;
import net.silentchaos512.utils.EnumUtils;

public class MaterialDisplay
implements IMaterialDisplay {
    public static final MaterialDisplay DEFAULT = new MaterialDisplay();
    private int color = 0xFFFFFF;
    private int armorColor = 0xFFFFFF;
    private PartTextureType texture = PartTextureType.HIGH_CONTRAST_WITH_HIGHLIGHT;

    @Override
    public PartTextureType getTexture() {
        return this.texture;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public int getArmorColor() {
        return this.armorColor;
    }

    public static MaterialDisplay deserialize(JsonObject json, IMaterialDisplay defaultProps) {
        MaterialDisplay props = new MaterialDisplay();
        props.color = MaterialDisplay.loadColor(json, defaultProps.getColor(), defaultProps.getColor(), "color", "normal_color");
        props.armorColor = MaterialDisplay.loadColor(json, defaultProps.getArmorColor(), props.color, "armor_color");
        props.texture = (PartTextureType)EnumUtils.byName((String)JSONUtils.func_151219_a((JsonObject)json, (String)"texture", (String)""), (Enum)props.texture);
        return props;
    }

    private static int loadColor(JsonObject json, int defaultValue, int fallback, String ... keys) {
        for (String key : keys) {
            if (!json.has(key)) continue;
            return Color.from((JsonObject)json, (String)key, (int)defaultValue).getColor();
        }
        return fallback;
    }

    public static MaterialDisplay read(PacketBuffer buffer) {
        MaterialDisplay props = new MaterialDisplay();
        props.color = buffer.func_150792_a();
        props.armorColor = buffer.func_150792_a();
        props.texture = (PartTextureType)buffer.func_179257_a(PartTextureType.class);
        return props;
    }

    public static void write(PacketBuffer buffer, MaterialDisplay props) {
        buffer.func_150787_b(props.color);
        buffer.func_150787_b(props.armorColor);
        buffer.func_179249_a((Enum)props.texture);
    }

    public String toString() {
        return "MaterialDisplay{color=" + Color.format((int)this.color) + ", armorColor=" + Color.format((int)this.armorColor) + ", texture=" + (Object)((Object)this.texture) + '}';
    }
}

