/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartPositions;
import net.silentchaos512.gear.parts.type.BowstringPart;
import net.silentchaos512.gear.parts.type.GripPart;
import net.silentchaos512.gear.parts.type.RodPart;
import net.silentchaos512.gear.parts.type.TipPart;
import net.silentchaos512.gear.util.GearData;

public interface ICoreTool
extends ICoreItem {
    public static final Set<ItemStat> RELEVANT_STATS = ImmutableSet.of((Object)((Object)ItemStats.HARVEST_LEVEL), (Object)((Object)ItemStats.HARVEST_SPEED), (Object)((Object)ItemStats.MELEE_DAMAGE), (Object)((Object)ItemStats.ATTACK_SPEED), (Object)((Object)ItemStats.DURABILITY), (Object)((Object)ItemStats.ENCHANTABILITY), (Object[])new ItemStat[]{ItemStats.RARITY});

    @Override
    default public Set<ItemStat> getRelevantStats(@Nonnull ItemStack stack) {
        return RELEVANT_STATS;
    }

    @Override
    default public boolean requiresPartOfType(PartType type) {
        return type == PartType.MAIN || type == PartType.ROD;
    }

    @Override
    default public boolean supportsPartOfType(PartType type) {
        return type != PartType.BOWSTRING;
    }

    default public int getDamageOnBlockBreak(ItemStack gear, World world, BlockState state, BlockPos pos) {
        return state.func_185904_a() != Material.field_151584_j && state.func_185887_b((IBlockReader)world, pos) > 0.0f ? 1 : 0;
    }

    default public int getDamageOnHitEntity(ItemStack gear, LivingEntity target, LivingEntity attacker) {
        return 2;
    }

    default public PartData getSecondaryPart(ItemStack stack) {
        PartData data = GearData.getSecondaryPart(stack);
        if (data != null) {
            return data;
        }
        return Objects.requireNonNull(PartData.ofNullable(PartType.MAIN.getFallbackPart()));
    }

    @Nullable
    default public PartData getRodPart(ItemStack stack) {
        for (PartData data : GearData.getConstructionParts(stack)) {
            if (!(data.getPart() instanceof RodPart)) continue;
            return data;
        }
        return null;
    }

    @Nullable
    default public PartData getGripPart(ItemStack stack) {
        for (PartData part : GearData.getConstructionParts(stack)) {
            if (!(part.getPart() instanceof GripPart)) continue;
            return part;
        }
        return null;
    }

    @Nullable
    default public PartData getTipPart(ItemStack stack) {
        for (PartData data : GearData.getConstructionParts(stack)) {
            if (!(data.getPart() instanceof TipPart)) continue;
            return data;
        }
        return null;
    }

    @Nullable
    default public PartData getBowstringPart(ItemStack stack) {
        for (PartData data : GearData.getConstructionParts(stack)) {
            if (!(data.getPart() instanceof BowstringPart)) continue;
            return data;
        }
        return null;
    }

    @Override
    default public PartData[] getRenderParts(ItemStack stack) {
        PartDataList parts = GearData.getConstructionParts(stack);
        ArrayList<PartData> list = new ArrayList<PartData>();
        for (IPartPosition position : IPartPosition.RENDER_LAYERS) {
            if (position == PartPositions.HEAD) {
                list.add(this.getPrimaryPart(stack));
                continue;
            }
            if (position == PartPositions.GUARD && this.hasSwordGuard()) {
                list.add(this.getSecondaryPart(stack));
                continue;
            }
            if (position == PartPositions.ROD) {
                list.add(this.getRodPart(stack));
                continue;
            }
            PartData part = parts.firstInPosition(position);
            if (part == null) continue;
            list.add(part);
        }
        return (PartData[])list.stream().filter(Objects::nonNull).toArray(PartData[]::new);
    }

    default public boolean hasSwordGuard() {
        return this.getGearType() == GearType.SWORD;
    }
}

