/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IIntArray;
import net.minecraft.util.INameable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.EdFurnace;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.detail.Inventories;
import wile.engineersdecor.libmc.detail.Networking;

public class EdElectricalFurnace {

    @OnlyIn(value=Dist.CLIENT)
    public static class ElectricalFurnaceGui
    extends ContainerScreen<ElectricalFurnaceContainer> {
        protected final PlayerEntity player_;

        public ElectricalFurnaceGui(ElectricalFurnaceContainer container, PlayerInventory player_inventory, ITextComponent title) {
            super((Container)container, player_inventory, title);
            this.player_ = player_inventory.field_70458_d;
        }

        public void init() {
            super.init();
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            this.renderBackground();
            super.render(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(new ResourceLocation("engineersdecor", "textures/gui/small_electrical_furnace_gui.png"));
            int x0 = (this.width - this.field_146999_f) / 2;
            int y0 = (this.height - this.field_147000_g) / 2;
            int w = this.field_146999_f;
            int h = this.field_147000_g;
            this.blit(x0, y0, 0, 0, w, h);
            if (((ElectricalFurnaceContainer)this.func_212873_a_()).field(6) != 0) {
                int hi = 13;
                int k = this.heat_px(13);
                this.blit(x0 + 61, y0 + 53 + 13 - k, 177, 13 - k, 13, k);
            }
            this.blit(x0 + 79, y0 + 30, 176, 15, 1 + this.progress_px(17), 15);
            int we = this.energy_px(32, 8);
            if (we > 0) {
                this.blit(x0 + 88, y0 + 53, 185, 30, we, 13);
            }
            switch (((ElectricalFurnaceContainer)this.func_212873_a_()).field(4)) {
                case 0: {
                    this.blit(x0 + 144, y0 + 57, 180, 57, 6, 9);
                    break;
                }
                case 1: {
                    this.blit(x0 + 142, y0 + 58, 190, 58, 9, 6);
                    break;
                }
                case 2: {
                    this.blit(x0 + 144, y0 + 56, 200, 57, 6, 9);
                    break;
                }
                case 3: {
                    this.blit(x0 + 143, y0 + 58, 210, 58, 9, 6);
                    break;
                }
            }
            RenderSystem.disableBlend();
        }

        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            ElectricalFurnaceContainer container = (ElectricalFurnaceContainer)this.func_212873_a_();
            int mx = (int)(mouseX - (double)this.getGuiLeft() + 0.5);
            int my = (int)(mouseY - (double)this.getGuiTop() + 0.5);
            if (!this.func_195359_a(136, 48, 28, 28, mouseX, mouseY)) {
                return super.mouseClicked(mouseX, mouseY, mouseButton);
            }
            if (this.func_195359_a(144, 64, 6, 10, mouseX, mouseY)) {
                container.onGuiAction("speed", 0);
            } else if (this.func_195359_a(134, 58, 10, 6, mouseX, mouseY)) {
                container.onGuiAction("speed", 1);
            } else if (this.func_195359_a(144, 48, 6, 10, mouseX, mouseY)) {
                container.onGuiAction("speed", 2);
            } else if (this.func_195359_a(150, 58, 10, 6, mouseX, mouseY)) {
                container.onGuiAction("speed", 3);
            }
            return true;
        }

        private int progress_px(int pixels) {
            int tc = ((ElectricalFurnaceContainer)this.func_212873_a_()).field(2);
            int T = ((ElectricalFurnaceContainer)this.func_212873_a_()).field(3);
            return T > 0 && tc > 0 ? tc * pixels / T : 0;
        }

        private int heat_px(int pixels) {
            int k = ((ElectricalFurnaceContainer)this.func_212873_a_()).field(0) * (pixels + 1) / 200;
            return k < pixels ? k : pixels;
        }

        private int energy_px(int maxwidth, int quantization) {
            int emax = ((ElectricalFurnaceContainer)this.func_212873_a_()).field(5);
            int k = maxwidth * ((ElectricalFurnaceContainer)this.func_212873_a_()).field(1) * 9 / 8 / ((emax > 0 ? emax : 1) + 1);
            int n = k = k >= maxwidth - 2 ? maxwidth : k;
            if (quantization > 0) {
                k = (k + quantization / 2) / quantization * quantization;
            }
            return k;
        }
    }

    public static class ElectricalFurnaceContainer
    extends Container
    implements Networking.INetworkSynchronisableContainer {
        private static final int PLAYER_INV_START_SLOTNO = 7;
        protected final PlayerEntity player_;
        protected final IInventory inventory_;
        protected final IWorldPosCallable wpc_;
        private final IIntArray fields_;
        private final IRecipeType<? extends AbstractCookingRecipe> recipe_type_;

        public int field(int index) {
            return this.fields_.func_221476_a(index);
        }

        public PlayerEntity player() {
            return this.player_;
        }

        public IInventory inventory() {
            return this.inventory_;
        }

        public World world() {
            return this.player_.field_70170_p;
        }

        public ElectricalFurnaceContainer(int cid, PlayerInventory player_inventory) {
            this(cid, player_inventory, (IInventory)new Inventory(7), IWorldPosCallable.field_221489_a, (IIntArray)new IntArray(7));
        }

        private ElectricalFurnaceContainer(int cid, PlayerInventory player_inventory, IInventory block_inventory, IWorldPosCallable wpc, IIntArray fields) {
            super(ModContent.CT_SMALL_ELECTRICAL_FURNACE, cid);
            this.player_ = player_inventory.field_70458_d;
            this.inventory_ = block_inventory;
            this.wpc_ = wpc;
            this.fields_ = fields;
            this.recipe_type_ = ElectricalFurnaceTileEntity.RECIPE_TYPE;
            this.func_75146_a(new Slot(this.inventory_, 0, 59, 28));
            this.func_75146_a(new Slot(this.inventory_, 1, 16, 52));
            this.func_75146_a(new EdFurnace.FurnaceContainer.BSlotResult(this.player_, this.inventory_, 2, 101, 28));
            this.func_75146_a(new EdFurnace.FurnaceContainer.BSlotInpFifo(this.inventory_, 3, 34, 28));
            this.func_75146_a(new EdFurnace.FurnaceContainer.BSlotInpFifo(this.inventory_, 4, 16, 28));
            this.func_75146_a(new EdFurnace.FurnaceContainer.BSlotOutFifo(this.player_, this.inventory_, 5, 126, 28));
            this.func_75146_a(new EdFurnace.FurnaceContainer.BSlotOutFifo(this.player_, this.inventory_, 6, 144, 28));
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)player_inventory, x, 8 + x * 18, 144));
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)player_inventory, x + y * 9 + 9, 8 + x * 18, 86 + y * 18));
                }
            }
            this.func_216961_a(this.fields_);
        }

        public boolean func_75145_c(PlayerEntity player) {
            return this.inventory_.func_70300_a(player);
        }

        public ItemStack func_82846_b(PlayerEntity player, int index) {
            Slot slot = this.func_75139_a(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index == 2 || index == 5 || index == 6) {
                if (!this.func_75135_a(slot_stack, 7, 43, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slot_stack, transferred);
            } else if (index == 0 || index == 3 || index == 4) {
                if (!this.func_75135_a(slot_stack, 7, 43, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index == 1) {
                if (!this.func_75135_a(slot_stack, 7, 43, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 7 && index <= 43) {
                if (ElectricalFurnaceTileEntity.canSmelt(this.world(), slot_stack) ? !this.func_75135_a(slot_stack, 0, 1, false) && !this.func_75135_a(slot_stack, 3, 4, false) && !this.func_75135_a(slot_stack, 4, 5, false) : (index >= 7 && index < 34 ? !this.func_75135_a(slot_stack, 34, 43, false) : index >= 34 && index < 43 && !this.func_75135_a(slot_stack, 7, 34, false))) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(CompoundNBT nbt) {
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String key, int value) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a(key, value);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundNBT nbt) {
        }

        @Override
        public void onClientPacketReceived(int windowId, PlayerEntity player, CompoundNBT nbt) {
            if (!(this.inventory_ instanceof ElectricalFurnaceTileEntity)) {
                return;
            }
            ElectricalFurnaceTileEntity te = (ElectricalFurnaceTileEntity)this.inventory_;
            if (nbt.func_74764_b("speed")) {
                te.speed_ = MathHelper.func_76125_a((int)nbt.func_74762_e("speed"), (int)0, (int)3);
            }
            te.func_70296_d();
        }
    }

    public static class ElectricalFurnaceTileEntity
    extends EdFurnace.FurnaceTileEntity
    implements ITickableTileEntity,
    INameable,
    IInventory,
    INamedContainerProvider,
    ISidedInventory,
    IEnergyStorage {
        public static final IRecipeType<FurnaceRecipe> RECIPE_TYPE = IRecipeType.field_222150_b;
        public static final int NUM_OF_FIELDS = 7;
        public static final int TICK_INTERVAL = 4;
        public static final int FIFO_INTERVAL = 20;
        public static final int HEAT_CAPACITY = 200;
        public static final int HEAT_INCREMENT = 20;
        public static final int MAX_ENERGY_TRANSFER = 1024;
        public static final int MAX_ENERGY_BUFFER = 32000;
        public static final int MAX_SPEED_SETTING = 3;
        public static final int NUM_OF_SLOTS = 7;
        public static final int SMELTING_INPUT_SLOT_NO = 0;
        public static final int SMELTING_AUX_SLOT_NO = 1;
        public static final int SMELTING_OUTPUT_SLOT_NO = 2;
        public static final int FIFO_INPUT_0_SLOT_NO = 3;
        public static final int FIFO_INPUT_1_SLOT_NO = 4;
        public static final int FIFO_OUTPUT_0_SLOT_NO = 5;
        public static final int FIFO_OUTPUT_1_SLOT_NO = 6;
        public static final int DEFAULT_SPEED_PERCENT = 200;
        public static final int DEFAULT_ENERGY_CONSUMPTION = 16;
        public static final int DEFAULT_SCALED_ENERGY_CONSUMPTION = 640;
        private static boolean with_automatic_inventory_pulling_ = false;
        private static int energy_consumption_ = 640;
        private static int transfer_energy_consumption_ = 80;
        private static int proc_speed_percent_ = 200;
        private static double[] speed_setting_factor_ = new double[]{0.0, 1.0, 1.5, 2.0};
        private int burntime_left_ = 0;
        private int proc_time_elapsed_ = 0;
        private int proc_time_needed_ = 0;
        private int energy_stored_ = 0;
        private int field_max_energy_stored_ = 0;
        private int field_isburning_ = 0;
        private int speed_ = 1;
        private int tick_timer_ = 0;
        private int fifo_timer_ = 0;
        private boolean enabled_ = false;
        protected final IIntArray fields = new IntArray(7){

            public int func_221476_a(int id) {
                switch (id) {
                    case 0: {
                        return burntime_left_;
                    }
                    case 1: {
                        return energy_stored_;
                    }
                    case 2: {
                        return proc_time_elapsed_;
                    }
                    case 3: {
                        return proc_time_needed_;
                    }
                    case 4: {
                        return speed_;
                    }
                    case 5: {
                        return field_max_energy_stored_;
                    }
                    case 6: {
                        return field_isburning_;
                    }
                }
                return 0;
            }

            public void func_221477_a(int id, int value) {
                switch (id) {
                    case 0: {
                        burntime_left_ = value;
                        break;
                    }
                    case 1: {
                        energy_stored_ = value;
                        break;
                    }
                    case 2: {
                        proc_time_elapsed_ = value;
                        break;
                    }
                    case 3: {
                        proc_time_needed_ = value;
                        break;
                    }
                    case 4: {
                        speed_ = value;
                        break;
                    }
                    case 5: {
                        field_max_energy_stored_ = value;
                        break;
                    }
                    case 6: {
                        field_isburning_ = value;
                    }
                }
            }
        };
        private static final int[] SIDED_INV_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6};
        protected LazyOptional<IItemHandler> item_handler_ = LazyOptional.of(() -> new BItemHandler(this));
        protected LazyOptional<IEnergyStorage> energy_handler_ = LazyOptional.of(() -> this);

        public static void on_config(int speed_percent, int standard_energy_per_tick, boolean with_automatic_inventory_pulling) {
            proc_speed_percent_ = MathHelper.func_76125_a((int)speed_percent, (int)10, (int)500);
            energy_consumption_ = MathHelper.func_76125_a((int)standard_energy_per_tick, (int)4, (int)4096) * 20 * proc_speed_percent_ / 100;
            transfer_energy_consumption_ = MathHelper.func_76125_a((int)(energy_consumption_ / 8), (int)8, (int)20);
            with_automatic_inventory_pulling_ = with_automatic_inventory_pulling;
            ModEngineersDecor.logger().info("Config electrical furnace speed:" + proc_speed_percent_ + ", power consumption:" + energy_consumption_);
        }

        public ElectricalFurnaceTileEntity() {
            this(ModContent.TET_SMALL_ELECTRICAL_FURNACE);
        }

        public ElectricalFurnaceTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        @Override
        public void reset() {
            super.reset();
            this.stacks_ = NonNullList.func_191197_a((int)7, (Object)ItemStack.field_190927_a);
            this.burntime_left_ = 0;
            this.proc_time_elapsed_ = 0;
            this.proc_time_needed_ = 0;
            this.fifo_timer_ = 0;
            this.tick_timer_ = 0;
            this.energy_stored_ = 0;
            this.speed_ = 1;
            this.field_max_energy_stored_ = this.getMaxEnergyStored();
            this.field_isburning_ = 0;
        }

        @Override
        public void readnbt(CompoundNBT nbt) {
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, (NonNullList)this.stacks_);
            while (this.stacks_.size() < 7) {
                this.stacks_.add((Object)ItemStack.field_190927_a);
            }
            this.burntime_left_ = nbt.func_74762_e("BurnTime");
            this.proc_time_elapsed_ = nbt.func_74762_e("CookTime");
            this.proc_time_needed_ = nbt.func_74762_e("CookTimeTotal");
            this.energy_stored_ = nbt.func_74762_e("Energy");
            this.speed_ = nbt.func_74762_e("SpeedSetting");
            this.speed_ = this.speed_ < 0 ? 1 : (this.speed_ > 3 ? 3 : this.speed_);
        }

        protected void writenbt(CompoundNBT nbt) {
            nbt.func_74768_a("BurnTime", MathHelper.func_76125_a((int)this.burntime_left_, (int)0, (int)200));
            nbt.func_74768_a("CookTime", MathHelper.func_76125_a((int)this.proc_time_elapsed_, (int)0, (int)Short.MAX_VALUE));
            nbt.func_74768_a("CookTimeTotal", MathHelper.func_76125_a((int)this.proc_time_needed_, (int)0, (int)Short.MAX_VALUE));
            nbt.func_74768_a("Energy", MathHelper.func_76125_a((int)this.energy_stored_, (int)0, (int)32000));
            nbt.func_74768_a("SpeedSetting", MathHelper.func_76125_a((int)this.speed_, (int)-1, (int)3));
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, (NonNullList)this.stacks_);
        }

        @Override
        public int getComparatorOutput() {
            return this.energy_stored_ <= 0 ? 0 : (((ItemStack)this.stacks_.get(4)).func_190926_b() ? 0 : 5) + (((ItemStack)this.stacks_.get(3)).func_190926_b() ? 0 : 5) + (((ItemStack)this.stacks_.get(0)).func_190926_b() ? 0 : 5);
        }

        @Override
        public void func_145839_a(CompoundNBT nbt) {
            super.func_145839_a(nbt);
            this.readnbt(nbt);
        }

        @Override
        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        @Override
        public void func_145843_s() {
            super.func_145843_s();
            Arrays.stream(this.item_handlers).forEach(LazyOptional::invalidate);
            this.item_handler_.invalidate();
            this.energy_handler_.invalidate();
        }

        @Override
        public ITextComponent func_200200_C_() {
            Block block = this.func_195044_w().func_177230_c();
            return new StringTextComponent(block != null ? block.func_149739_a() : "Small electrical furnace");
        }

        @Override
        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
            return new ElectricalFurnaceContainer(id, inventory, this, IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.fields);
        }

        @Override
        public boolean func_94041_b(int index, ItemStack stack) {
            switch (index) {
                case 0: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public ItemStack func_70301_a(int index) {
            return index < 0 || index >= SIDED_INV_SLOTS.length ? ItemStack.field_190927_a : (ItemStack)this.stacks_.get(SIDED_INV_SLOTS[index]);
        }

        @Override
        public int[] func_180463_a(Direction side) {
            return SIDED_INV_SLOTS;
        }

        @Override
        public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
            return (index == 3 || index == 4) && this.func_94041_b(index, itemStackIn);
        }

        @Override
        public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
            return index == 5 || index == 6;
        }

        @Override
        public boolean canExtract() {
            return false;
        }

        @Override
        public boolean canReceive() {
            return true;
        }

        @Override
        public int getMaxEnergyStored() {
            return 32000;
        }

        @Override
        public int getEnergyStored() {
            return this.energy_stored_;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.energy_stored_ >= 32000) {
                return 0;
            }
            int n = Math.min(maxReceive, 32000 - this.energy_stored_);
            if (n > 1024) {
                n = 1024;
            }
            if (!simulate) {
                this.energy_stored_ += n;
                this.func_70296_d();
            }
            return n;
        }

        @Override
        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.item_handler_.cast();
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        @Override
        public void func_73660_a() {
            boolean update_blockstate;
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 4;
            boolean was_burning = this.burning();
            if (was_burning) {
                this.burntime_left_ -= 4;
            }
            if (this.burntime_left_ < 0) {
                this.burntime_left_ = 0;
            }
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            boolean dirty = update_blockstate = was_burning != this.burning();
            boolean shift_in = false;
            boolean shift_out = false;
            if (--this.fifo_timer_ <= 0) {
                this.fifo_timer_ = 5;
                if (this.transferItems(5, 6, 64)) {
                    dirty = true;
                } else {
                    shift_out = true;
                }
                if (this.transferItems(2, 5, 64)) {
                    dirty = true;
                }
                if (this.transferItems(3, 0, 64)) {
                    dirty = true;
                }
                if (this.transferItems(4, 3, 64)) {
                    dirty = true;
                } else {
                    shift_in = true;
                }
            }
            if (this.energy_stored_ < this.energy_consumption()) {
                this.enabled_ = false;
            } else if (this.energy_stored_ >= 16000) {
                this.enabled_ = true;
            }
            if (!((ItemStack)this.stacks_.get(0)).func_190926_b() && this.enabled_ && this.speed_ > 0 && this.speed_ <= 3) {
                boolean can_smelt;
                IRecipe last_recipe = this.currentRecipe();
                this.updateCurrentRecipe();
                if (this.currentRecipe() != last_recipe) {
                    this.proc_time_elapsed_ = 0;
                    this.proc_time_needed_ = this.getSmeltingTimeNeeded(this.field_145850_b, (ItemStack)this.stacks_.get(0));
                }
                if (!(can_smelt = this.canSmeltCurrentItem()) && this.getSmeltingResult((ItemStack)this.stacks_.get(0)).func_190926_b()) {
                    if (this.transferItems(0, 2, 1)) {
                        dirty = true;
                    }
                } else {
                    if (!this.burning() && can_smelt && this.heat_up()) {
                        dirty = true;
                        update_blockstate = true;
                    }
                    if (this.burning() && can_smelt) {
                        if (this.heat_up()) {
                            dirty = true;
                        }
                        this.proc_time_elapsed_ += (int)((double)(4 * proc_speed_percent_) * speed_setting_factor_[this.speed_] / 100.0);
                        if (this.proc_time_elapsed_ >= this.proc_time_needed_) {
                            this.proc_time_elapsed_ = 0;
                            this.proc_time_needed_ = this.getSmeltingTimeNeeded(this.field_145850_b, (ItemStack)this.stacks_.get(0));
                            this.smeltCurrentItem();
                            dirty = true;
                            shift_out = true;
                        }
                    } else {
                        this.proc_time_elapsed_ = 0;
                    }
                }
            } else if (this.proc_time_elapsed_ > 0) {
                this.proc_time_elapsed_ -= ((ItemStack)this.stacks_.get(0)).func_190926_b() ? 20 : 1;
                if (this.proc_time_elapsed_ < 0) {
                    this.proc_time_elapsed_ = 0;
                    shift_out = true;
                    update_blockstate = true;
                }
            }
            if (update_blockstate) {
                dirty = true;
                this.sync_blockstate();
            }
            if (this.adjacent_inventory_shift(shift_in, shift_out)) {
                dirty = true;
            }
            if (dirty) {
                this.func_70296_d();
            }
            this.field_max_energy_stored_ = this.getMaxEnergyStored();
            this.field_isburning_ = this.burning() ? 1 : 0;
        }

        @Override
        protected void updateCurrentRecipe() {
            this.setCurrentRecipe((IRecipe<?>)ElectricalFurnaceTileEntity.getSmeltingResult(RECIPE_TYPE, this.field_145850_b, (ItemStack)this.stacks_.get(0)));
        }

        @Override
        public boolean burning() {
            return this.burntime_left_ > 0;
        }

        private boolean is_accepted_hopper(ItemStack stack) {
            return stack.func_77973_b() == Blocks.field_150438_bZ.func_199767_j() || stack.func_77973_b() == ModContent.FACTORY_HOPPER.func_199767_j();
        }

        private boolean transferItems(int index_from, int index_to, int count) {
            ItemStack from = (ItemStack)this.stacks_.get(index_from);
            if (from.func_190926_b()) {
                return false;
            }
            ItemStack to = (ItemStack)this.stacks_.get(index_to);
            if (from.func_190916_E() < count) {
                count = from.func_190916_E();
            }
            if (count <= 0) {
                return false;
            }
            boolean changed = true;
            if (to.func_190926_b()) {
                this.stacks_.set(index_to, (Object)from.func_77979_a(count));
            } else if (to.func_190916_E() >= to.func_77976_d()) {
                changed = false;
            } else if (Inventories.areItemStacksDifferent(from, to)) {
                changed = false;
            } else if (to.func_190916_E() + count >= to.func_77976_d()) {
                from.func_190918_g(to.func_77976_d() - to.func_190916_E());
                to.func_190920_e(to.func_77976_d());
            } else {
                from.func_190918_g(count);
                to.func_190917_f(count);
            }
            if (from.func_190926_b() && from != ItemStack.field_190927_a) {
                this.stacks_.set(index_from, (Object)ItemStack.field_190927_a);
                changed = true;
            }
            return changed;
        }

        private boolean adjacent_inventory_shift(boolean inp, boolean out) {
            IItemHandler hnd;
            TileEntity te;
            boolean dirty = false;
            if (this.energy_stored_ < transfer_energy_consumption_) {
                return false;
            }
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof ElectricalFurnaceBlock)) {
                return false;
            }
            Direction out_facing = (Direction)state.func_177229_b((IProperty)ElectricalFurnaceBlock.HORIZONTAL_FACING);
            if (out && !((ItemStack)this.stacks_.get(6)).func_190926_b() && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(out_facing))) != null && (hnd = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, out_facing).orElse(null)) != null) {
                ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)hnd, (ItemStack)((ItemStack)this.stacks_.get(6)).func_77946_l(), (boolean)false);
                this.stacks_.set(6, (Object)remaining);
                this.energy_stored_ -= transfer_energy_consumption_;
                dirty = true;
            }
            if (with_automatic_inventory_pulling_ || this.is_accepted_hopper((ItemStack)this.stacks_.get(1))) {
                IItemHandler hnd2;
                TileEntity te2;
                Direction inp_facing = ((Direction)state.func_177229_b((IProperty)ElectricalFurnaceBlock.HORIZONTAL_FACING)).func_176734_d();
                if (inp && ((ItemStack)this.stacks_.get(4)).func_190926_b() && (te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(inp_facing))) != null && (hnd2 = (IItemHandler)te2.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inp_facing).orElse(null)) != null) {
                    for (int i = 0; i < hnd2.getSlots(); ++i) {
                        ItemStack adj_stack = hnd2.getStackInSlot(i);
                        if (adj_stack.func_190926_b()) continue;
                        ItemStack my_stack = adj_stack.func_77946_l();
                        if (my_stack.func_190916_E() > this.func_70297_j_()) {
                            my_stack.func_190920_e(this.func_70297_j_());
                        }
                        adj_stack.func_190918_g(my_stack.func_190916_E());
                        this.stacks_.set(4, (Object)my_stack);
                        this.energy_stored_ -= transfer_energy_consumption_;
                        dirty = true;
                        break;
                    }
                }
            }
            return dirty;
        }

        int energy_consumption() {
            switch (this.speed_) {
                case 1: {
                    return energy_consumption_;
                }
                case 2: {
                    return energy_consumption_ * 2;
                }
                case 3: {
                    return energy_consumption_ * 4;
                }
            }
            return 0;
        }

        private boolean heat_up() {
            int p = this.energy_consumption();
            if (p <= 0 || this.energy_stored_ < p) {
                return false;
            }
            if (this.burntime_left_ >= 180) {
                return false;
            }
            this.energy_stored_ -= p;
            this.burntime_left_ += 20;
            this.func_70296_d();
            return true;
        }

        private void sync_blockstate() {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() instanceof ElectricalFurnaceBlock && ((Boolean)state.func_177229_b((IProperty)ElectricalFurnaceBlock.LIT)).booleanValue() != this.burning()) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((IProperty)ElectricalFurnaceBlock.LIT, (Comparable)Boolean.valueOf(this.burning())), 2);
            }
        }

        protected static class BItemHandler
        implements IItemHandler {
            private ElectricalFurnaceTileEntity te;

            BItemHandler(ElectricalFurnaceTileEntity te) {
                this.te = te;
            }

            public int getSlots() {
                return SIDED_INV_SLOTS.length;
            }

            @Nonnull
            public ItemStack getStackInSlot(int index) {
                return this.te.func_70301_a(index);
            }

            public int getSlotLimit(int index) {
                return this.te.func_70297_j_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            @Nonnull
            public ItemStack insertItem(int index, @Nonnull ItemStack stack, boolean simulate) {
                if (stack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                if (index < 0 || index >= SIDED_INV_SLOTS.length) {
                    return ItemStack.field_190927_a;
                }
                int slotno = SIDED_INV_SLOTS[index];
                ItemStack slotstack = this.getStackInSlot(slotno);
                if (!slotstack.func_190926_b()) {
                    if (slotstack.func_190916_E() >= Math.min(slotstack.func_77976_d(), this.getSlotLimit(index))) {
                        return stack;
                    }
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)slotstack)) {
                        return stack;
                    }
                    if (!this.te.func_180462_a(slotno, stack, Direction.UP) || !this.te.func_94041_b(slotno, stack)) {
                        return stack;
                    }
                    int n = Math.min(stack.func_77976_d(), this.getSlotLimit(index)) - slotstack.func_190916_E();
                    if (stack.func_190916_E() <= n) {
                        if (!simulate) {
                            ItemStack copy = stack.func_77946_l();
                            copy.func_190917_f(slotstack.func_190916_E());
                            this.te.func_70299_a(slotno, copy);
                        }
                        return ItemStack.field_190927_a;
                    }
                    stack = stack.func_77946_l();
                    if (!simulate) {
                        ItemStack copy = stack.func_77979_a(n);
                        copy.func_190917_f(slotstack.func_190916_E());
                        this.te.func_70299_a(slotno, copy);
                        return stack;
                    }
                    stack.func_190918_g(n);
                    return stack;
                }
                if (!this.te.func_180462_a(slotno, stack, Direction.UP) || !this.te.func_94041_b(slotno, stack)) {
                    return stack;
                }
                int n = Math.min(stack.func_77976_d(), this.getSlotLimit(index));
                if (n < stack.func_190916_E()) {
                    stack = stack.func_77946_l();
                    if (!simulate) {
                        this.te.func_70299_a(slotno, stack.func_77979_a(n));
                        return stack;
                    }
                    stack.func_190918_g(n);
                    return stack;
                }
                if (!simulate) {
                    this.te.func_70299_a(slotno, stack);
                }
                return ItemStack.field_190927_a;
            }

            @Nonnull
            public ItemStack extractItem(int index, int amount, boolean simulate) {
                if (amount == 0) {
                    return ItemStack.field_190927_a;
                }
                if (index < 0 || index >= SIDED_INV_SLOTS.length) {
                    return ItemStack.field_190927_a;
                }
                int slotno = SIDED_INV_SLOTS[index];
                ItemStack stackInSlot = this.getStackInSlot(slotno);
                if (stackInSlot.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                if (!this.te.func_180461_b(slotno, stackInSlot, Direction.DOWN)) {
                    return ItemStack.field_190927_a;
                }
                if (simulate) {
                    if (stackInSlot.func_190916_E() < amount) {
                        return stackInSlot.func_77946_l();
                    }
                    ItemStack ostack = stackInSlot.func_77946_l();
                    ostack.func_190920_e(amount);
                    return ostack;
                }
                ItemStack ostack = this.te.func_70298_a(slotno, Math.min(stackInSlot.func_190916_E(), amount));
                this.te.func_70296_d();
                return ostack;
            }
        }
    }

    public static class ElectricalFurnaceBlock
    extends EdFurnace.FurnaceBlock
    implements IDecorBlock {
        public ElectricalFurnaceBlock(long config, Block.Properties builder, AxisAlignedBB[] unrotatedAABBs) {
            super(config, builder, unrotatedAABBs);
        }

        @Override
        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new ElectricalFurnaceTileEntity();
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof ElectricalFurnaceTileEntity)) {
                return ActionResultType.FAIL;
            }
            if (!(player instanceof ServerPlayerEntity) && !(player instanceof FakePlayer)) {
                return ActionResultType.FAIL;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te));
            player.func_195066_a(Stats.field_188061_aa);
            return ActionResultType.SUCCESS;
        }

        @Override
        public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
            if (world.field_72995_K) {
                return;
            }
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("inventory")) {
                return;
            }
            CompoundNBT inventory_nbt = stack.func_77978_p().func_74775_l("inventory");
            if (inventory_nbt.isEmpty()) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof ElectricalFurnaceTileEntity)) {
                return;
            }
            ElectricalFurnaceTileEntity bte = (ElectricalFurnaceTileEntity)te;
            bte.readnbt(inventory_nbt);
            bte.func_70296_d();
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(bte.burning())));
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void func_180655_c(BlockState state, World world, BlockPos pos, Random rnd) {
        }
    }
}

