/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.shapes;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mcjty.lib.varia.RLE;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.modules.scanner.ScannerConfiguration;
import mcjty.rftoolsbuilder.modules.scanner.network.PacketReturnShapeData;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import mcjty.rftoolsbuilder.shapes.IFormula;
import mcjty.rftoolsbuilder.shapes.ShapeID;
import mcjty.rftoolsbuilder.shapes.StatePalette;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;

public class ShapeDataManagerServer {
    private static final Map<ShapeID, WorkQueue> workQueues = new HashMap<ShapeID, WorkQueue>();

    public static void pushWork(ShapeID shapeID, ItemStack stack, int offsetY, IFormula formula, ServerPlayerEntity player) {
        WorkQueue queue = workQueues.get(shapeID);
        if (queue == null) {
            queue = new WorkQueue();
            workQueues.put(shapeID, queue);
        }
        if (queue.workingOn.containsKey(offsetY)) {
            ((WorkUnit)queue.workingOn.get(offsetY)).update(stack, offsetY, formula, player);
        } else {
            WorkUnit unit = new WorkUnit(stack, offsetY, formula, player);
            queue.workQueue.addLast(unit);
            queue.workingOn.put(offsetY, unit);
        }
    }

    public static void handleWork() {
        HashSet<ShapeID> toRemove = new HashSet<ShapeID>();
        for (Map.Entry<ShapeID, WorkQueue> entry : workQueues.entrySet()) {
            ShapeID shapeID = entry.getKey();
            WorkQueue queue = entry.getValue();
            int pertick = (Integer)ScannerConfiguration.planeSurfacePerTick.get();
            while (!queue.workQueue.isEmpty()) {
                WorkUnit unit = (WorkUnit)queue.workQueue.removeFirst();
                queue.workingOn.remove(unit.getOffsetY());
                ItemStack card = unit.getStack();
                boolean solid = ShapeCardItem.isSolid(card);
                BlockPos dimension = ShapeCardItem.getDimension(card);
                RLE positions = new RLE();
                StatePalette statePalette = new StatePalette();
                int cnt = ShapeCardItem.getRenderPositions(card, solid, positions, statePalette, unit.getFormula(), unit.getOffsetY());
                for (ServerPlayerEntity player : unit.getPlayers()) {
                    RFToolsBuilderMessages.INSTANCE.sendTo((Object)new PacketReturnShapeData(shapeID, positions, statePalette, dimension, cnt, unit.getOffsetY(), ""), player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                }
                if (cnt <= 0 || (pertick -= dimension.func_177958_n() * dimension.func_177952_p()) > 0) continue;
                break;
            }
            if (!queue.workQueue.isEmpty()) continue;
            toRemove.add(shapeID);
        }
        for (ShapeID id : toRemove) {
            workQueues.remove(id);
        }
    }

    private static class WorkQueue {
        private final ArrayDeque<WorkUnit> workQueue = new ArrayDeque();
        private final Map<Integer, WorkUnit> workingOn = new HashMap<Integer, WorkUnit>();

        private WorkQueue() {
        }
    }

    private static class WorkUnit {
        private final List<ServerPlayerEntity> players = new ArrayList<ServerPlayerEntity>();
        private ItemStack stack;
        private int offsetY;
        private IFormula formula;

        public WorkUnit(ItemStack stack, int offsetY, IFormula formula, ServerPlayerEntity player) {
            this.stack = stack;
            this.offsetY = offsetY;
            this.formula = formula;
            this.players.add(player);
        }

        public void update(ItemStack stack, int offsetY, IFormula formula, ServerPlayerEntity player) {
            this.stack = stack;
            this.offsetY = offsetY;
            this.formula = formula;
            if (!this.players.contains(player)) {
                this.players.add(player);
            }
        }

        public List<ServerPlayerEntity> getPlayers() {
            return this.players;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public int getOffsetY() {
            return this.offsetY;
        }

        public IFormula getFormula() {
            return this.formula;
        }
    }
}

