/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.blocks;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.module.CapabilityModuleSupport;
import mcjty.lib.api.module.DefaultModuleSupport;
import mcjty.lib.api.module.IModuleSupport;
import mcjty.lib.bindings.DefaultAction;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IAction;
import mcjty.lib.bindings.IValue;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Broadcaster;
import mcjty.lib.varia.Cached;
import mcjty.lib.varia.FluidTools;
import mcjty.lib.varia.InventoryTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.RedstoneMode;
import mcjty.lib.varia.SoundTools;
import mcjty.lib.varia.TeleportationTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsbase.api.client.IHudSupport;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolsbase.modules.hud.network.PacketGetHudLog;
import mcjty.rftoolsbuilder.modules.builder.BlockInformation;
import mcjty.rftoolsbuilder.modules.builder.BuilderConfiguration;
import mcjty.rftoolsbuilder.modules.builder.BuilderSetup;
import mcjty.rftoolsbuilder.modules.builder.BuilderTileEntityMode;
import mcjty.rftoolsbuilder.modules.builder.SpaceChamberRepository;
import mcjty.rftoolsbuilder.modules.builder.blocks.LazyList;
import mcjty.rftoolsbuilder.modules.builder.blocks.SupportBlock;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardType;
import mcjty.rftoolsbuilder.setup.ClientCommandHandler;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import mcjty.rftoolsbuilder.shapes.Shape;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public class BuilderTileEntity
extends GenericTileEntity
implements ITickableTileEntity,
IHudSupport {
    public static final String CMD_SETMODE = "builder.setMode";
    public static final String CMD_SETROTATE = "builder.setRotate";
    public static final String CMD_SETANCHOR = "builder.setAnchor";
    public static final Key<Integer> PARAM_ANCHOR_INDEX = new Key("anchorIndex", Type.INTEGER);
    public static final int SLOT_TAB = 0;
    public static final int SLOT_FILTER = 1;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(2).slot(SlotDefinition.specific(s -> s.func_77973_b() instanceof ShapeCardItem), "container", 0, 100, 10).slot(SlotDefinition.specific(s -> s.func_77973_b() instanceof FilterModuleItem), "container", 1, 84, 46).playerSlots(10, 70));
    public static final int MODE_COPY = 0;
    public static final int MODE_MOVE = 1;
    public static final int MODE_SWAP = 2;
    public static final int MODE_BACK = 3;
    public static final int MODE_COLLECT = 4;
    public static final String[] MODES = new String[]{"Copy", "Move", "Swap", "Back", "Collect"};
    public static final String ROTATE_0 = "0";
    public static final String ROTATE_90 = "90";
    public static final String ROTATE_180 = "180";
    public static final String ROTATE_270 = "270";
    public static final int ANCHOR_SW = 0;
    public static final int ANCHOR_SE = 1;
    public static final int ANCHOR_NW = 2;
    public static final int ANCHOR_NE = 3;
    private String lastError = null;
    private int mode = 0;
    private int rotate = 0;
    private int anchor = 0;
    private boolean silent = false;
    private boolean supportMode = false;
    private boolean entityMode = false;
    private boolean loopMode = false;
    private boolean waitMode = true;
    private boolean hilightMode = false;
    private static int currentLevel = 0;
    private int scanLocCnt = 0;
    private static Map<BlockPos, Pair<Long, BlockPos>> scanLocClient = new HashMap<BlockPos, Pair<Long, BlockPos>>();
    private int collectCounter = (Integer)BuilderConfiguration.collectTimer.get();
    private int collectXP = 0;
    private boolean boxValid = false;
    private BlockPos minBox = null;
    private BlockPos maxBox = null;
    private BlockPos scan = null;
    private int projDx;
    private int projDy;
    private int projDz;
    private long lastHudTime = 0L;
    private List<String> clientHudLog = new ArrayList<String>();
    private ShapeCardType cardType = ShapeCardType.CARD_UNKNOWN;
    private static ItemStack TOOL_NORMAL;
    private static ItemStack TOOL_SILK;
    private static ItemStack TOOL_FORTUNE;
    private final Cached<Predicate<ItemStack>> filterCache = Cached.of(this::createFilterCache);
    private ChunkPos forcedChunk = null;
    private Map<BlockPos, BlockState> cachedBlocks = null;
    private ChunkPos cachedChunk = null;
    private final Cached<Set<Block>> cachedVoidableBlocks = Cached.of(this::getCachedVoidableBlocks);
    private LazyList<ItemStack> overflowItems = new LazyList();
    private final Lazy<FakePlayer> harvester = Lazy.of(this::getHarvester);
    private final NoDirectionItemHander items = this.createItemHandler();
    private final LazyOptional<NoDirectionItemHander> itemHandler = LazyOptional.of(() -> this.items);
    private final LazyOptional<AutomationFilterItemHander> automationItemHandler = LazyOptional.of(() -> new AutomationFilterItemHander(this.items));
    private final LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)BuilderConfiguration.BUILDER_MAXENERGY.get()).intValue(), (long)((Integer)BuilderConfiguration.BUILDER_RECEIVEPERTICK.get()).intValue()));
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Builder").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)BuilderSetup.CONTAINER_BUILDER.get(), windowId.intValue(), (ContainerFactory)CONTAINER_FACTORY.get(), this.func_174877_v(), (GenericTileEntity)this)).itemHandler(this.itemHandler).energyHandler(this.energyHandler).shortListener(new IntReferenceHolder(){

        public int func_221495_b() {
            return BuilderTileEntity.this.scan == null ? -1 : BuilderTileEntity.this.scan.func_177956_o();
        }

        public void func_221494_a(int val) {
            currentLevel = val;
        }
    }));
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((TileEntity)this));
    private final LazyOptional<IModuleSupport> moduleSupportHandler = LazyOptional.of(() -> new DefaultModuleSupport(0){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.func_77973_b() instanceof ShapeCardItem || itemStack.func_77973_b() == BuilderSetup.SPACE_CHAMBER_CARD;
        }
    });
    public static final Key<Boolean> VALUE_WAIT;
    public static final Key<Boolean> VALUE_LOOP;
    public static final Key<Boolean> VALUE_HILIGHT;
    public static final Key<Boolean> VALUE_SUPPORT;
    public static final Key<Boolean> VALUE_SILENT;
    public static final Key<Boolean> VALUE_ENTITIES;
    private static Random random;
    private LazyList<ItemStack> couldntHandle1 = new LazyList();
    private LazyList<ItemStack> couldntHandle2 = new LazyList();
    private static long lastTime;

    public BuilderTileEntity() {
        super((TileEntityType)BuilderSetup.TYPE_BUILDER.get());
        this.setRSMode(RedstoneMode.REDSTONE_ONREQUIRED);
    }

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_RSMODE, () -> ((BuilderTileEntity)this).getRSModeInt(), arg_0 -> ((BuilderTileEntity)this).setRSModeInt(arg_0)), new DefaultValue(VALUE_WAIT, this::isWaitMode, this::setWaitMode), new DefaultValue(VALUE_LOOP, this::hasLoopMode, this::setLoopMode), new DefaultValue(VALUE_HILIGHT, this::isHilightMode, this::setHilightMode), new DefaultValue(VALUE_SUPPORT, this::hasSupportMode, this::setSupportMode), new DefaultValue(VALUE_SILENT, this::isSilent, this::setSilent), new DefaultValue(VALUE_ENTITIES, this::hasEntityMode, this::setEntityMode)};
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(BuilderTileEntity::new).infusable().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            public RotationType getRotationType() {
                return RotationType.HORIZROTATION;
            }
        };
    }

    public IAction[] getActions() {
        return new IAction[]{new DefaultAction("restart", this::restartScan)};
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    private FakePlayer getHarvester() {
        FakePlayer player = FakePlayerFactory.get((ServerWorld)((ServerWorld)this.field_145850_b), (GameProfile)new GameProfile(UUID.nameUUIDFromBytes("rftools_builder".getBytes()), "rftools_builder"));
        player.func_70029_a(this.field_145850_b);
        player.func_70107_b((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
        return player;
    }

    public Direction getBlockOrientation() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == BuilderSetup.BUILDER.get()) {
            return OrientationTools.getOrientationHoriz((BlockState)state);
        }
        return null;
    }

    public boolean isBlockAboveAir() {
        return this.field_145850_b.func_175623_d(this.field_174879_c.func_177984_a());
    }

    public List<String> getClientLog() {
        return this.clientHudLog;
    }

    public List<String> getHudLog() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TextFormatting.BLUE + "Mode:");
        if (this.isShapeCard()) {
            this.getCardType().addHudLog(list, (IItemHandler)this.items);
        } else {
            list.add("    Space card: " + (new String[]{"copy", "move", "swap", "back", "collect"})[this.mode]);
        }
        if (this.scan != null) {
            list.add(TextFormatting.BLUE + "Progress:");
            list.add("    Y level: " + this.scan.func_177956_o());
            int minChunkX = this.minBox.func_177958_n() >> 4;
            int minChunkZ = this.minBox.func_177952_p() >> 4;
            int maxChunkX = this.maxBox.func_177958_n() >> 4;
            int maxChunkZ = this.maxBox.func_177952_p() >> 4;
            int curX = this.scan.func_177958_n() >> 4;
            int curZ = this.scan.func_177952_p() >> 4;
            int totChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
            int curChunk = (curZ - minChunkZ) * (maxChunkX - minChunkX) + curX - minChunkX;
            list.add("    Chunk:  " + curChunk + " of " + totChunks);
        }
        if (this.lastError != null && !this.lastError.isEmpty()) {
            String[] errors;
            for (String error : errors = StringUtils.split((String)this.lastError, (String)"\n")) {
                list.add(TextFormatting.RED + error);
            }
        }
        return list;
    }

    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }

    public long getLastUpdateTime() {
        return this.lastHudTime;
    }

    public void setLastUpdateTime(long t) {
        this.lastHudTime = t;
    }

    private boolean isShapeCard() {
        return this.items.getStackInSlot(0).func_77973_b() instanceof ShapeCardItem;
    }

    private CompoundNBT hasCard() {
        return this.items.getStackInSlot(0).func_77978_p();
    }

    private void makeSupportBlocksShaped() {
        ItemStack shapeCard = this.items.getStackInSlot(0);
        BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, (int)((Integer)BuilderConfiguration.maxBuilderDimension.get()));
        BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, (int)((Integer)BuilderConfiguration.maxBuilderOffset.get()));
        Shape shape = ShapeCardItem.getShape(shapeCard);
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        ShapeCardItem.composeFormula(shapeCard, shape.getFormulaFactory().get(), this.field_145850_b, this.func_174877_v(), dimension, offset, blocks, (Integer)BuilderConfiguration.maxBuilderDimension.get() * 256 * (Integer)BuilderConfiguration.maxBuilderDimension.get(), false, false, null);
        BlockState state = (BlockState)((SupportBlock)BuilderSetup.SUPPORT.get()).func_176223_P().func_206870_a((IProperty)SupportBlock.STATUS, (Comparable)Integer.valueOf(0));
        for (Map.Entry entry : blocks.entrySet()) {
            BlockPos p = (BlockPos)entry.getKey();
            if (!this.field_145850_b.func_175623_d(p)) continue;
            this.field_145850_b.func_180501_a(p, state, 2);
        }
    }

    private void makeSupportBlocks() {
        if (this.isShapeCard()) {
            this.makeSupportBlocksShaped();
            return;
        }
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel != null) {
            DimensionType dimension = chamberChannel.getDimension();
            ServerWorld world = WorldTools.getWorld((World)this.field_145850_b, (DimensionType)dimension);
            if (world == null) {
                return;
            }
            BlockPos.Mutable src = new BlockPos.Mutable();
            BlockPos.Mutable dest = new BlockPos.Mutable();
            for (int x = this.minBox.func_177958_n(); x <= this.maxBox.func_177958_n(); ++x) {
                for (int y = this.minBox.func_177956_o(); y <= this.maxBox.func_177956_o(); ++y) {
                    for (int z = this.minBox.func_177952_p(); z <= this.maxBox.func_177952_p(); ++z) {
                        src.func_181079_c(x, y, z);
                        this.sourceToDest((BlockPos)src, dest);
                        BlockState srcState = world.func_180495_p((BlockPos)src);
                        Block srcBlock = srcState.func_177230_c();
                        BlockState dstState = world.func_180495_p((BlockPos)dest);
                        Block dstBlock = dstState.func_177230_c();
                        int error = 0;
                        if (this.mode != 0) {
                            TileEntity srcTileEntity = world.func_175625_s((BlockPos)src);
                            TileEntity dstTileEntity = world.func_175625_s((BlockPos)dest);
                            int error1 = this.isMovable((World)world, (BlockPos)src, srcBlock, srcTileEntity);
                            int error2 = this.isMovable((World)world, (BlockPos)dest, dstBlock, dstTileEntity);
                            error = Math.max(error1, error2);
                        }
                        if (BuilderTileEntity.isEmpty(srcState, srcBlock) && !BuilderTileEntity.isEmpty(dstState, dstBlock)) {
                            world.func_180501_a((BlockPos)src, (BlockState)((SupportBlock)BuilderSetup.SUPPORT.get()).func_176223_P().func_206870_a((IProperty)SupportBlock.STATUS, (Comparable)Integer.valueOf(error)), 3);
                        }
                        if (!BuilderTileEntity.isEmpty(dstState, dstBlock) || BuilderTileEntity.isEmpty(srcState, srcBlock)) continue;
                        world.func_180501_a((BlockPos)dest, (BlockState)((SupportBlock)BuilderSetup.SUPPORT.get()).func_176223_P().func_206870_a((IProperty)SupportBlock.STATUS, (Comparable)Integer.valueOf(error)), 3);
                    }
                }
            }
        }
    }

    private void clearSupportBlocksShaped() {
        ItemStack shapeCard = this.items.getStackInSlot(0);
        BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, (int)((Integer)BuilderConfiguration.maxBuilderDimension.get()));
        BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, (int)((Integer)BuilderConfiguration.maxBuilderOffset.get()));
        Shape shape = ShapeCardItem.getShape(shapeCard);
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        ShapeCardItem.composeFormula(shapeCard, shape.getFormulaFactory().get(), this.field_145850_b, this.func_174877_v(), dimension, offset, blocks, (Integer)BuilderConfiguration.maxSpaceChamberDimension.get() * (Integer)BuilderConfiguration.maxSpaceChamberDimension.get() * (Integer)BuilderConfiguration.maxSpaceChamberDimension.get(), false, false, null);
        for (Map.Entry entry : blocks.entrySet()) {
            BlockPos p = (BlockPos)entry.getKey();
            if (this.field_145850_b.func_180495_p(p).func_177230_c() != BuilderSetup.SUPPORT.get()) continue;
            this.field_145850_b.func_175656_a(p, Blocks.field_150350_a.func_176223_P());
        }
    }

    public void clearSupportBlocks() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isShapeCard()) {
            this.clearSupportBlocksShaped();
            return;
        }
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel != null) {
            DimensionType dimension = chamberChannel.getDimension();
            ServerWorld world = WorldTools.getWorld((World)this.field_145850_b, (DimensionType)dimension);
            BlockPos.Mutable src = new BlockPos.Mutable();
            BlockPos.Mutable dest = new BlockPos.Mutable();
            for (int x = this.minBox.func_177958_n(); x <= this.maxBox.func_177958_n(); ++x) {
                for (int y = this.minBox.func_177956_o(); y <= this.maxBox.func_177956_o(); ++y) {
                    for (int z = this.minBox.func_177952_p(); z <= this.maxBox.func_177952_p(); ++z) {
                        Block srcBlock;
                        src.func_181079_c(x, y, z);
                        if (world != null && (srcBlock = world.func_180495_p((BlockPos)src).func_177230_c()) == BuilderSetup.SUPPORT.get()) {
                            world.func_175656_a((BlockPos)src, Blocks.field_150350_a.func_176223_P());
                        }
                        this.sourceToDest((BlockPos)src, dest);
                        Block dstBlock = world.func_180495_p((BlockPos)dest).func_177230_c();
                        if (dstBlock != BuilderSetup.SUPPORT.get()) continue;
                        world.func_175656_a((BlockPos)dest, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
    }

    public boolean isHilightMode() {
        return this.hilightMode;
    }

    public void setHilightMode(boolean hilightMode) {
        this.hilightMode = hilightMode;
    }

    public boolean isWaitMode() {
        return this.waitMode;
    }

    public void setWaitMode(boolean waitMode) {
        this.waitMode = waitMode;
        this.markDirtyClient();
    }

    private boolean waitOrSkip(String error) {
        if (this.waitMode) {
            this.lastError = error;
        }
        return this.waitMode;
    }

    private boolean skip() {
        this.lastError = null;
        return false;
    }

    public boolean suspend(int rfNeeded, BlockPos srcPos, BlockState srcState, BlockState pickState) {
        this.lastError = null;
        return true;
    }

    private boolean suspend(String error) {
        this.lastError = error;
        return true;
    }

    public boolean hasLoopMode() {
        return this.loopMode;
    }

    public void setLoopMode(boolean loopMode) {
        this.loopMode = loopMode;
        this.markDirtyClient();
    }

    public boolean hasEntityMode() {
        return this.entityMode;
    }

    public void setEntityMode(boolean entityMode) {
        this.entityMode = entityMode;
        this.markDirtyClient();
    }

    public boolean hasSupportMode() {
        return this.supportMode;
    }

    public void setSupportMode(boolean supportMode) {
        this.supportMode = supportMode;
        if (supportMode) {
            this.makeSupportBlocks();
        } else {
            this.clearSupportBlocks();
        }
        this.markDirtyClient();
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
        this.markDirtyClient();
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (mode != this.mode) {
            this.mode = mode;
            this.restartScan();
            this.markDirtyClient();
        }
    }

    public void resetBox() {
        this.boxValid = false;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int anchor) {
        if (this.supportMode) {
            this.clearSupportBlocks();
        }
        this.boxValid = false;
        this.anchor = anchor;
        if (this.isShapeCard()) {
            ItemStack shapeCard = this.items.getStackInSlot(0);
            BlockPos dimension = ShapeCardItem.getDimension(shapeCard);
            BlockPos minBox = this.positionBox(dimension);
            int dx = dimension.func_177958_n();
            int dy = dimension.func_177956_o();
            int dz = dimension.func_177952_p();
            BlockPos offset = new BlockPos(minBox.func_177958_n() + (int)Math.ceil(dx / 2), minBox.func_177956_o() + (int)Math.ceil(dy / 2), minBox.func_177952_p() + (int)Math.ceil(dz / 2));
            ShapeCardItem.setOffset(shapeCard, offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
        }
        if (this.supportMode) {
            this.makeSupportBlocks();
        }
        this.markDirtyClient();
    }

    private BlockPos positionBox(BlockPos dimension) {
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        Direction direction = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        int spanX = dimension.func_177958_n();
        int spanY = dimension.func_177956_o();
        int spanZ = dimension.func_177952_p();
        int x = 0;
        int z = 0;
        int y = -(this.anchor == 3 || this.anchor == 2 ? spanY - 1 : 0);
        switch (direction) {
            case SOUTH: {
                x = -(this.anchor == 3 || this.anchor == 1 ? spanX - 1 : 0);
                z = -spanZ;
                break;
            }
            case NORTH: {
                x = 1 - spanX + (this.anchor == 3 || this.anchor == 1 ? spanX - 1 : 0);
                z = 1;
                break;
            }
            case WEST: {
                x = 1;
                z = -(this.anchor == 3 || this.anchor == 1 ? spanZ - 1 : 0);
                break;
            }
            case EAST: {
                x = -spanX;
                z = -(this.anchor == 3 || this.anchor == 1 ? 0 : spanZ - 1);
                break;
            }
        }
        return new BlockPos(x, y, z);
    }

    public int getRotate() {
        return this.rotate;
    }

    public void setRotate(int rotate) {
        if (this.supportMode) {
            this.clearSupportBlocks();
        }
        this.boxValid = false;
        this.rotate = rotate;
        if (this.supportMode) {
            this.makeSupportBlocks();
        }
        this.markDirtyClient();
    }

    public void setPowerInput(int powered) {
        boolean o = this.isMachineEnabled();
        super.setPowerInput(powered);
        boolean n = this.isMachineEnabled();
        if (o != n && (this.loopMode || n && this.scan == null)) {
            this.restartScan();
        }
    }

    private void createProjection(SpaceChamberRepository.SpaceChamberChannel chamberChannel) {
        BlockPos minC = this.rotate(chamberChannel.getMinCorner());
        BlockPos maxC = this.rotate(chamberChannel.getMaxCorner());
        BlockPos minCorner = new BlockPos(Math.min(minC.func_177958_n(), maxC.func_177958_n()), Math.min(minC.func_177956_o(), maxC.func_177956_o()), Math.min(minC.func_177952_p(), maxC.func_177952_p()));
        BlockPos maxCorner = new BlockPos(Math.max(minC.func_177958_n(), maxC.func_177958_n()), Math.max(minC.func_177956_o(), maxC.func_177956_o()), Math.max(minC.func_177952_p(), maxC.func_177952_p()));
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        Direction direction = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        int spanX = maxCorner.func_177958_n() - minCorner.func_177958_n();
        int spanY = maxCorner.func_177956_o() - minCorner.func_177956_o();
        int spanZ = maxCorner.func_177952_p() - minCorner.func_177952_p();
        switch (direction) {
            case SOUTH: {
                this.projDx = xCoord + Direction.NORTH.func_176730_m().func_177958_n() - minCorner.func_177958_n() - (this.anchor == 3 || this.anchor == 1 ? spanX : 0);
                this.projDz = zCoord + Direction.NORTH.func_176730_m().func_177952_p() - minCorner.func_177952_p() - spanZ;
                break;
            }
            case NORTH: {
                this.projDx = xCoord + Direction.SOUTH.func_176730_m().func_177958_n() - minCorner.func_177958_n() - spanX + (this.anchor == 3 || this.anchor == 1 ? spanX : 0);
                this.projDz = zCoord + Direction.SOUTH.func_176730_m().func_177952_p() - minCorner.func_177952_p();
                break;
            }
            case WEST: {
                this.projDx = xCoord + Direction.EAST.func_176730_m().func_177958_n() - minCorner.func_177958_n();
                this.projDz = zCoord + Direction.EAST.func_176730_m().func_177952_p() - minCorner.func_177952_p() - (this.anchor == 3 || this.anchor == 1 ? spanZ : 0);
                break;
            }
            case EAST: {
                this.projDx = xCoord + Direction.WEST.func_176730_m().func_177958_n() - minCorner.func_177958_n() - spanX;
                this.projDz = zCoord + Direction.WEST.func_176730_m().func_177952_p() - minCorner.func_177952_p() - spanZ + (this.anchor == 3 || this.anchor == 1 ? spanZ : 0);
                break;
            }
        }
        this.projDy = yCoord - minCorner.func_177956_o() - (this.anchor == 3 || this.anchor == 2 ? spanY : 0);
    }

    private void calculateBox(CompoundNBT cardCompound) {
        int channel = cardCompound.func_74762_e("channel");
        SpaceChamberRepository repository = SpaceChamberRepository.get(this.field_145850_b);
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
        BlockPos minCorner = chamberChannel.getMinCorner();
        BlockPos maxCorner = chamberChannel.getMaxCorner();
        if (minCorner == null || maxCorner == null) {
            return;
        }
        if (this.boxValid && minCorner.equals((Object)this.minBox) && maxCorner.equals((Object)this.maxBox)) {
            return;
        }
        this.boxValid = true;
        this.cardType = ShapeCardType.CARD_SPACE;
        this.createProjection(chamberChannel);
        this.minBox = minCorner;
        this.maxBox = maxCorner;
        this.restartScan();
    }

    private void checkStateServerShaped() {
        float factor = ((Float)this.infusableHandler.map(IInfusable::getInfusedFactor).orElse((Object)Float.valueOf(0.0f))).floatValue();
        int i = 0;
        while ((float)i < (float)((Integer)BuilderConfiguration.quarryBaseSpeed.get()).intValue() + factor * (float)((Integer)BuilderConfiguration.quarryInfusionSpeedFactor.get()).intValue()) {
            if (this.scan != null) {
                this.handleBlockShaped();
            }
            ++i;
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (!this.overflowItems.isEmpty()) {
            this.insertItems(this.overflowItems.extractList());
        }
        if (!this.isMachineEnabled() && this.loopMode) {
            return;
        }
        if (this.scan == null) {
            return;
        }
        if (this.isHilightMode()) {
            this.updateHilight();
        }
        if (this.isShapeCard()) {
            if (!this.isMachineEnabled()) {
                this.chunkUnload();
                return;
            }
            this.checkStateServerShaped();
            return;
        }
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel == null) {
            this.scan = null;
            this.func_70296_d();
            return;
        }
        DimensionType dimension = chamberChannel.getDimension();
        ServerWorld world = WorldTools.getWorld((World)this.field_145850_b, (DimensionType)dimension);
        if (world == null) {
            return;
        }
        if (this.mode == 4) {
            this.collectItems((World)world);
        } else {
            float factor = ((Float)this.infusableHandler.map(IInfusable::getInfusedFactor).orElse((Object)Float.valueOf(0.0f))).floatValue();
            int i = 0;
            while ((float)i < 2.0f + factor * 40.0f) {
                if (this.scan != null) {
                    this.handleBlock((World)world);
                }
                ++i;
            }
        }
    }

    private void updateHilight() {
        --this.scanLocCnt;
        if (this.scanLocCnt <= 0) {
            this.scanLocCnt = 5;
            int x = this.scan.func_177958_n();
            int y = this.scan.func_177956_o();
            int z = this.scan.func_177952_p();
            double sqradius = 900.0;
            for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                double d2;
                double d1;
                double d0;
                if (!player.field_71093_bK.equals(this.field_145850_b.func_201675_m().func_186058_p()) || !((d0 = (double)x - player.func_226277_ct_()) * d0 + (d1 = (double)y - player.func_226278_cu_()) * d1 + (d2 = (double)z - player.func_226281_cx_()) * d2 < sqradius)) continue;
                RFToolsBuilderMessages.sendToClient((PlayerEntity)player, "positionToClient", TypedMap.builder().put(ClientCommandHandler.PARAM_POS, (Object)this.func_174877_v()).put(ClientCommandHandler.PARAM_SCAN, (Object)this.scan));
            }
        }
    }

    private void collectItems(World world) {
        float factor;
        --this.collectCounter;
        if (this.collectCounter > 0) {
            return;
        }
        this.collectCounter = (Integer)BuilderConfiguration.collectTimer.get();
        if (!this.loopMode) {
            this.scan = null;
        }
        if (!((Boolean)this.energyHandler.map(arg_0 -> this.lambda$collectItems$10(factor = ((Float)this.infusableHandler.map(IInfusable::getInfusedFactor).orElse((Object)Float.valueOf(0.0f))).floatValue(), arg_0)).orElse((Object)false)).booleanValue()) {
            return;
        }
        AxisAlignedBB bb = new AxisAlignedBB((double)this.minBox.func_177958_n() - 0.8, (double)this.minBox.func_177956_o() - 0.8, (double)this.minBox.func_177952_p() - 0.8, (double)this.maxBox.func_177958_n() + 0.8, (double)this.maxBox.func_177956_o() + 0.8, (double)this.maxBox.func_177952_p() + 0.8);
        List items = world.func_217357_a(Entity.class, bb);
        for (Entity entity : items) {
            if (!(entity instanceof ItemEntity ? this.collectItem(world, factor, (ItemEntity)entity) : entity instanceof ExperienceOrbEntity && this.collectXP(world, factor, (ExperienceOrbEntity)entity))) continue;
            return;
        }
    }

    private boolean collectXP(World world, float infusedFactor, ExperienceOrbEntity orb) {
        return (Boolean)this.energyHandler.map(h -> {
            int xp = orb.func_70526_d();
            long rf = h.getEnergyStored();
            int rfNeeded = (int)((Double)BuilderConfiguration.collectRFPerXP.get() * (double)infusedFactor * (double)xp);
            if ((long)rfNeeded > rf) {
                return true;
            }
            this.collectXP += xp;
            int bottles = this.collectXP / 7;
            if (bottles > 0) {
                if (this.insertItem(new ItemStack((IItemProvider)Items.field_151062_by, bottles)).func_190926_b()) {
                    this.collectXP %= 7;
                    ((ServerWorld)world).func_217467_h((Entity)orb);
                    h.consumeEnergy((long)rfNeeded);
                } else {
                    this.collectXP = 0;
                }
            }
            return false;
        }).orElse((Object)false);
    }

    private boolean collectItem(World world, float infusedFactor, ItemEntity item) {
        return (Boolean)this.energyHandler.map(h -> {
            ItemStack stack = item.func_92059_d();
            long rf = h.getEnergyStored();
            int rfNeeded = (int)((float)((Integer)BuilderConfiguration.collectRFPerItem.get()).intValue() * infusedFactor) * stack.func_190916_E();
            if ((long)rfNeeded > rf) {
                return true;
            }
            h.consumeEnergy((long)rfNeeded);
            ((ServerWorld)world).func_217467_h((Entity)item);
            stack = this.insertItem(stack);
            if (!stack.func_190926_b()) {
                BlockPos position = item.func_180425_c();
                ItemEntity entityItem = new ItemEntity(world, (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), stack);
                world.func_217376_c((Entity)entityItem);
            }
            return false;
        }).orElse((Object)false);
    }

    private void calculateBoxShaped() {
        ItemStack shapeCard = this.items.getStackInSlot(0);
        if (shapeCard.func_190926_b()) {
            return;
        }
        BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, (int)((Integer)BuilderConfiguration.maxBuilderDimension.get()));
        BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, (int)((Integer)BuilderConfiguration.maxBuilderOffset.get()));
        BlockPos minCorner = ShapeCardItem.getMinCorner(this.func_174877_v(), dimension, offset);
        BlockPos maxCorner = ShapeCardItem.getMaxCorner(this.func_174877_v(), dimension, offset);
        if (minCorner.func_177956_o() < 0) {
            minCorner = new BlockPos(minCorner.func_177958_n(), 0, minCorner.func_177952_p());
        } else if (minCorner.func_177956_o() > 255) {
            minCorner = new BlockPos(minCorner.func_177958_n(), 255, minCorner.func_177952_p());
        }
        if (maxCorner.func_177956_o() < 0) {
            maxCorner = new BlockPos(maxCorner.func_177958_n(), 0, maxCorner.func_177952_p());
        } else if (maxCorner.func_177956_o() > 255) {
            maxCorner = new BlockPos(maxCorner.func_177958_n(), 255, maxCorner.func_177952_p());
        }
        if (this.boxValid && minCorner.equals((Object)this.minBox) && maxCorner.equals((Object)this.maxBox)) {
            return;
        }
        this.boxValid = true;
        this.cardType = ShapeCardItem.getType(shapeCard);
        this.cachedBlocks = null;
        this.cachedChunk = null;
        this.cachedVoidableBlocks.clear();
        this.minBox = minCorner;
        this.maxBox = maxCorner;
        this.restartScan();
    }

    private SpaceChamberRepository.SpaceChamberChannel calculateBox() {
        CompoundNBT tc = this.hasCard();
        if (tc == null) {
            return null;
        }
        int channel = tc.func_74762_e("channel");
        if (channel == -1) {
            return null;
        }
        SpaceChamberRepository repository = SpaceChamberRepository.get(this.field_145850_b);
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
        if (chamberChannel == null) {
            return null;
        }
        this.calculateBox(tc);
        if (!this.boxValid) {
            return null;
        }
        return chamberChannel;
    }

    private Map<BlockPos, BlockState> getCachedBlocks(ChunkPos chunk) {
        if (chunk != null && !chunk.equals((Object)this.cachedChunk) || chunk == null && this.cachedChunk != null) {
            this.cachedBlocks = null;
        }
        if (this.cachedBlocks == null) {
            this.cachedBlocks = new HashMap<BlockPos, BlockState>();
            ItemStack shapeCard = this.items.getStackInSlot(0);
            Shape shape = ShapeCardItem.getShape(shapeCard);
            boolean solid = ShapeCardItem.isSolid(shapeCard);
            BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, (int)((Integer)BuilderConfiguration.maxBuilderDimension.get()));
            BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, (int)((Integer)BuilderConfiguration.maxBuilderOffset.get()));
            boolean forquarry = !ShapeCardItem.isNormalShapeCard(shapeCard);
            ShapeCardItem.composeFormula(shapeCard, shape.getFormulaFactory().get(), this.field_145850_b, this.func_174877_v(), dimension, offset, this.cachedBlocks, (Integer)BuilderConfiguration.maxSpaceChamberDimension.get() * (Integer)BuilderConfiguration.maxSpaceChamberDimension.get() * (Integer)BuilderConfiguration.maxSpaceChamberDimension.get(), solid, forquarry, chunk);
            this.cachedChunk = chunk;
        }
        return this.cachedBlocks;
    }

    private void handleBlockShaped() {
        for (int i = 0; i < 100; ++i) {
            if (this.scan == null) {
                return;
            }
            Map<BlockPos, BlockState> blocks = this.getCachedBlocks(new ChunkPos(this.scan.func_177958_n() >> 4, this.scan.func_177952_p() >> 4));
            if (blocks.containsKey(this.scan)) {
                BlockState state = blocks.get(this.scan);
                if (!this.handleSingleBlock(state)) {
                    this.nextLocation();
                }
                return;
            }
            this.nextLocation();
        }
    }

    private ShapeCardType getCardType() {
        if (this.cardType == ShapeCardType.CARD_UNKNOWN) {
            return ShapeCardItem.getType(this.items.getStackInSlot(0));
        }
        return this.cardType;
    }

    private boolean handleSingleBlock(BlockState pickState) {
        float factor;
        Block block;
        if (this.field_145850_b == null) {
            return false;
        }
        BlockPos srcPos = this.scan;
        int sx = this.scan.func_177958_n();
        int sy = this.scan.func_177956_o();
        int sz = this.scan.func_177952_p();
        if (!this.chunkLoad(sx, sz)) {
            return this.suspend("Chunk not available!");
        }
        int rfNeeded = this.getCardType().getRfNeeded();
        BlockState state = null;
        if (this.getCardType() != ShapeCardType.CARD_SHAPE && this.getCardType() != ShapeCardType.CARD_PUMP_LIQUID && !BuilderTileEntity.isEmpty(state = this.field_145850_b.func_180495_p(srcPos), block = state.func_177230_c())) {
            float hardness;
            if (BuilderTileEntity.isFluidBlock(block)) {
                hardness = 1.0f;
            } else {
                if (((Set)this.cachedVoidableBlocks.get()).contains(block)) {
                    rfNeeded = (int)((double)((Integer)BuilderConfiguration.builderRfPerQuarry.get()).intValue() * (Double)BuilderConfiguration.voidShapeCardFactor.get());
                }
                hardness = state.func_185887_b((IBlockReader)this.field_145850_b, srcPos);
            }
            rfNeeded *= (int)((hardness + 1.0f) * 2.0f);
        }
        if ((rfNeeded = (int)((float)rfNeeded * (3.0f - (factor = ((Float)this.infusableHandler.map(IInfusable::getInfusedFactor).orElse((Object)Float.valueOf(0.0f))).floatValue())) / 3.0f)) > (Integer)this.energyHandler.map(GenericEnergyStorage::getEnergyStored).orElse((Object)0)) {
            return this.suspend("Not enough power!");
        }
        return this.getCardType().handleSingleBlock(this, rfNeeded, srcPos, state, pickState);
    }

    public boolean buildBlock(int rfNeeded, BlockPos srcPos, BlockState srcState, BlockState pickState) {
        if (this.field_145850_b == null) {
            return false;
        }
        if (BuilderTileEntity.isEmptyOrReplacable(this.field_145850_b, srcPos)) {
            TakeableItem item = this.createTakeableItem(this.field_145850_b, srcPos, pickState);
            ItemStack stack = item.peek();
            if (stack.func_190926_b()) {
                return this.waitOrSkip("Cannot find block!\nor missing inventory\non top or below");
            }
            FakePlayer fakePlayer = (FakePlayer)this.harvester.get();
            BlockState newState = BlockTools.placeStackAt((PlayerEntity)fakePlayer, (ItemStack)stack, (World)this.field_145850_b, (BlockPos)srcPos, (BlockState)pickState);
            if (newState == null) {
                return this.waitOrSkip("Cannot place block!");
            }
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)item.peek())) {
                if (!stack.func_190926_b()) {
                    if (!(stack = item.takeAndReplace(stack)).func_190926_b() && !(stack = this.insertItem(stack)).func_190926_b()) {
                        this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), stack));
                    }
                } else {
                    item.take();
                }
            }
            if (!this.silent) {
                SoundType sound = newState.func_177230_c().getSoundType(newState, (IWorldReader)this.field_145850_b, srcPos, (Entity)fakePlayer);
                this.playPlaceSoundSafe(sound, this.field_145850_b, newState, srcPos.func_177958_n(), srcPos.func_177956_o(), srcPos.func_177952_p());
            }
            this.energyHandler.ifPresent(h -> h.consumeEnergy((long)rfNeeded));
        }
        return this.skip();
    }

    private void playPlaceSoundSafe(SoundType sound, World world, BlockState state, int x, int y, int z) {
        try {
            SoundTools.playSound((World)world, (SoundEvent)sound.func_185841_e(), (double)x, (double)y, (double)z, (double)1.0, (double)1.0);
        }
        catch (Exception e) {
            Logging.getLogger().error("Error getting soundtype from " + state.func_177230_c().getRegistryName() + "! Please report to the mod owner!");
        }
    }

    private void playBreakSoundSafe(SoundType sound, World world, BlockState state, int x, int y, int z) {
        try {
            SoundTools.playSound((World)world, (SoundEvent)sound.func_185845_c(), (double)x, (double)y, (double)z, (double)1.0, (double)1.0);
        }
        catch (Exception e) {
            Logging.getLogger().error("Error getting soundtype from " + state.func_177230_c().getRegistryName() + "! Please report to the mod owner!");
        }
    }

    private Set<Block> getCachedVoidableBlocks() {
        ItemStack card = this.items.getStackInSlot(0);
        if (!card.func_190926_b() && card.func_77973_b() instanceof ShapeCardItem) {
            return ShapeCardItem.getVoidedBlocks(card);
        }
        return Collections.emptySet();
    }

    private void clearOrDirtBlock(int rfNeeded, BlockPos spos, BlockState srcState, boolean clear) {
        if (clear) {
            this.field_145850_b.func_180501_a(spos, Blocks.field_150350_a.func_176223_P(), 2);
        } else {
            this.field_145850_b.func_180501_a(spos, this.getReplacementBlock(), 2);
        }
        this.energyHandler.ifPresent(h -> h.consumeEnergy((long)rfNeeded));
        if (!this.silent) {
            SoundType soundType = srcState.func_177230_c().getSoundType(srcState, (IWorldReader)this.field_145850_b, spos, null);
            this.playBreakSoundSafe(soundType, this.field_145850_b, srcState, spos.func_177958_n(), spos.func_177956_o(), spos.func_177952_p());
        }
    }

    private BlockState getReplacementBlock() {
        return BuilderConfiguration.getQuarryReplace();
    }

    public boolean silkQuarryBlock(int rfNeeded, BlockPos srcPos, BlockState srcState, BlockState pickState) {
        return this.commonQuarryBlock(true, rfNeeded, srcPos, srcState);
    }

    private Predicate<ItemStack> createFilterCache() {
        return FilterModuleItem.getCache((ItemStack)this.items.getStackInSlot(1));
    }

    public static boolean allowedToBreak(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        if (!state.func_177230_c().canEntityDestroy(state, (IBlockReader)world, pos, (Entity)player)) {
            return false;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public boolean quarryBlock(int rfNeeded, BlockPos srcPos, BlockState srcState, BlockState pickState) {
        return this.commonQuarryBlock(false, rfNeeded, srcPos, srcState);
    }

    private static ItemStack getHarvesterTool(boolean silk, int fortune) {
        if (silk) {
            if (TOOL_SILK == null || TOOL_SILK.func_190926_b()) {
                TOOL_SILK = new ItemStack((IItemProvider)BuilderSetup.SUPER_HARVESTING_TOOL.get());
                TOOL_SILK.func_77966_a(Enchantments.field_185306_r, 1);
            }
            return TOOL_SILK;
        }
        if (fortune > 0) {
            if (TOOL_FORTUNE == null || TOOL_FORTUNE.func_190926_b()) {
                TOOL_FORTUNE = new ItemStack((IItemProvider)BuilderSetup.SUPER_HARVESTING_TOOL.get());
                TOOL_FORTUNE.func_77966_a(Enchantments.field_185308_t, fortune);
            }
            return TOOL_FORTUNE;
        }
        if (TOOL_NORMAL == null || TOOL_NORMAL.func_190926_b()) {
            TOOL_NORMAL = new ItemStack((IItemProvider)BuilderSetup.SUPER_HARVESTING_TOOL.get());
        }
        return TOOL_NORMAL;
    }

    private boolean commonQuarryBlock(boolean silk, int rfNeeded, BlockPos srcPos, BlockState srcState) {
        Block block = srcState.func_177230_c();
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        int sx = srcPos.func_177958_n();
        int sy = srcPos.func_177956_o();
        int sz = srcPos.func_177952_p();
        if (sx >= xCoord - 1 && sx <= xCoord + 1 && sy >= yCoord - 1 && sy <= yCoord + 1 && sz >= zCoord - 1 && sz <= zCoord + 1) {
            return this.skip();
        }
        if (BuilderTileEntity.isEmpty(srcState, block)) {
            return this.skip();
        }
        if (srcState.func_185887_b((IBlockReader)this.field_145850_b, srcPos) >= 0.0f) {
            boolean clear = this.getCardType().isClearing();
            if (!clear && srcState == this.getReplacementBlock()) {
                return this.skip();
            }
            if (!((Boolean)BuilderConfiguration.quarryTileEntities.get()).booleanValue() && this.field_145850_b.func_175625_s(srcPos) != null) {
                return this.skip();
            }
            FakePlayer fakePlayer = (FakePlayer)this.harvester.get();
            if (BuilderTileEntity.allowedToBreak(srcState, this.field_145850_b, srcPos, (PlayerEntity)fakePlayer)) {
                boolean match;
                ItemStack filter = this.items.getStackInSlot(1);
                if (!filter.func_190926_b() && this.filterCache.get() != null && !(match = ((Predicate)this.filterCache.get()).test(block.func_185473_a((IBlockReader)this.field_145850_b, srcPos, srcState)))) {
                    this.energyHandler.ifPresent(h -> h.consumeEnergy((long)Math.min(rfNeeded, (Integer)BuilderConfiguration.builderRfPerSkipped.get())));
                    return this.skip();
                }
                if (!((Set)this.cachedVoidableBlocks.get()).contains(block)) {
                    List drops;
                    if (!this.overflowItems.isEmpty()) {
                        return this.waitOrSkip("Not enough room!\nor no usable storage\non top or below!");
                    }
                    int fortune = this.getCardType().isFortune() ? 3 : 0;
                    LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216023_a(this.field_145850_b.field_73012_v).func_216015_a(LootParameters.field_216286_f, (Object)srcPos).func_216015_a(LootParameters.field_216289_i, (Object)BuilderTileEntity.getHarvesterTool(silk, fortune)).func_216021_b(LootParameters.field_216288_h, (Object)this.field_145850_b.func_175625_s(srcPos));
                    if (fortune > 0) {
                        builder.func_186469_a((float)fortune);
                    }
                    if (this.checkValidItems(block, drops = srcState.func_215693_a(builder)) && !this.insertItems(drops)) {
                        this.clearOrDirtBlock(rfNeeded, srcPos, srcState, clear);
                        return this.waitOrSkip("Not enough room!\nor no usable storage\non top or below!");
                    }
                }
                this.clearOrDirtBlock(rfNeeded, srcPos, srcState, clear);
            }
        }
        return false;
    }

    private static boolean isFluidBlock(Block block) {
        return block instanceof FlowingFluidBlock;
    }

    private static int getFluidLevel(BlockState srcState) {
        if (srcState.func_177230_c() instanceof FlowingFluidBlock) {
            return (Integer)srcState.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b);
        }
        return -1;
    }

    public boolean placeLiquidBlock(int rfNeeded, BlockPos srcPos, BlockState srcState, BlockState pickState) {
        if (BuilderTileEntity.isEmptyOrReplacable(this.field_145850_b, srcPos)) {
            FluidStack stack = this.consumeLiquid(this.field_145850_b, srcPos);
            if (stack == null) {
                return this.waitOrSkip("Cannot find liquid!\nor no usable tank\nabove or below");
            }
            Fluid fluid = stack.getFluid();
            if (fluid.getAttributes().doesVaporize((ILightReader)this.field_145850_b, srcPos, stack) && this.field_145850_b.func_201675_m().func_177500_n()) {
                fluid.getAttributes().vaporize(null, this.field_145850_b, srcPos, stack);
            } else {
                Block block = fluid.func_207188_f().func_206883_i().func_177230_c();
                FakePlayer fakePlayer = (FakePlayer)this.harvester.get();
                this.field_145850_b.func_180501_a(srcPos, block.func_176223_P(), 11);
                if (!this.silent) {
                    SoundType soundType = block.getSoundType(block.func_176223_P(), (IWorldReader)this.field_145850_b, srcPos, (Entity)fakePlayer);
                    this.playPlaceSoundSafe(soundType, this.field_145850_b, block.func_176223_P(), srcPos.func_177958_n(), srcPos.func_177956_o(), srcPos.func_177952_p());
                }
            }
            this.energyHandler.ifPresent(h -> h.consumeEnergy((long)rfNeeded));
        }
        return this.skip();
    }

    public boolean pumpBlock(int rfNeeded, BlockPos srcPos, BlockState srcState, BlockState pickState) {
        FakePlayer fakePlayer;
        Block block = srcState.func_177230_c();
        IFluidState fluidState = this.field_145850_b.func_204610_c(srcPos);
        if (fluidState == null) {
            return this.skip();
        }
        if (!fluidState.func_206889_d()) {
            return this.skip();
        }
        FluidStack fluidStack = FluidTools.pickupFluidBlock((World)this.field_145850_b, (BlockPos)srcPos, s -> false, () -> {});
        if (fluidStack.isEmpty()) {
            return this.skip();
        }
        if (srcState.func_185887_b((IBlockReader)this.field_145850_b, srcPos) >= 0.0f && BuilderTileEntity.allowedToBreak(srcState, this.field_145850_b, srcPos, (PlayerEntity)(fakePlayer = (FakePlayer)this.harvester.get()))) {
            if (this.checkAndInsertFluids(fluidStack)) {
                this.energyHandler.ifPresent(h -> h.consumeEnergy((long)rfNeeded));
                boolean clear = this.getCardType().isClearing();
                FluidTools.pickupFluidBlock((World)this.field_145850_b, (BlockPos)srcPos, s -> true, () -> {
                    if (clear) {
                        this.field_145850_b.func_180501_a(srcPos, Blocks.field_150350_a.func_176223_P(), 2);
                    } else {
                        this.field_145850_b.func_180501_a(srcPos, this.getReplacementBlock(), 2);
                    }
                });
                if (!this.silent) {
                    SoundType soundType = block.getSoundType(srcState, (IWorldReader)this.field_145850_b, srcPos, (Entity)fakePlayer);
                    this.playBreakSoundSafe(soundType, this.field_145850_b, srcState, srcPos.func_177958_n(), srcPos.func_177956_o(), srcPos.func_177952_p());
                }
                return this.skip();
            }
            return this.waitOrSkip("No room for liquid\nor no usable tank\nabove or below!");
        }
        return this.skip();
    }

    public boolean voidBlock(int rfNeeded, BlockPos srcPos, BlockState srcState, BlockState pickState) {
        Block block = srcState.func_177230_c();
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        int sx = srcPos.func_177958_n();
        int sy = srcPos.func_177956_o();
        int sz = srcPos.func_177952_p();
        if (sx >= xCoord - 1 && sx <= xCoord + 1 && sy >= yCoord - 1 && sy <= yCoord + 1 && sz >= zCoord - 1 && sz <= zCoord + 1) {
            return this.skip();
        }
        FakePlayer fakePlayer = (FakePlayer)this.harvester.get();
        if (BuilderTileEntity.allowedToBreak(srcState, this.field_145850_b, srcPos, (PlayerEntity)fakePlayer)) {
            assert (this.field_145850_b != null);
            if (srcState.func_185887_b((IBlockReader)this.field_145850_b, srcPos) >= 0.0f) {
                boolean match;
                ItemStack filter = this.items.getStackInSlot(1);
                if (!filter.func_190926_b() && this.filterCache.get() != null && !(match = ((Predicate)this.filterCache.get()).test(block.func_185473_a((IBlockReader)this.field_145850_b, srcPos, srcState)))) {
                    this.energyHandler.ifPresent(h -> h.consumeEnergy((long)Math.min(rfNeeded, (Integer)BuilderConfiguration.builderRfPerSkipped.get())));
                    return this.skip();
                }
                if (!this.silent) {
                    SoundType soundType = block.getSoundType(srcState, (IWorldReader)this.field_145850_b, srcPos, (Entity)fakePlayer);
                    this.playBreakSoundSafe(soundType, this.field_145850_b, srcState, sx, sy, sz);
                }
                this.field_145850_b.func_175656_a(srcPos, Blocks.field_150350_a.func_176223_P());
                this.energyHandler.ifPresent(h -> h.consumeEnergy((long)rfNeeded));
            }
        }
        return this.skip();
    }

    private void handleBlock(World world) {
        BlockPos srcPos = this.scan;
        BlockPos destPos = this.sourceToDest(this.scan);
        int x = this.scan.func_177958_n();
        int y = this.scan.func_177956_o();
        int z = this.scan.func_177952_p();
        int destX = destPos.func_177958_n();
        int destY = destPos.func_177956_o();
        int destZ = destPos.func_177952_p();
        switch (this.mode) {
            case 0: {
                this.copyBlock(world, srcPos, world, destPos);
                break;
            }
            case 1: {
                if (this.entityMode) {
                    this.moveEntities(world, x, y, z, world, destX, destY, destZ);
                }
                this.moveBlock(world, srcPos, world, destPos, this.rotate);
                break;
            }
            case 3: {
                if (this.entityMode) {
                    this.moveEntities(world, destX, destY, destZ, world, x, y, z);
                }
                this.moveBlock(world, destPos, world, srcPos, this.oppositeRotate());
                break;
            }
            case 2: {
                if (this.entityMode) {
                    this.swapEntities(world, x, y, z, world, destX, destY, destZ);
                }
                this.swapBlock(world, srcPos, world, destPos);
            }
        }
        this.nextLocation();
    }

    private TakeableItem findBlockTakeableItem(IItemHandler inventory, World srcWorld, BlockPos srcPos, BlockState state) {
        if (state == null) {
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (!this.isPlacable(inventory.getStackInSlot(i))) continue;
                slots.add(i);
            }
            if (!slots.isEmpty()) {
                return new TakeableItem(inventory, (int)((Integer)slots.get(random.nextInt(slots.size()))));
            }
        } else {
            Block block = state.func_177230_c();
            ItemStack srcItem = block.func_185473_a((IBlockReader)srcWorld, srcPos, state);
            if (this.isPlacable(srcItem)) {
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    ItemStack stack = inventory.getStackInSlot(i);
                    if (stack.func_190926_b() || !stack.func_77969_a(srcItem)) continue;
                    return new TakeableItem(inventory, i);
                }
            }
        }
        return TakeableItem.EMPTY;
    }

    private boolean isPlacable(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item instanceof BlockItem || item instanceof IPlantable;
    }

    private boolean checkValidItems(Block block, List<ItemStack> items) {
        for (ItemStack stack : items) {
            if (stack.func_190926_b() || stack.func_77973_b() != null) continue;
            Logging.logError((String)("Builder tried to quarry " + block.getRegistryName().toString() + " and it returned null item!"));
            Broadcaster.broadcast((World)this.field_145850_b, (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p(), (String)("Builder tried to quarry " + block.getRegistryName().toString() + " and it returned null item!\nPlease report to mod author!"), (float)10.0f);
            return false;
        }
        return true;
    }

    private boolean checkAndInsertFluids(FluidStack fluid) {
        if (this.checkFluidTank(fluid, this.func_174877_v().func_177984_a(), Direction.DOWN)) {
            return true;
        }
        return this.checkFluidTank(fluid, this.func_174877_v().func_177977_b(), Direction.UP);
    }

    private boolean checkFluidTank(FluidStack fluidStack, BlockPos up, Direction side) {
        TileEntity te = this.field_145850_b.func_175625_s(up);
        if (te != null) {
            return (Boolean)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side).map(h -> {
                int amount = h.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
                if (amount == 1000) {
                    h.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    return true;
                }
                return false;
            }).orElse((Object)false);
        }
        return false;
    }

    private void handleItemInsertion(@Nullable TileEntity te, Direction direction, List<ItemStack> items, LazyList<ItemStack> couldntHandle) {
        if (te == null) {
            couldntHandle.copyList(items);
            return;
        }
        LazyOptional capability = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction);
        if (!capability.isPresent()) {
            couldntHandle.copyList(items);
            return;
        }
        couldntHandle.clear();
        te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).ifPresent(h -> {
            for (ItemStack item : items) {
                ItemStack overflow = ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)item, (boolean)false);
                if (overflow.func_190926_b()) continue;
                couldntHandle.add(overflow);
            }
        });
    }

    private boolean insertItems(List<ItemStack> items) {
        this.handleItemInsertion(this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a()), Direction.DOWN, items, this.couldntHandle1);
        if (this.couldntHandle1.isEmpty()) {
            return true;
        }
        this.handleItemInsertion(this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b()), Direction.UP, this.couldntHandle1.getList(), this.couldntHandle2);
        if (this.couldntHandle2.isEmpty()) {
            return true;
        }
        this.overflowItems.copyList(this.couldntHandle2.getList());
        return false;
    }

    private ItemStack insertItem(@Nonnull ItemStack s) {
        s = InventoryTools.insertItem((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (Direction)Direction.UP, (ItemStack)s);
        if (!s.func_190926_b()) {
            s = InventoryTools.insertItem((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (Direction)Direction.DOWN, (ItemStack)s);
        }
        return s;
    }

    private TakeableItem createTakeableItem(Direction direction, World srcWorld, BlockPos srcPos, BlockState state) {
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(direction));
        if (te != null) {
            return (TakeableItem)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).map(h -> this.findBlockTakeableItem((IItemHandler)h, srcWorld, srcPos, state)).orElse((Object)TakeableItem.EMPTY);
        }
        return TakeableItem.EMPTY;
    }

    private FluidStack consumeLiquid(World srcWorld, BlockPos srcPos) {
        FluidStack b = this.consumeLiquid(Direction.UP, srcWorld, srcPos);
        if (b == null) {
            b = this.consumeLiquid(Direction.DOWN, srcWorld, srcPos);
        }
        return b;
    }

    private FluidStack consumeLiquid(Direction direction, World srcWorld, BlockPos srcPos) {
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(direction));
        if (te != null) {
            LazyOptional fluid = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d());
            if (!fluid.isPresent()) {
                fluid = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
            }
            if (fluid.isPresent()) {
                return (FluidStack)fluid.map(h -> this.findAndConsumeLiquid((IFluidHandler)h, srcWorld, srcPos)).orElse(null);
            }
        }
        return null;
    }

    private FluidStack findAndConsumeLiquid(IFluidHandler tank, World srcWorld, BlockPos srcPos) {
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack contents = tank.getFluidInTank(i);
            if (contents.isEmpty() || contents.getFluid() == null || contents.getAmount() < 1000) continue;
            FluidStack drained = tank.drain(new FluidStack(contents.getFluid(), 1000, contents.getTag()), IFluidHandler.FluidAction.EXECUTE);
            return drained;
        }
        return null;
    }

    private TakeableItem createTakeableItem(World srcWorld, BlockPos srcPos, BlockState state) {
        TakeableItem b = this.createTakeableItem(Direction.UP, srcWorld, srcPos, state);
        if (b.peek().func_190926_b()) {
            b = this.createTakeableItem(Direction.DOWN, srcWorld, srcPos, state);
        }
        return b;
    }

    public static BlockInformation getBlockInformation(PlayerEntity fakePlayer, World world, BlockPos pos, Block block, TileEntity tileEntity) {
        BlockState state = world.func_180495_p(pos);
        if (BuilderTileEntity.isEmpty(state, block)) {
            return BlockInformation.FREE;
        }
        if (!BuilderTileEntity.allowedToBreak(state, world, pos, fakePlayer)) {
            return BlockInformation.INVALID;
        }
        BlockInformation blockInformation = BlockInformation.getBlockInformation(block);
        if (tileEntity != null) {
            switch ((BuilderTileEntityMode)((Object)BuilderConfiguration.teMode.get())) {
                case MOVE_FORBIDDEN: {
                    return BlockInformation.INVALID;
                }
                case MOVE_WHITELIST: {
                    if (blockInformation != null && blockInformation.getBlockLevel() != 2) break;
                    return BlockInformation.INVALID;
                }
                case MOVE_BLACKLIST: {
                    if (blockInformation == null || blockInformation.getBlockLevel() != 2) break;
                    return BlockInformation.INVALID;
                }
            }
        }
        if (blockInformation != null) {
            return blockInformation;
        }
        return BlockInformation.OK;
    }

    private int isMovable(World world, BlockPos pos, Block block, TileEntity tileEntity) {
        return BuilderTileEntity.getBlockInformation((PlayerEntity)this.harvester.get(), world, pos, block, tileEntity).getBlockLevel();
    }

    public static boolean isEmptyOrReplacable(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (state.func_185904_a().func_76222_j()) {
            return true;
        }
        return BuilderTileEntity.isEmpty(state, block);
    }

    public static boolean isEmpty(BlockState state, Block block) {
        if (block == null) {
            return true;
        }
        if (state.func_185904_a() == Material.field_151579_a) {
            return true;
        }
        return block == BuilderSetup.SUPPORT.get();
    }

    private void clearBlock(World world, BlockPos pos) {
        if (this.supportMode) {
            world.func_180501_a(pos, ((SupportBlock)BuilderSetup.SUPPORT.get()).func_176223_P(), 3);
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    private int oppositeRotate() {
        switch (this.rotate) {
            case 1: {
                return 3;
            }
            case 3: {
                return 1;
            }
        }
        return this.rotate;
    }

    private void copyBlock(World srcWorld, BlockPos srcPos, World destWorld, BlockPos destPos) {
        this.energyHandler.ifPresent(h -> {
            long rf = h.getEnergy();
            float factor = ((Float)this.infusableHandler.map(IInfusable::getInfusedFactor).orElse((Object)Float.valueOf(0.0f))).floatValue();
            int rfNeeded = (int)((double)((Integer)BuilderConfiguration.builderRfPerOperation.get()).intValue() * this.getDimensionCostFactor(srcWorld, destWorld) * (double)(4.0f - factor) / 4.0);
            if ((long)rfNeeded > rf) {
                return;
            }
            if (BuilderTileEntity.isEmptyOrReplacable(destWorld, destPos)) {
                if (srcWorld.func_175623_d(srcPos)) {
                    return;
                }
                BlockState srcState = srcWorld.func_180495_p(srcPos);
                TakeableItem takeableItem = this.createTakeableItem(srcWorld, srcPos, srcState);
                ItemStack consumedStack = takeableItem.peek();
                if (consumedStack.func_190926_b()) {
                    return;
                }
                FakePlayer fakePlayer = (FakePlayer)this.harvester.get();
                BlockState newState = BlockTools.placeStackAt((PlayerEntity)fakePlayer, (ItemStack)consumedStack, (World)destWorld, (BlockPos)destPos, (BlockState)srcState);
                if (newState == null) {
                    return;
                }
                destWorld.func_180501_a(destPos, newState, 3);
                if (!ItemStack.func_77989_b((ItemStack)consumedStack, (ItemStack)takeableItem.peek())) {
                    if (!consumedStack.func_190926_b()) {
                        if (!(consumedStack = takeableItem.takeAndReplace(consumedStack)).func_190926_b() && !(consumedStack = this.insertItem(consumedStack)).func_190926_b()) {
                            this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), consumedStack));
                        }
                    } else {
                        takeableItem.take();
                    }
                }
                if (!this.silent) {
                    SoundType soundType = newState.func_177230_c().getSoundType(newState, (IWorldReader)destWorld, destPos, (Entity)fakePlayer);
                    this.playPlaceSoundSafe(soundType, destWorld, newState, destPos.func_177958_n(), destPos.func_177956_o(), destPos.func_177952_p());
                }
                h.consumeEnergy((long)rfNeeded);
            }
        });
    }

    private double getDimensionCostFactor(World world, World destWorld) {
        return destWorld.func_201675_m().func_186058_p().func_186068_a() == world.func_201675_m().func_186058_p().func_186068_a() ? 1.0 : (Double)BuilderConfiguration.dimensionCostFactor.get();
    }

    private boolean consumeEntityEnergy(int rfNeeded, int rfNeededPlayer, Entity entity) {
        return (Boolean)this.energyHandler.map(h -> {
            long rf;
            int rfn = entity instanceof PlayerEntity ? rfNeededPlayer : rfNeeded;
            if ((long)rfn > (rf = h.getEnergy())) {
                return true;
            }
            h.consumeEnergy((long)rfn);
            return false;
        }).orElse((Object)false);
    }

    private void moveEntities(World world, int x, int y, int z, World destWorld, int destX, int destY, int destZ) {
        float factor = ((Float)this.infusableHandler.map(IInfusable::getInfusedFactor).orElse((Object)Float.valueOf(0.0f))).floatValue();
        int rfNeeded = (int)((double)((Integer)BuilderConfiguration.builderRfPerEntity.get()).intValue() * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - factor) / 4.0);
        int rfNeededPlayer = (int)((double)((Integer)BuilderConfiguration.builderRfPerPlayer.get()).intValue() * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - factor) / 4.0);
        List entities = world.func_72839_b(null, new AxisAlignedBB((double)x - 0.1, (double)y - 0.1, (double)z - 0.1, (double)x + 1.1, (double)y + 1.1, (double)z + 1.1));
        for (Entity entity : entities) {
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            double newX = (double)destX + (entity.func_226277_ct_() - (double)x);
            double newY = (double)destY + (entity.func_226278_cu_() - (double)y);
            double newZ = (double)destZ + (entity.func_226281_cx_() - (double)z);
            this.teleportEntity(world, destWorld, entity, newX, newY, newZ);
        }
    }

    private void swapEntities(World world, int x, int y, int z, World destWorld, int destX, int destY, int destZ) {
        double newZ;
        double newY;
        double newX;
        float factor = ((Float)this.infusableHandler.map(IInfusable::getInfusedFactor).orElse((Object)Float.valueOf(0.0f))).floatValue();
        int rfNeeded = (int)((double)((Integer)BuilderConfiguration.builderRfPerEntity.get()).intValue() * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - factor) / 4.0);
        int rfNeededPlayer = (int)((double)((Integer)BuilderConfiguration.builderRfPerPlayer.get()).intValue() * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - factor) / 4.0);
        List entitiesSrc = world.func_72839_b(null, new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
        List entitiesDst = destWorld.func_72839_b(null, new AxisAlignedBB((double)destX, (double)destY, (double)destZ, (double)(destX + 1), (double)(destY + 1), (double)(destZ + 1)));
        for (Entity entity : entitiesSrc) {
            if (!this.isEntityInBlock(x, y, z, entity)) continue;
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            newX = (double)destX + (entity.func_226277_ct_() - (double)x);
            newY = (double)destY + (entity.func_226278_cu_() - (double)y);
            newZ = (double)destZ + (entity.func_226281_cx_() - (double)z);
            this.teleportEntity(world, destWorld, entity, newX, newY, newZ);
        }
        for (Entity entity : entitiesDst) {
            if (!this.isEntityInBlock(destX, destY, destZ, entity)) continue;
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            newX = (double)x + (entity.func_226277_ct_() - (double)destX);
            newY = (double)y + (entity.func_226278_cu_() - (double)destY);
            newZ = (double)z + (entity.func_226281_cx_() - (double)destZ);
            this.teleportEntity(destWorld, world, entity, newX, newY, newZ);
        }
    }

    private void teleportEntity(World world, World destWorld, Entity entity, double newX, double newY, double newZ) {
        TeleportationTools.teleportEntity((Entity)entity, (World)destWorld, (double)newX, (double)newY, (double)newZ, null);
    }

    private boolean isEntityInBlock(int x, int y, int z, Entity entity) {
        return entity.func_226277_ct_() >= (double)x && entity.func_226277_ct_() < (double)(x + 1) && entity.func_226278_cu_() >= (double)y && entity.func_226278_cu_() < (double)(y + 1) && entity.func_226281_cx_() >= (double)z && entity.func_226281_cx_() < (double)(z + 1);
    }

    private void moveBlock(World srcWorld, BlockPos srcPos, World destWorld, BlockPos destPos, int rotMode) {
        Block oldDestBlock;
        BlockState oldDestState = destWorld.func_180495_p(destPos);
        if (BuilderTileEntity.isEmpty(oldDestState, oldDestBlock = oldDestState.func_177230_c())) {
            Block srcBlock;
            BlockState srcState = srcWorld.func_180495_p(srcPos);
            if (BuilderTileEntity.isEmpty(srcState, srcBlock = srcState.func_177230_c())) {
                return;
            }
            TileEntity srcTileEntity = srcWorld.func_175625_s(srcPos);
            BlockInformation srcInformation = BuilderTileEntity.getBlockInformation((PlayerEntity)this.harvester.get(), srcWorld, srcPos, srcBlock, srcTileEntity);
            if (srcInformation.getBlockLevel() == 2) {
                return;
            }
            if (!((Boolean)this.energyHandler.map(h -> {
                long rf = h.getEnergy();
                float factor = ((Float)this.infusableHandler.map(IInfusable::getInfusedFactor).orElse((Object)Float.valueOf(0.0f))).floatValue();
                int rfNeeded = (int)((double)((Integer)BuilderConfiguration.builderRfPerOperation.get()).intValue() * this.getDimensionCostFactor(srcWorld, destWorld) * srcInformation.getCostFactor() * (double)(4.0f - factor) / 4.0);
                if ((long)rfNeeded > rf) {
                    return false;
                }
                h.consumeEnergy((long)rfNeeded);
                return true;
            }).orElse((Object)false)).booleanValue()) {
                return;
            }
            CompoundNBT tc = null;
            if (srcTileEntity != null) {
                tc = new CompoundNBT();
                srcTileEntity.func_189515_b(tc);
                srcWorld.func_175713_t(srcPos);
            }
            this.clearBlock(srcWorld, srcPos);
            destWorld.func_180501_a(destPos, srcState, 3);
            if (srcTileEntity != null && tc != null) {
                this.setTileEntityNBT(destWorld, tc, destPos, srcState);
            }
            if (!this.silent) {
                SoundType srcSoundType = srcBlock.getSoundType(srcState, (IWorldReader)srcWorld, srcPos, null);
                this.playBreakSoundSafe(srcSoundType, srcWorld, srcState, srcPos.func_177958_n(), srcPos.func_177956_o(), srcPos.func_177952_p());
                SoundType dstSoundtype = srcBlock.getSoundType(srcState, (IWorldReader)destWorld, destPos, null);
                this.playPlaceSoundSafe(dstSoundtype, destWorld, srcState, destPos.func_177958_n(), destPos.func_177956_o(), destPos.func_177952_p());
            }
        }
    }

    private void setTileEntityNBT(World destWorld, CompoundNBT tc, BlockPos destpos, BlockState newDestState) {
        tc.func_74768_a("x", destpos.func_177958_n());
        tc.func_74768_a("y", destpos.func_177956_o());
        tc.func_74768_a("z", destpos.func_177952_p());
    }

    private void swapBlock(World srcWorld, BlockPos srcPos, World destWorld, BlockPos dstPos) {
        BlockState oldSrcState = srcWorld.func_180495_p(srcPos);
        Block srcBlock = oldSrcState.func_177230_c();
        TileEntity srcTileEntity = srcWorld.func_175625_s(srcPos);
        BlockState oldDstState = destWorld.func_180495_p(dstPos);
        Block dstBlock = oldDstState.func_177230_c();
        TileEntity dstTileEntity = destWorld.func_175625_s(dstPos);
        if (BuilderTileEntity.isEmpty(oldSrcState, srcBlock) && BuilderTileEntity.isEmpty(oldDstState, dstBlock)) {
            return;
        }
        BlockInformation srcInformation = BuilderTileEntity.getBlockInformation((PlayerEntity)this.harvester.get(), srcWorld, srcPos, srcBlock, srcTileEntity);
        if (srcInformation.getBlockLevel() == 2) {
            return;
        }
        BlockInformation dstInformation = BuilderTileEntity.getBlockInformation((PlayerEntity)this.harvester.get(), destWorld, dstPos, dstBlock, dstTileEntity);
        if (dstInformation.getBlockLevel() == 2) {
            return;
        }
        if (!((Boolean)this.energyHandler.map(h -> {
            long rf = h.getEnergy();
            float factor = ((Float)this.infusableHandler.map(IInfusable::getInfusedFactor).orElse((Object)Float.valueOf(0.0f))).floatValue();
            int rfNeeded = (int)((double)((Integer)BuilderConfiguration.builderRfPerOperation.get()).intValue() * this.getDimensionCostFactor(srcWorld, destWorld) * srcInformation.getCostFactor() * (double)(4.0f - factor) / 4.0);
            if ((long)(rfNeeded += (int)((double)((Integer)BuilderConfiguration.builderRfPerOperation.get()).intValue() * this.getDimensionCostFactor(srcWorld, destWorld) * dstInformation.getCostFactor() * (double)(4.0f - factor) / 4.0)) > rf) {
                return false;
            }
            h.consumeEnergy((long)rfNeeded);
            return true;
        }).orElse((Object)false)).booleanValue()) {
            return;
        }
        srcWorld.func_175713_t(srcPos);
        srcWorld.func_175656_a(srcPos, Blocks.field_150350_a.func_176223_P());
        destWorld.func_175713_t(dstPos);
        destWorld.func_175656_a(dstPos, Blocks.field_150350_a.func_176223_P());
        BlockState newDstState = oldSrcState;
        destWorld.func_180501_a(dstPos, newDstState, 3);
        if (srcTileEntity != null) {
            srcTileEntity.func_145829_t();
            destWorld.func_175690_a(dstPos, srcTileEntity);
            srcTileEntity.func_70296_d();
            destWorld.func_184138_a(dstPos, newDstState, newDstState, 3);
        }
        BlockState newSrcState = oldDstState;
        srcWorld.func_180501_a(srcPos, newSrcState, 3);
        if (dstTileEntity != null) {
            dstTileEntity.func_145829_t();
            srcWorld.func_175690_a(srcPos, dstTileEntity);
            dstTileEntity.func_70296_d();
            srcWorld.func_184138_a(srcPos, newSrcState, newSrcState, 3);
        }
        if (!this.silent) {
            SoundType dstSoundType;
            SoundType srcSoundType;
            if (!BuilderTileEntity.isEmpty(oldSrcState, srcBlock)) {
                srcSoundType = srcBlock.getSoundType(oldSrcState, (IWorldReader)srcWorld, srcPos, null);
                this.playBreakSoundSafe(srcSoundType, srcWorld, oldSrcState, srcPos.func_177958_n(), srcPos.func_177956_o(), srcPos.func_177952_p());
                dstSoundType = srcBlock.getSoundType(oldSrcState, (IWorldReader)destWorld, dstPos, null);
                this.playPlaceSoundSafe(dstSoundType, destWorld, oldSrcState, dstPos.func_177958_n(), dstPos.func_177956_o(), dstPos.func_177952_p());
            }
            if (!BuilderTileEntity.isEmpty(oldDstState, dstBlock)) {
                srcSoundType = dstBlock.getSoundType(oldDstState, (IWorldReader)destWorld, dstPos, null);
                this.playBreakSoundSafe(srcSoundType, destWorld, oldDstState, dstPos.func_177958_n(), dstPos.func_177956_o(), dstPos.func_177952_p());
                dstSoundType = dstBlock.getSoundType(oldDstState, (IWorldReader)srcWorld, srcPos, null);
                this.playPlaceSoundSafe(dstSoundType, srcWorld, oldDstState, srcPos.func_177958_n(), srcPos.func_177956_o(), srcPos.func_177952_p());
            }
        }
    }

    private BlockPos sourceToDest(BlockPos source) {
        return this.rotate(source).func_177982_a(this.projDx, this.projDy, this.projDz);
    }

    private BlockPos rotate(BlockPos c) {
        switch (this.rotate) {
            case 0: {
                return c;
            }
            case 1: {
                return new BlockPos(-c.func_177952_p(), c.func_177956_o(), c.func_177958_n());
            }
            case 2: {
                return new BlockPos(-c.func_177958_n(), c.func_177956_o(), -c.func_177952_p());
            }
            case 3: {
                return new BlockPos(c.func_177952_p(), c.func_177956_o(), -c.func_177958_n());
            }
        }
        return c;
    }

    private void sourceToDest(BlockPos source, BlockPos.Mutable dest) {
        this.rotate(source, dest);
        dest.func_181079_c(dest.func_177958_n() + this.projDx, dest.func_177956_o() + this.projDy, dest.func_177952_p() + this.projDz);
    }

    private void rotate(BlockPos c, BlockPos.Mutable dest) {
        switch (this.rotate) {
            case 0: {
                dest.func_189533_g((Vec3i)c);
                break;
            }
            case 1: {
                dest.func_181079_c(-c.func_177952_p(), c.func_177956_o(), c.func_177958_n());
                break;
            }
            case 2: {
                dest.func_181079_c(-c.func_177958_n(), c.func_177956_o(), -c.func_177952_p());
                break;
            }
            case 3: {
                dest.func_181079_c(c.func_177952_p(), c.func_177956_o(), -c.func_177958_n());
            }
        }
    }

    private void restartScan() {
        this.lastError = null;
        this.chunkUnload();
        if (this.loopMode || this.isMachineEnabled() && this.scan == null) {
            if (this.getCardType() == ShapeCardType.CARD_SPACE) {
                this.calculateBox();
                this.scan = this.minBox;
            } else if (this.getCardType() != ShapeCardType.CARD_UNKNOWN) {
                this.calculateBoxShaped();
                this.scan = new BlockPos(this.minBox.func_177958_n(), this.maxBox.func_177956_o(), this.minBox.func_177952_p());
            }
            this.cachedBlocks = null;
            this.cachedChunk = null;
            this.cachedVoidableBlocks.clear();
        } else {
            this.scan = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.chunkUnload();
    }

    private void chunkUnload() {
    }

    private boolean chunkLoad(int x, int z) {
        int cx = x >> 4;
        int cz = z >> 4;
        if (WorldTools.isLoaded((World)this.field_145850_b, (BlockPos)new BlockPos(x, 0, z))) {
            return true;
        }
        if (((Boolean)BuilderConfiguration.quarryChunkloads.get()).booleanValue()) {
            ChunkPos pair = new ChunkPos(cx, cz);
            if (pair.equals((Object)this.forcedChunk)) {
                return true;
            }
            return true;
        }
        return false;
    }

    public static void setScanLocationClient(BlockPos tePos, BlockPos scanPos) {
        scanLocClient.put(tePos, (Pair<Long, BlockPos>)Pair.of((Object)System.currentTimeMillis(), (Object)scanPos));
    }

    public static Map<BlockPos, Pair<Long, BlockPos>> getScanLocClient() {
        if (scanLocClient.isEmpty()) {
            return scanLocClient;
        }
        HashMap<BlockPos, Pair<Long, BlockPos>> scans = new HashMap<BlockPos, Pair<Long, BlockPos>>();
        long time = System.currentTimeMillis();
        for (Map.Entry<BlockPos, Pair<Long, BlockPos>> entry : scanLocClient.entrySet()) {
            if ((Long)entry.getValue().getKey() + 10000L <= time) continue;
            scans.put(entry.getKey(), entry.getValue());
        }
        scanLocClient = scans;
        return scanLocClient;
    }

    private void nextLocation() {
        if (this.scan != null) {
            int x = this.scan.func_177958_n();
            int y = this.scan.func_177956_o();
            int z = this.scan.func_177952_p();
            if (this.getCardType() == ShapeCardType.CARD_SPACE) {
                this.nextLocationNormal(x, y, z);
            } else {
                this.nextLocationQuarry(x, y, z);
            }
        }
    }

    private void nextLocationQuarry(int x, int y, int z) {
        if (x >= this.maxBox.func_177958_n() || (x + 1) % 16 == 0) {
            if (z >= this.maxBox.func_177952_p() || (z + 1) % 16 == 0) {
                if (y <= this.minBox.func_177956_o()) {
                    if (x < this.maxBox.func_177958_n()) {
                        z = z >> 4 << 4;
                        y = this.maxBox.func_177956_o();
                        this.scan = new BlockPos(++x, y, z);
                    } else if (z < this.maxBox.func_177952_p()) {
                        x = this.minBox.func_177958_n();
                        y = this.maxBox.func_177956_o();
                        this.scan = new BlockPos(x, y, ++z);
                    } else {
                        this.restartScan();
                    }
                } else {
                    this.scan = new BlockPos(x >> 4 << 4, y - 1, z >> 4 << 4);
                }
            } else {
                this.scan = new BlockPos(x >> 4 << 4, y, z + 1);
            }
        } else {
            this.scan = new BlockPos(x + 1, y, z);
        }
    }

    private void nextLocationNormal(int x, int y, int z) {
        if (x >= this.maxBox.func_177958_n()) {
            if (z >= this.maxBox.func_177952_p()) {
                if (y >= this.maxBox.func_177956_o()) {
                    if (this.mode != 2 || this.isShapeCard()) {
                        this.restartScan();
                    } else {
                        this.scan = null;
                    }
                } else {
                    this.scan = new BlockPos(this.minBox.func_177958_n(), y + 1, this.minBox.func_177952_p());
                }
            } else {
                this.scan = new BlockPos(this.minBox.func_177958_n(), y, z + 1);
            }
        } else {
            this.scan = new BlockPos(x + 1, y, z);
        }
    }

    private void refreshSettings() {
        this.clearSupportBlocks();
        this.cachedBlocks = null;
        this.cachedChunk = null;
        this.cachedVoidableBlocks.clear();
        this.boxValid = false;
        this.scan = null;
        this.cardType = ShapeCardType.CARD_UNKNOWN;
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("overflowItems")) {
            ListNBT overflowItemsNbt = tagCompound.func_150295_c("overflowItems", 10);
            this.overflowItems.clear();
            for (INBT overflowNbt : overflowItemsNbt) {
                this.overflowItems.add(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)overflowNbt)));
            }
        }
    }

    protected void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        if (!info.func_74764_b("rsMode")) {
            this.rsMode = RedstoneMode.REDSTONE_ONREQUIRED;
        }
        this.lastError = info.func_74764_b("lastError") ? info.func_74779_i("lastError") : null;
        this.mode = info.func_74762_e("mode");
        this.anchor = info.func_74762_e("anchor");
        this.rotate = info.func_74762_e("rotate");
        this.silent = info.func_74767_n("silent");
        this.supportMode = info.func_74767_n("support");
        this.entityMode = info.func_74767_n("entityMode");
        this.loopMode = info.func_74767_n("loopMode");
        this.waitMode = info.func_74764_b("waitMode") ? info.func_74767_n("waitMode") : true;
        this.hilightMode = info.func_74767_n("hilightMode");
        this.scan = BlockPosTools.read((CompoundNBT)info, (String)"scan");
        this.minBox = BlockPosTools.read((CompoundNBT)info, (String)"minBox");
        this.maxBox = BlockPosTools.read((CompoundNBT)info, (String)"maxBox");
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        if (!this.overflowItems.isEmpty()) {
            ListNBT overflowItemsNbt = new ListNBT();
            for (ItemStack overflow : this.overflowItems.getList()) {
                overflowItemsNbt.add((Object)overflow.func_77955_b(new CompoundNBT()));
            }
            tagCompound.func_218657_a("overflowItems", (INBT)overflowItemsNbt);
        }
        if (this.lastError != null) {
            tagCompound.func_74778_a("lastError", this.lastError);
        }
        tagCompound.func_74768_a("mode", this.mode);
        tagCompound.func_74768_a("anchor", this.anchor);
        tagCompound.func_74768_a("rotate", this.rotate);
        tagCompound.func_74757_a("silent", this.silent);
        tagCompound.func_74757_a("support", this.supportMode);
        tagCompound.func_74757_a("entityMode", this.entityMode);
        tagCompound.func_74757_a("loopMode", this.loopMode);
        tagCompound.func_74757_a("waitMode", this.waitMode);
        tagCompound.func_74757_a("hilightMode", this.hilightMode);
        BlockPosTools.write((CompoundNBT)tagCompound, (String)"scan", (BlockPos)this.scan);
        BlockPosTools.write((CompoundNBT)tagCompound, (String)"minBox", (BlockPos)this.minBox);
        BlockPosTools.write((CompoundNBT)tagCompound, (String)"maxBox", (BlockPos)this.maxBox);
        return tagCompound;
    }

    protected void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT infoTag = this.getOrCreateInfo(tagCompound);
        if (this.lastError != null) {
            infoTag.func_74778_a("lastError", this.lastError);
        }
        infoTag.func_74768_a("mode", this.mode);
        infoTag.func_74768_a("anchor", this.anchor);
        infoTag.func_74768_a("rotate", this.rotate);
        infoTag.func_74757_a("silent", this.silent);
        infoTag.func_74757_a("support", this.supportMode);
        infoTag.func_74757_a("entityMode", this.entityMode);
        infoTag.func_74757_a("loopMode", this.loopMode);
        infoTag.func_74757_a("waitMode", this.waitMode);
        infoTag.func_74757_a("hilightMode", this.hilightMode);
        BlockPosTools.write((CompoundNBT)infoTag, (String)"scan", (BlockPos)this.scan);
        BlockPosTools.write((CompoundNBT)infoTag, (String)"minBox", (BlockPos)this.minBox);
        BlockPosTools.write((CompoundNBT)infoTag, (String)"maxBox", (BlockPos)this.maxBox);
    }

    public static int getCurrentLevelClientSide() {
        return currentLevel;
    }

    public int getCurrentLevel() {
        return this.scan == null ? -1 : this.scan.func_177956_o();
    }

    public boolean execute(PlayerEntity playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETROTATE.equals(command)) {
            this.setRotate(Integer.parseInt((String)params.get(ChoiceLabel.PARAM_CHOICE)) / 90);
            return true;
        }
        if (CMD_SETANCHOR.equals(command)) {
            this.setAnchor((Integer)params.get(PARAM_ANCHOR_INDEX));
            return true;
        }
        if (CMD_SETMODE.equals(command)) {
            this.setMode((Integer)params.get(ChoiceLabel.PARAM_CHOICE_IDX));
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if (PacketGetHudLog.CMD_GETHUDLOG.equals(command)) {
            return type.convert(this.getHudLog());
        }
        return rc;
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if (PacketGetHudLog.CLIENTCMD_GETHUDLOG.equals(command)) {
            this.clientHudLog = Type.STRING.convert(list);
            return true;
        }
        return false;
    }

    public void onReplaced(World world, BlockPos pos, BlockState state, BlockState newstate) {
        if (state.func_177230_c() == newstate.func_177230_c()) {
            return;
        }
        if (this.hasSupportMode()) {
            this.clearSupportBlocks();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
    }

    public void rotateBlock(Rotation axis) {
        super.rotateBlock(axis);
        if (!this.field_145850_b.field_72995_K && this.hasSupportMode()) {
            this.clearSupportBlocks();
            this.resetBox();
        }
    }

    private NoDirectionItemHander createItemHandler() {
        return new NoDirectionItemHander(this, (ContainerFactory)CONTAINER_FACTORY.get()){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                this.checkShapeCard(slot, stack);
                return super.insertItem(slot, stack, simulate);
            }

            public void setInventorySlotContents(int stackLimit, int index, ItemStack stack) {
                this.checkShapeCard(index, stack);
                super.setInventorySlotContents(stackLimit, index, stack);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                this.checkShapeCard(slot, ItemStack.field_190927_a);
                return super.extractItem(slot, amount, simulate);
            }

            public ItemStack decrStackSize(int index, int amount) {
                this.checkShapeCard(index, ItemStack.field_190927_a);
                return super.decrStackSize(index, amount);
            }

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                this.checkShapeCard(slot, stack);
                super.setStackInSlot(slot, stack);
            }

            protected void onUpdate(int index) {
                super.onUpdate(index);
                if (index == 1) {
                    BuilderTileEntity.this.filterCache.clear();
                }
            }

            private void checkShapeCard(int index, ItemStack newStack) {
                ItemStack stack = this.getStackInSlot(index);
                if (index == 0 && (stack.func_190926_b() && !newStack.func_190926_b() || !stack.func_190926_b() && newStack.func_190926_b())) {
                    BuilderTileEntity.this.refreshSettings();
                }
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.automationItemHandler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        if (cap == CapabilityInfusable.INFUSABLE_CAPABILITY) {
            return this.infusableHandler.cast();
        }
        if (cap == CapabilityModuleSupport.MODULE_CAPABILITY) {
            return this.moduleSupportHandler.cast();
        }
        return super.getCapability(cap, facing);
    }

    private /* synthetic */ Boolean lambda$collectItems$10(float factor, GenericEnergyStorage h) {
        long rf = h.getEnergyStored();
        float area = (this.maxBox.func_177958_n() - this.minBox.func_177958_n() + 1) * (this.maxBox.func_177956_o() - this.minBox.func_177956_o() + 1) * (this.maxBox.func_177952_p() - this.minBox.func_177952_p() + 1);
        float infusedFactor = (4.0f - factor) / 4.0f;
        int rfNeeded = (int)((Double)BuilderConfiguration.collectRFPerTickPerArea.get() * (double)area * (double)infusedFactor) * (Integer)BuilderConfiguration.collectTimer.get();
        if ((long)rfNeeded > rf) {
            return false;
        }
        h.consumeEnergy((long)rfNeeded);
        return true;
    }

    static {
        VALUE_WAIT = new Key("wait", Type.BOOLEAN);
        VALUE_LOOP = new Key("loop", Type.BOOLEAN);
        VALUE_HILIGHT = new Key("hilight", Type.BOOLEAN);
        VALUE_SUPPORT = new Key("support", Type.BOOLEAN);
        VALUE_SILENT = new Key("silent", Type.BOOLEAN);
        VALUE_ENTITIES = new Key("entities", Type.BOOLEAN);
        random = new Random();
        lastTime = 0L;
    }

    private static class TakeableItem {
        private final IItemHandler itemHandler;
        private final IInventory inventory;
        private final int slot;
        private final ItemStack peekStack;
        public static final TakeableItem EMPTY = new TakeableItem();

        private TakeableItem() {
            this.itemHandler = null;
            this.inventory = null;
            this.slot = -1;
            this.peekStack = ItemStack.field_190927_a;
        }

        public TakeableItem(IItemHandler itemHandler, int slot) {
            Validate.inclusiveBetween((long)0L, (long)(itemHandler.getSlots() - 1), (long)slot);
            this.itemHandler = itemHandler;
            this.inventory = null;
            this.slot = slot;
            this.peekStack = itemHandler.extractItem(slot, 1, true);
        }

        public TakeableItem(IInventory inventory, int slot) {
            Validate.inclusiveBetween((long)0L, (long)(inventory.func_70302_i_() - 1), (long)slot);
            this.itemHandler = null;
            this.inventory = inventory;
            this.slot = slot;
            this.peekStack = inventory.func_70301_a(slot).func_77946_l();
            this.peekStack.func_190920_e(1);
        }

        public ItemStack peek() {
            return this.peekStack.func_77946_l();
        }

        public void take() {
            if (this.itemHandler != null) {
                this.itemHandler.extractItem(this.slot, 1, false);
            } else if (this.slot != -1) {
                this.inventory.func_70298_a(this.slot, 1);
            }
        }

        public ItemStack takeAndReplace(ItemStack replacement) {
            if (this.itemHandler != null) {
                this.itemHandler.extractItem(this.slot, 1, false);
                return this.itemHandler.insertItem(this.slot, replacement, false);
            }
            if (this.slot != -1) {
                this.inventory.func_70298_a(this.slot, 1);
                if (this.inventory.func_94041_b(this.slot, replacement) && this.inventory.func_70301_a(this.slot).func_190926_b()) {
                    this.inventory.func_70299_a(this.slot, replacement);
                    return ItemStack.field_190927_a;
                }
            }
            return replacement;
        }
    }
}

