/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.informationscreen.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.client.HudRenderHelper;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.modules.informationscreen.blocks.DefaultPowerInformationScreenInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.text.TextFormatting;

public class DefaultPowerInformationRenderer {
    private static DecimalFormat format = new DecimalFormat("#.###");

    public static void renderGraphical(MatrixStack matrixStack, IRenderTypeBuffer buffer, TypedMap data, Direction orientation, double x, double y, double z, double scale) {
        if (data == null || data.size() == 0) {
            return;
        }
        long energy = data.getOptional(DefaultPowerInformationScreenInfo.ENERGY).orElse(0L);
        long maxEnergy = data.getOptional(DefaultPowerInformationScreenInfo.MAXENERGY).orElse(0L);
        GlStateManager.func_227626_N_();
        GlStateManager.func_227688_c_((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        GlStateManager.func_227689_c_((float)(-DefaultPowerInformationRenderer.getHudAngle(orientation)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_227688_c_((float)0.0f, (float)-0.25f, (float)0.46249998f);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205108_b();
        GlStateManager.func_227737_l_();
        GlStateManager.func_227722_g_();
        if (maxEnergy > 0L) {
            GlStateManager.func_227688_c_((float)-0.5f, (float)0.5f, (float)0.07f);
            float f3 = 0.0075f;
            GlStateManager.func_227632_a_((double)((double)f3 * scale), (double)((double)(-f3) * scale), (double)f3);
            GlStateManager.func_227636_a_((float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            long pct = energy * 100L / maxEnergy;
            for (int i = 0; i < 100; i += 5) {
                int col = (long)i < pct ? DefaultPowerInformationRenderer.getPercentageColor(i) : -15658735;
                RenderHelper.drawFlatBox((int)16, (int)((int)(100.0 - (double)i * 0.8 - 13.0)), (int)88, (int)((int)(100.0 - (double)i * 0.8 + 3.0 - 13.0)), (int)col, (int)col);
            }
        }
        Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205109_c();
        GlStateManager.func_227716_f_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227676_b_((int)770, (int)771);
        GlStateManager.func_227627_O_();
    }

    public static void renderDefault(MatrixStack matrixStack, IRenderTypeBuffer buffer, TypedMap data, Direction orientation, double x, double y, double z, double scale) {
        List<String> log = DefaultPowerInformationRenderer.getLog(data);
        HudRenderHelper.HudPlacement hudPlacement = HudRenderHelper.HudPlacement.HUD_FRONT;
        HudRenderHelper.HudOrientation hudOrientation = HudRenderHelper.HudOrientation.HUD_SOUTH;
        HudRenderHelper.renderHud((MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, log, (HudRenderHelper.HudPlacement)hudPlacement, (HudRenderHelper.HudOrientation)hudOrientation, (Direction)orientation, (double)(x - (double)orientation.func_82601_c() * 0.95), (double)y, (double)(z - (double)orientation.func_82599_e() * 0.95), (float)((float)(1.0 + scale)));
    }

    private static List<String> getLog(TypedMap data) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        if (data != null && data.size() > 0) {
            long energy = data.getOptional(DefaultPowerInformationScreenInfo.ENERGY).orElse(0L);
            long maxEnergy = data.getOptional(DefaultPowerInformationScreenInfo.MAXENERGY).orElse(0L);
            list.add(TextFormatting.BLUE + " RF: " + TextFormatting.WHITE + DefaultPowerInformationRenderer.formatPower(energy));
            list.add(TextFormatting.BLUE + " Max: " + TextFormatting.WHITE + DefaultPowerInformationRenderer.formatPower(maxEnergy));
        } else {
            list.add(TextFormatting.RED + " Not a powercell");
            list.add(TextFormatting.RED + " or anything that");
            list.add(TextFormatting.RED + " supports power");
        }
        return list;
    }

    public static String formatPower(long l) {
        if (l < 100000L) {
            return Long.toString(l);
        }
        if (l < 10000000L) {
            Double d = (double)l / 1000.0;
            return format.format(d) + "K";
        }
        if (l < 10000000000L) {
            Double d = (double)l / 1000000.0;
            return format.format(d) + "M";
        }
        Double d = (double)l / 1.0E9;
        return format.format(d) + "G";
    }

    public static float getHudAngle(Direction orientation) {
        float f3 = 0.0f;
        if (orientation != null) {
            switch (orientation) {
                case NORTH: {
                    f3 = 180.0f;
                    break;
                }
                case WEST: {
                    f3 = 90.0f;
                    break;
                }
                case EAST: {
                    f3 = -90.0f;
                    break;
                }
                default: {
                    f3 = 0.0f;
                }
            }
        }
        return f3;
    }

    public static int getPercentageColor(int i) {
        int col = i < 30 ? -16711936 : (i < 40 ? -14492416 : (i < 50 ? -12272896 : (i < 60 ? -10053376 : (i < 70 ? -7833856 : (i < 80 ? -5614336 : (i < 90 ? -3394816 : -1175296))))));
        return col;
    }
}

