/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.impl;

import com.feed_the_beast.mods.ftbchunks.FTBChunks;
import com.feed_the_beast.mods.ftbchunks.FTBChunksConfig;
import com.feed_the_beast.mods.ftbchunks.FTBTeamsIntegration;
import com.feed_the_beast.mods.ftbchunks.api.ChunkDimPos;
import com.feed_the_beast.mods.ftbchunks.api.ClaimResult;
import com.feed_the_beast.mods.ftbchunks.api.ClaimResults;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunk;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunkEvent;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunkGroup;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunkManager;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunkPlayerData;
import com.feed_the_beast.mods.ftbchunks.api.PrivacyMode;
import com.feed_the_beast.mods.ftbchunks.api.Waypoint;
import com.feed_the_beast.mods.ftbchunks.api.WaypointType;
import com.feed_the_beast.mods.ftbchunks.impl.AllyMode;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkGroupImpl;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkImpl;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkManagerImpl;
import com.feed_the_beast.mods.ftbguilibrary.utils.MathUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.util.UUIDTypeAdapter;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;

public class ClaimedChunkPlayerDataImpl
implements ClaimedChunkPlayerData {
    public final ClaimedChunkManagerImpl manager;
    public final Path file;
    public boolean shouldSave;
    public GameProfile profile;
    public int color;
    private final Map<String, ClaimedChunkGroupImpl> groups;
    public final Set<UUID> allies;
    public PrivacyMode blockBreakMode;
    public PrivacyMode blockInteractMode;
    public final Map<UUID, Waypoint> waypoints;
    public PrivacyMode minimapMode;
    public int prevChunkX = Integer.MAX_VALUE;
    public int prevChunkZ = Integer.MAX_VALUE;
    public String lastChunkID = "";

    public ClaimedChunkPlayerDataImpl(ClaimedChunkManagerImpl m, Path f, UUID id) {
        this.manager = m;
        this.file = f;
        this.shouldSave = false;
        this.profile = new GameProfile(id, "");
        this.color = 0;
        this.groups = new HashMap<String, ClaimedChunkGroupImpl>();
        this.allies = new HashSet<UUID>();
        this.blockBreakMode = PrivacyMode.ALLIES;
        this.blockInteractMode = PrivacyMode.ALLIES;
        this.waypoints = new LinkedHashMap<UUID, Waypoint>();
        this.minimapMode = PrivacyMode.ALLIES;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ClaimedChunkManager getManager() {
        return this.manager;
    }

    @Override
    public GameProfile getProfile() {
        return this.profile;
    }

    @Override
    public int getColor() {
        if (this.color == 0) {
            this.color = MathHelper.func_181758_c((float)MathUtils.RAND.nextFloat(), (float)0.65f, (float)1.0f);
            this.save();
        }
        return 0xFF000000 | this.color;
    }

    @Override
    public Collection<ClaimedChunk> getClaimedChunks() {
        ArrayList<ClaimedChunk> list = new ArrayList<ClaimedChunk>();
        for (ClaimedChunkImpl chunk : this.manager.claimedChunks.values()) {
            if (chunk.playerData != this) continue;
            list.add(chunk);
        }
        return list;
    }

    @Override
    public Collection<ClaimedChunk> getForceLoadedChunks() {
        ArrayList<ClaimedChunk> list = new ArrayList<ClaimedChunk>();
        for (ClaimedChunkImpl chunk : this.manager.claimedChunks.values()) {
            if (chunk.playerData != this || !chunk.isForceLoaded()) continue;
            list.add(chunk);
        }
        return list;
    }

    @Override
    public ClaimedChunkGroupImpl getGroup(String id) {
        if (id.isEmpty()) {
            throw new IllegalArgumentException("Invalid group ID!");
        }
        ClaimedChunkGroupImpl group = this.groups.get(id);
        if (group == null) {
            group = new ClaimedChunkGroupImpl(this, id);
            this.groups.put(id, group);
            this.save();
        }
        return group;
    }

    @Override
    public boolean hasGroup(String id) {
        return this.groups.containsKey(id);
    }

    @Override
    @Nullable
    public ClaimedChunkGroupImpl removeGroup(String id) {
        ClaimedChunkGroupImpl g = this.groups.remove(id);
        if (g != null) {
            this.save();
        }
        return g;
    }

    @Override
    public Collection<ClaimedChunkGroup> getGroups() {
        return this.groups.values();
    }

    @Override
    public ClaimResult claim(CommandSource source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunkImpl chunk = this.manager.claimedChunks.get(pos);
        if (chunk != null) {
            return ClaimResults.ALREADY_CLAIMED;
        }
        if (source.func_197022_f() instanceof ServerPlayerEntity && this.getClaimedChunks().size() >= FTBChunksConfig.getMaxClaimedChunks((ServerPlayerEntity)source.func_197022_f())) {
            return ClaimResults.NOT_ENOUGH_POWER;
        }
        chunk = new ClaimedChunkImpl(this, pos);
        ClaimResult r = new ClaimedChunkEvent.Claim.Check(source, chunk).postAndGetResult();
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        this.manager.claimedChunks.put(pos, chunk);
        new ClaimedChunkEvent.Claim.Done(source, chunk).postAndGetResult();
        this.save();
        return chunk;
    }

    @Override
    public ClaimResult unclaim(CommandSource source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunkImpl chunk = this.manager.claimedChunks.get(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (chunk.playerData != this && !source.func_197034_c(2) && !source.func_197028_i().func_71264_H()) {
            return ClaimResults.NOT_OWNER;
        }
        ClaimResult r = new ClaimedChunkEvent.Unclaim.Check(source, chunk).postAndGetResult();
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        if (chunk.isForceLoaded()) {
            chunk.setForceLoadedTime(null);
            chunk.postSetForceLoaded(false);
            new ClaimedChunkEvent.Unload.Done(source, chunk).postAndGetResult();
        }
        this.manager.claimedChunks.remove(pos);
        new ClaimedChunkEvent.Unclaim.Done(source, chunk).postAndGetResult();
        chunk.playerData.save();
        return chunk;
    }

    @Override
    public ClaimResult load(CommandSource source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunkImpl chunk = this.manager.claimedChunks.get(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (chunk.playerData != this && !source.func_197034_c(2) && !source.func_197028_i().func_71264_H()) {
            return ClaimResults.NOT_OWNER;
        }
        if (chunk.isForceLoaded()) {
            return ClaimResults.ALREADY_LOADED;
        }
        if (source.func_197022_f() instanceof ServerPlayerEntity && this.getForceLoadedChunks().size() >= FTBChunksConfig.getMaxForceLoadedChunks((ServerPlayerEntity)source.func_197022_f())) {
            return ClaimResults.NOT_ENOUGH_POWER;
        }
        ClaimResult r = new ClaimedChunkEvent.Load.Check(source, chunk).postAndGetResult();
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        chunk.setForceLoadedTime(Instant.now());
        chunk.postSetForceLoaded(true);
        new ClaimedChunkEvent.Load.Done(source, chunk).postAndGetResult();
        chunk.playerData.save();
        return chunk;
    }

    @Override
    public ClaimResult unload(CommandSource source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunkImpl chunk = this.manager.claimedChunks.get(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (!(chunk.playerData == this || source.func_197034_c(2) || source.func_197028_i().func_71264_H() || this.isTeamMember(source.func_197022_f()))) {
            return ClaimResults.NOT_OWNER;
        }
        if (!chunk.isForceLoaded()) {
            return ClaimResults.NOT_LOADED;
        }
        ClaimResult r = new ClaimedChunkEvent.Unload.Check(source, chunk).postAndGetResult();
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        chunk.setForceLoadedTime(null);
        chunk.postSetForceLoaded(false);
        new ClaimedChunkEvent.Unload.Done(source, chunk).postAndGetResult();
        chunk.playerData.save();
        return chunk;
    }

    @Override
    public void save() {
        this.shouldSave = true;
    }

    public boolean isTeamMember(@Nullable Entity entity) {
        return entity instanceof ServerPlayerEntity && FTBChunks.teamsMod && FTBTeamsIntegration.isTeamMember(this.getProfile(), ((ServerPlayerEntity)entity).func_146103_bH());
    }

    @Override
    public boolean isAlly(ServerPlayerEntity p) {
        if (FTBChunksConfig.allyMode == AllyMode.FORCED_ALL) {
            return true;
        }
        if (FTBChunksConfig.allyMode == AllyMode.FORCED_NONE) {
            return false;
        }
        if (this.getUuid().equals(p.func_110124_au())) {
            return true;
        }
        if (this.allies.contains(p.func_110124_au())) {
            return true;
        }
        if (this.isTeamMember((Entity)p)) {
            return true;
        }
        return this.getName().equals(p.func_146103_bH().getName());
    }

    public boolean canUse(ServerPlayerEntity p, PrivacyMode mode) {
        if (mode == PrivacyMode.PUBLIC) {
            return true;
        }
        if (p.func_184102_h().func_71264_H()) {
            return true;
        }
        if (mode == PrivacyMode.ALLIES) {
            return this.isAlly(p);
        }
        return false;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("uuid", UUIDTypeAdapter.fromUUID((UUID)this.getUuid()));
        json.addProperty("name", this.getName());
        json.addProperty("color", String.format("#%06X", 0xFFFFFF & this.color));
        JsonObject groupJson = new JsonObject();
        for (ClaimedChunkGroupImpl claimedChunkGroupImpl : this.groups.values()) {
            groupJson.add(claimedChunkGroupImpl.getId(), (JsonElement)claimedChunkGroupImpl.toJson());
        }
        json.add("groups", (JsonElement)groupJson);
        JsonArray alliesJson = new JsonArray();
        for (UUID uUID : this.allies) {
            alliesJson.add(UUIDTypeAdapter.fromUUID((UUID)uUID));
        }
        json.add("allies", (JsonElement)alliesJson);
        json.addProperty("block_break_mode", this.blockBreakMode.name);
        json.addProperty("block_interact_mode", this.blockInteractMode.name);
        json.addProperty("minimap_mode", this.minimapMode.name);
        JsonObject jsonObject = new JsonObject();
        for (ClaimedChunk chunk : this.getClaimedChunks()) {
            String dim = DimensionType.func_212678_a((DimensionType)chunk.getPos().dimension).toString();
            JsonElement e = jsonObject.get(dim);
            if (e == null || e.isJsonNull()) {
                e = new JsonArray();
                jsonObject.add(dim, e);
            }
            JsonObject chunkJson = new JsonObject();
            chunkJson.addProperty("x", (Number)chunk.getPos().x);
            chunkJson.addProperty("z", (Number)chunk.getPos().z);
            chunkJson.addProperty("time", chunk.getTimeClaimed().toString());
            if (chunk.isForceLoaded()) {
                chunkJson.addProperty("force_loaded", chunk.getForceLoadedTime().toString());
            }
            if (chunk.getGroup() != null) {
                chunkJson.addProperty("group", chunk.getGroup().getId());
            }
            e.getAsJsonArray().add((JsonElement)chunkJson);
        }
        json.add("chunks", (JsonElement)jsonObject);
        JsonArray jsonArray = new JsonArray();
        for (Waypoint w : this.waypoints.values()) {
            JsonObject o = new JsonObject();
            o.addProperty("id", UUIDTypeAdapter.fromUUID((UUID)w.id));
            o.addProperty("name", w.name);
            o.addProperty("dimension", DimensionType.func_212678_a((DimensionType)w.dimension).toString());
            o.addProperty("x", (Number)w.x);
            o.addProperty("y", (Number)w.y);
            o.addProperty("z", (Number)w.z);
            o.addProperty("color", String.format("#%06X", 0xFFFFFF & w.color));
            o.addProperty("privacy", w.privacy.name);
            o.addProperty("type", w.type.name().toLowerCase());
            jsonArray.add((JsonElement)o);
        }
        json.add("waypoints", (JsonElement)jsonArray);
        return json;
    }

    public void fromJson(JsonObject json) {
        this.profile = new GameProfile(this.getUuid(), json.get("name").getAsString());
        this.color = 0;
        try {
            this.color = Integer.decode(json.get("color").getAsString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (json.has("groups")) {
            for (Map.Entry entry : json.get("groups").getAsJsonObject().entrySet()) {
                this.getGroup((String)entry.getKey()).fromJson(((JsonElement)entry.getValue()).getAsJsonObject());
            }
        }
        if (json.has("allies")) {
            for (JsonElement e : json.get("allies").getAsJsonArray()) {
                this.allies.add(UUIDTypeAdapter.fromString((String)e.getAsString()));
            }
        }
        if (json.has("block_break_mode")) {
            this.blockBreakMode = PrivacyMode.get(json.get("block_break_mode").getAsString());
        }
        if (json.has("block_interact_mode")) {
            this.blockInteractMode = PrivacyMode.get(json.get("block_interact_mode").getAsString());
        }
        if (json.has("minimap_mode")) {
            this.minimapMode = PrivacyMode.get(json.get("minimap_mode").getAsString());
        }
        if (json.has("chunks")) {
            for (Map.Entry entry : json.get("chunks").getAsJsonObject().entrySet()) {
                DimensionType dimension = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation((String)entry.getKey()));
                if (dimension == null) continue;
                for (JsonElement e : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    JsonObject o = e.getAsJsonObject();
                    int x = o.get("x").getAsInt();
                    int z = o.get("z").getAsInt();
                    ClaimedChunkImpl chunk = new ClaimedChunkImpl(this, new ChunkDimPos(dimension, x, z));
                    if (o.has("time")) {
                        chunk.time = Instant.parse(o.get("time").getAsString());
                    }
                    if (o.has("force_loaded")) {
                        if (o.get("force_loaded").getAsJsonPrimitive().isBoolean()) {
                            chunk.forceLoaded = chunk.time;
                            this.save();
                        } else {
                            chunk.forceLoaded = Instant.parse(o.get("force_loaded").getAsString());
                        }
                    }
                    if (o.has("group")) {
                        chunk.group = this.getGroup(o.get("group").getAsString());
                    }
                    this.manager.claimedChunks.put(chunk.pos, chunk);
                }
            }
        }
        if (json.has("waypoints")) {
            for (JsonElement e : json.get("waypoints").getAsJsonArray()) {
                JsonObject o = e.getAsJsonObject();
                DimensionType dim = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(o.get("dimension").getAsString()));
                if (dim == null) continue;
                Waypoint w = new Waypoint(this, o.has("id") ? UUIDTypeAdapter.fromString((String)o.get("id").getAsString()) : UUID.randomUUID());
                w.dimension = dim;
                w.name = o.get("name").getAsString();
                w.x = o.get("x").getAsInt();
                w.y = o.get("y").getAsInt();
                w.z = o.get("z").getAsInt();
                w.color = 0xFFFFFF;
                if (o.has("color")) {
                    try {
                        w.color = Integer.decode(o.get("color").getAsString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (o.has("privacy")) {
                    w.privacy = PrivacyMode.get(o.get("privacy").getAsString());
                }
                if (o.has("type")) {
                    w.type = WaypointType.valueOf(o.get("type").getAsString().toUpperCase());
                }
                this.waypoints.put(w.id, w);
            }
        } else {
            this.save();
        }
    }

    @Override
    public ITextComponent getDisplayName() {
        ITextComponent component;
        if (FTBChunks.teamsMod && (component = FTBTeamsIntegration.getTeamName(this)) != null) {
            return component;
        }
        return new StringTextComponent(this.getName());
    }
}

