/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.client.map;

import com.feed_the_beast.mods.ftbchunks.client.map.ClientMapDimension;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.dimension.DimensionType;

public class ClientMapManager {
    public static ClientMapManager inst;
    public final UUID serverId;
    public final Path directory;
    public final Map<DimensionType, ClientMapDimension> dimensions;

    public ClientMapManager(UUID id, Path dir) {
        this.serverId = id;
        this.directory = dir;
        this.dimensions = new HashMap<DimensionType, ClientMapDimension>();
    }

    public ClientMapDimension getDimension(DimensionType dim) {
        return this.dimensions.computeIfAbsent(dim, d -> new ClientMapDimension(this, (DimensionType)d));
    }

    public void release() {
        for (ClientMapDimension dimension : this.dimensions.values()) {
            dimension.release();
        }
        this.dimensions.clear();
    }
}

