/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.network;

import java.util.function.Supplier;
import net.blay09.mods.refinedrelocation.filter.CreativeTabFilter;
import net.blay09.mods.refinedrelocation.filter.ModFilter;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageLoginSyncList {
    public static final int TYPE_CREATIVE_TABS = 0;
    public static final int TYPE_MODS = 1;
    private final int type;
    private final String[] values;

    public MessageLoginSyncList(int type, String[] values) {
        this.type = type;
        this.values = values;
    }

    public static void encode(MessageLoginSyncList message, PacketBuffer buf) {
        buf.writeByte(message.type);
        buf.writeShort(message.values.length);
        for (String value : message.values) {
            buf.func_180714_a(value);
        }
    }

    public static MessageLoginSyncList decode(PacketBuffer buf) {
        byte type = buf.readByte();
        String[] values = new String[buf.readShort()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = buf.func_150789_c(Short.MAX_VALUE);
        }
        return new MessageLoginSyncList(type, values);
    }

    public static void handle(MessageLoginSyncList message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (message.type == 0) {
                CreativeTabFilter.creativeTabs = message.values;
            } else if (message.type == 1) {
                ModFilter.setModList(message.values);
            }
        });
        context.setPacketHandled(true);
    }
}

