/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.TypeVisitor;
import org.openzen.zenscript.codemodel.type.TypeVisitorWithContext;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;
import org.openzen.zenscript.codemodel.type.storage.ValueStorageTag;

public class FunctionTypeID
implements TypeID {
    public final FunctionHeader header;
    private final FunctionTypeID normalized;

    public FunctionTypeID(GlobalTypeRegistry registry, FunctionHeader header) {
        this.header = header;
        FunctionHeader normalizedHeader = header.normalize(registry);
        this.normalized = header == normalizedHeader ? this : registry.getFunction(normalizedHeader);
    }

    @Override
    public FunctionTypeID getNormalized() {
        return this.normalized;
    }

    @Override
    public StoredType instance(GenericMapper mapper, StorageTag storage) {
        return mapper.registry.getFunction(mapper.map(this.header)).stored(storage);
    }

    @Override
    public <R> R accept(TypeVisitor<R> visitor) {
        return visitor.visitFunction(this);
    }

    @Override
    public <C, R, E extends Exception> R accept(C context, TypeVisitorWithContext<C, R, E> visitor) throws E {
        return visitor.visitFunction(context, this);
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isValueType() {
        return false;
    }

    @Override
    public boolean isDestructible() {
        return false;
    }

    @Override
    public boolean isDestructible(Set<HighLevelDefinition> scanning) {
        return false;
    }

    @Override
    public boolean hasInferenceBlockingTypeParameters(TypeParameter[] parameters) {
        return this.header.hasInferenceBlockingTypeParameters(parameters);
    }

    @Override
    public boolean hasDefaultValue() {
        return false;
    }

    @Override
    public void extractTypeParameters(List<TypeParameter> typeParameters) {
        this.header.getReturnType().type.extractTypeParameters(typeParameters);
        for (FunctionParameter parameter : this.header.parameters) {
            parameter.type.type.extractTypeParameters(typeParameters);
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + this.header.getReturnType().hashCode();
        hash = 71 * hash + Arrays.deepHashCode(this.header.parameters);
        hash = 71 * hash + Arrays.deepHashCode(this.header.typeParameters);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionTypeID other = (FunctionTypeID)obj;
        return this.header.getReturnType().equals(other.header.getReturnType()) && Arrays.deepEquals(this.header.parameters, other.header.parameters) && Arrays.deepEquals(this.header.typeParameters, other.header.typeParameters);
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(StorageTag storage) {
        int i;
        StringBuilder result = new StringBuilder();
        result.append("function");
        if (this.header.typeParameters.length > 0) {
            result.append('<');
            for (i = 0; i < this.header.typeParameters.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.header.typeParameters[i].toString());
            }
            result.append('>');
        }
        if (storage != null && storage != ValueStorageTag.INSTANCE) {
            result.append('`');
            result.append(storage);
        }
        result.append('(');
        for (i = 0; i < this.header.parameters.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            FunctionParameter parameter = this.header.parameters[i];
            result.append(parameter.name);
            result.append(" as ");
            result.append(parameter.type);
        }
        result.append(')');
        result.append(" as ");
        result.append(this.header.getReturnType());
        return result.toString();
    }
}

