/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.statement;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.ConcatMap;
import org.openzen.zencode.shared.Taggable;
import org.openzen.zenscript.codemodel.annotations.StatementAnnotation;
import org.openzen.zenscript.codemodel.expression.ExpressionTransformer;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.statement.LoopStatement;
import org.openzen.zenscript.codemodel.statement.StatementTransformer;
import org.openzen.zenscript.codemodel.statement.StatementVisitor;
import org.openzen.zenscript.codemodel.statement.StatementVisitorWithContext;
import org.openzen.zenscript.codemodel.type.StoredType;

public abstract class Statement
extends Taggable {
    public final CodePosition position;
    public final StoredType thrownType;
    public StatementAnnotation[] annotations = StatementAnnotation.NONE;

    public Statement(CodePosition position, StoredType thrownType) {
        this.position = position;
        this.thrownType = thrownType;
    }

    public StoredType getReturnType() {
        return null;
    }

    public Statement withReturnType(TypeScope scope, StoredType returnType) {
        return this;
    }

    public abstract <T> T accept(StatementVisitor<T> var1);

    public abstract <C, R> R accept(C var1, StatementVisitorWithContext<C, R> var2);

    public abstract void forEachStatement(Consumer<Statement> var1);

    public abstract Statement normalize(TypeScope var1, ConcatMap<LoopStatement, LoopStatement> var2);

    public final Statement transform(StatementTransformer transformer) {
        return this.transform(transformer, ConcatMap.empty(LoopStatement.class, LoopStatement.class));
    }

    public abstract Statement transform(StatementTransformer var1, ConcatMap<LoopStatement, LoopStatement> var2);

    public abstract Statement transform(ExpressionTransformer var1, ConcatMap<LoopStatement, LoopStatement> var2);

    public static List<Statement> withReturnType(TypeScope scope, List<Statement> statements, StoredType returnType) {
        return statements.stream().map(statement -> statement.withReturnType(scope, returnType)).collect(Collectors.toList());
    }
}

